/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.functor;

/**
 * 一連の処理の遅延呼び出しを実行する機能を提供します。 <br>
 * <br>
 * 処理は全て invoke(Object[]) 内で完結します。 <br>
 * このインターフェースは複数のスレッドからの非同期な実行が前提と為っています。<br>
 * 実装クラスはスレッドセーフである必要があります。
 */
public interface FInvoker {

    /**
     * パラメータに基づき処理を実行し結果を返却します。
     * 
     * @param args
     *            実行パラメータ
     * @return 実行結果
     * @throws FunctorException
     *             予測外の問題から検索に失敗した場合
     */
    Object invoke(Object[] args);

}