/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.collections.decorator;

import java.util.ListIterator;

/**
 * 指定されたリスト反復子の変更不可能なビューを提供します。
 */
public class UnmodifiableListIterator extends UnmodifiableIterator implements ListIterator {

    /** 基となるリスト反復子。 */
    protected final ListIterator li;

    /**
     * ラップするリスト反復子を指定して初期化します。
     * 
     * @param i
     *            ラップするリスト反復子
     */
    public UnmodifiableListIterator(ListIterator i) {
        super(i);
        this.li = i;
    }

    /**
     * 基となるリスト反復子の同メソッドを呼び出します。
     * 
     * @see java.util.ListIterator#hasPrevious()
     */
    public boolean hasPrevious() {
        return li.hasPrevious();
    }

    /**
     * 基となるリスト反復子の同メソッドを呼び出します。
     * 
     * @see java.util.ListIterator#previous()
     */
    public Object previous() {
        return li.previous();
    }

    /**
     * 基となるリスト反復子の同メソッドを呼び出します。
     * 
     * @see java.util.ListIterator#nextIndex()
     */
    public int nextIndex() {
        return li.nextIndex();
    }

    /**
     * 基となるリスト反復子の同メソッドを呼び出します。
     * 
     * @see java.util.ListIterator#previousIndex()
     */
    public int previousIndex() {
        return li.previousIndex();
    }

    /*
     * UnsupportedOperation
     */

    /**
     * UnsupportedOperationException を発生させます。
     * 
     * @see java.util.ListIterator#set(java.lang.Object)
     */
    public void set(Object o) {
        throw new UnsupportedOperationException();
    }

    /**
     * UnsupportedOperationException を発生させます。
     * 
     * @see java.util.ListIterator#add(java.lang.Object)
     */
    public void add(Object o) {
        throw new UnsupportedOperationException();
    }
}
