/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.collections.decorator;

import java.util.Comparator;
import java.util.SortedSet;

/**
 * 指定されたソートセットを装飾するビューを提供します。 <br>
 * <br>
 * このクラスはソートセットの実装を隠蔽する目的や、装飾クラスの基底実装の役割を持ちます。<br>
 * 装飾されたソートセットが直列化可能の場合は直列化可能です。
 */
public class DecoratedSortedSet extends DecoratedSet implements SortedSet {

    /* serialVersionUID */
    private static final long serialVersionUID = -9091549218319123531L;

    /** 基となるソートセット。 */
    protected final SortedSet sortedSet;

    /**
     * ラップするセットを指定して初期化します。
     * 
     * @param s
     *            ラップするセット
     */
    public DecoratedSortedSet(SortedSet s) {
        super(s);
        this.sortedSet = s;
    }

    public Object first() {
        return sortedSet.first();
    }

    public Object last() {
        return sortedSet.last();
    }

    public Comparator comparator() {
        return sortedSet.comparator();
    }

    public SortedSet headSet(Object toElement) {
        return sortedSet.headSet(toElement);
    }

    public SortedSet tailSet(Object fromElement) {
        return sortedSet.tailSet(fromElement);
    }

    public SortedSet subSet(Object fromElement, Object toElement) {
        return sortedSet.subSet(fromElement, toElement);
    }

}
