/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.collections.decorator;

import java.util.Iterator;

/**
 * 指定された反復子を装飾するビューを提供します。 <br>
 * <br>
 * このクラスは反復子の実装を隠蔽する目的や、装飾クラスの基底実装の役割を持ちます。<br>
 */
public class DecoratedIterator implements Iterator {

    /** 基となる反復子。 */
    protected final Iterator i;

    /**
     * ラップする反復子を指定して初期化します。
     * 
     * @param i
     *            ラップする反復子
     */
    public DecoratedIterator(Iterator i) {
        if (i == null) {
            throw new NullPointerException();
        }
        this.i = i;
    }

    /**
     * 基となる反復子の同メソッドを呼び出します。
     * 
     * @see java.util.Iterator#hasNext()
     */
    public boolean hasNext() {
        return i.hasNext();
    }

    /**
     * 基となる反復子の同メソッドを呼び出します。
     * 
     * @see java.util.Iterator#next()
     */
    public Object next() {
        return i.next();
    }

    /**
     * 基となる反復子の同メソッドを呼び出します。
     * 
     * @see java.util.Iterator#remove()
     */
    public void remove() {
        i.remove();
    }
}