/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.core.beans.dynamic;

/**
 * メソッドの引数情報のリストを格納する機能を提供します。
 */
public class ArgumentsDesc extends FeatureDesc {

    /* 引数情報。 */
    private final ArgumentDesc[] arguments;

    /**
     * デフォルトコンストラクタ。
     */
    public ArgumentsDesc() {
        this(new ArgumentDesc[0]);
    }

    /**
     * 単一の引数を指定して初期化します。
     * 
     * @param arg
     *            引数の情報
     */
    public ArgumentsDesc(ArgumentDesc arg) {
        this(new ArgumentDesc[] { arg });
    }

    /**
     * 引数の配列を指定して初期化します。
     * 
     * @param args
     *            引数の情報
     */
    public ArgumentsDesc(ArgumentDesc[] args) {
        if (args == null) {
            throw new NullPointerException("argument is null.");
        }
        this.arguments = (ArgumentDesc[]) args.clone();
    }

    /*
     * Property
     */

    /**
     * 引数の値を返却します。
     * 
     * @return 引数の値
     */
    public Object[] getArgumentValues() {
        ArgumentDesc[] args = arguments;
        Object[] values = new Object[args.length];
        for (int i = 0; i < args.length; i++) {
            values[i] = args[i].getValue();
        }
        return values;
    }

    /**
     * 引数の型を返却します。
     * 
     * @return 引数の型
     */
    public Class[] getArgumentTypes() {
        ArgumentDesc[] args = arguments;
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; i++) {
            types[i] = args[i].getType();
        }
        return types;
    }

    /**
     * 引数情報の配列を返却します。
     * 
     * @return 引数情報の配列
     */
    public ArgumentDesc[] getArguments() {
        return (ArgumentDesc[]) arguments.clone();
    }
}
