/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.core.beans.dynamic;

/**
 * メソッドの引数情報を格納する機能を提供します。
 */
public class ArgumentDesc extends FeatureDesc {

    /* 引数の型。 */
    private final Class type;

    /* 引数の値。 */
    private final Object value;

    /**
     * 引数のプロパティを格納して初期化します。
     * 
     * @param type
     *            引数の型
     * @param value
     *            引数の値
     */
    public ArgumentDesc(Class type, Object value) {
        if (type == null) {
            throw new NullPointerException("type is null.");
        }
        this.type = type;
        this.value = value;
    }

    /*
     * Property
     */

    /**
     * 引数の型を返却します。
     * 
     * @return 引数の型
     */
    public Class getType() {
        return type;
    }

    /**
     * 引数の値を返却します。
     * 
     * @return 引数の値
     */
    public Object getValue() {
        return value;
    }

}
