﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Net
Imports System.IO.Ports

Public Class CustomProtocol
    Inherits Protocol

    Dim serial As SerialAsync
    Dim Header As String = ""

    Dim PortName As String
    Dim BaudRate As Integer
    Dim Parity As Parity
    Dim DataBits As Integer
    Dim StopBits As StopBits
    Dim NewLine As String
    Dim ReceivedBytesThreshold As Integer
    Dim ReadBufferSize As Integer
    Dim ReadTimeout As Integer
    Dim DtrEnable As Boolean
    Dim RtsEnable As Boolean

    Sub New(ByVal Q_Protocol As IEnumerable(Of XElement))
        Me.PortName = Q_Protocol.<PortName>.Value
        Me.BaudRate = CInt(Q_Protocol.<BaudRate>.Value)
        Me.Parity = DirectCast([Enum].Parse(GetType(Parity), Q_Protocol.<Parity>.Value), Parity)

        Me.DataBits = CInt(Q_Protocol.<DataBits>.Value)
        Me.StopBits = DirectCast([Enum].Parse(GetType(StopBits), Q_Protocol.<StopBits>.Value), StopBits)
        Me.NewLine = Q_Protocol.<NewLine>.Value
        Me.ReceivedBytesThreshold = CInt(Q_Protocol.<ReceivedBytesThreshold>.Value)
        Me.ReadBufferSize = CInt(Q_Protocol.<ReadBufferSize>.Value)
        Me.ReadTimeout = CInt(Q_Protocol.<ReadTimeout>.Value)
        Me.DtrEnable = CBool(Q_Protocol.<DtrEnable>.Value)
        Me.RtsEnable = CBool(Q_Protocol.<RtsEnable>.Value)

        'If Q_Protocol.<ServerIp>.Value Is Nothing Then
        '    MessageBox.Show("[CustomAsciiSerial.New] ServerIp in <DeviceArray><Device><Protocol>.<ServerIp> not found!")
        '    End
        'ElseIf Q_Protocol.<ServerPort>.Value Is Nothing Then
        '    MessageBox.Show("CustomAsciiSerial.New] ServerPort in <DeviceArray><Device><Protocol>.<ServerPort> not found!")
        '    End
        'End If

        serial = New SerialAsync(PortName, BaudRate, Parity, DataBits, StopBits, NewLine, ReceivedBytesThreshold, ReadBufferSize, ReadTimeout, DtrEnable, RtsEnable)
        serial.Open()

        AddHandler serial.ErrorOccured, AddressOf OnErrorOccured            ' register event handler for ErrorOccured event
        AddHandler serial.AsciiDataReceived, AddressOf OnAsciiDataReceived  ' register event handler for AsciiDataReceived event

        '<CustomCommandArray>
        Dim Q_CustomCommand As IEnumerable(Of XElement) = Q_Protocol.<CustomCommand>

        Name = Q_CustomCommand.@Name
        Type = Q_CustomCommand.@Type
        HeaderType = Q_CustomCommand.@HeaderType
        HeaderCode = Q_CustomCommand.@HeaderCode
        Delimiter = Q_CustomCommand.@Delimiter

        If Type.Equals("CustomAscii") Then
            Dim Q_CustomCommandHeaderCode As IEnumerable(Of XElement) = From i In Q_CustomCommand.<HeaderCodeArray>.<HeaderCode> Select i
            HeaderCodeArray = New Byte(Q_CustomCommandHeaderCode.Count - 1) {}

            For count2 As Integer = 0 To Q_CustomCommandHeaderCode.Count - 1
                HeaderCodeArray(count2) = CByte("&h" + Q_CustomCommandHeaderCode(count2).@Value)
            Next

            Dim Q_AsciiDataGet As IEnumerable(Of XElement) = From i In Q_CustomCommand.<AsciiDataGetArray>.<AsciiDataGet> Select i
            AsciiDataGetArray = New AsciiDataGet(Q_AsciiDataGet.Count - 1) {}

            For count2 As Integer = 0 To Q_AsciiDataGet.Count - 1
                Dim StartCount As Integer = CInt(Q_AsciiDataGet(count2).@StartCount)
                Dim ByteCount As Integer = CInt(Q_AsciiDataGet(count2).@ByteCount)
                Dim Tag As String = Q_AsciiDataGet(count2).@Tag
                AsciiDataGetArray(count2) = New AsciiDataGet(StartCount, ByteCount, Tag)

                Try
                    AsciiDataGetArrayHt.Add(Tag, count2)
                Catch ArgumentNullException As ArgumentNullException
                    MessageBox.Show("[CustomProtocol.New] AsciiDataGet.Tag is not defined at AsciiDataGetArray[" + CStr(count2) + "].")
                    End
                Catch ArgumentException As ArgumentException
                    MessageBox.Show("[CustomProtocol.New] Tag= " + Tag + " is duplicated in <Device>.<Protocol>.<CustomCommand>.<AsciiDataGetArray>.")
                    End
                End Try
            Next


            CustomCommand = New CustomCommand(Name, Type, HeaderCodeArray, AsciiDataGetArray)

            If HeaderType.Equals("AsciiCodeArray") Then
                DataLengthWish = HeaderCodeArray.GetLength(0) + AsciiDataGetArray(AsciiDataGetArray.Length - 1).StartCount + AsciiDataGetArray(AsciiDataGetArray.Length - 1).ByteCount
            ElseIf HeaderType.Equals("String") Then
                DataLengthWish = HeaderCode.Length + AsciiDataGetArray(AsciiDataGetArray.Length - 1).StartCount + AsciiDataGetArray(AsciiDataGetArray.Length - 1).ByteCount
            Else
                MessageBox.Show("Invalid value in <Device>.<Protocol>.<CustomCommand>.@HeaderType.")
                End
            End If
        ElseIf Type.Equals("SeparableAscii") Then
            MessageBox.Show("<Device>.<Protocol>.<CustomCommand>.@HType = SeparableAscii not implemented.")
            End
        Else
            MessageBox.Show("Invalid value in <Device>.<Protocol>.<CustomCommand>.@Type.")
            End
        End If
    End Sub

    Public Function SearchAsciiDataGetArrayHt(ByVal DataItemTag As String, ByRef ht As Integer) As Integer
        Dim ret As Object

        ret = AsciiDataGetArrayHt(DataItemTag)

        If ret IsNot Nothing Then
            ht = CInt(ret)
            Return 0
        Else
            ht = -1
            Return -1
        End If
    End Function


    Public Overrides Function Connect() As Integer
        Dim result As Integer = serial.Open
        Return result
    End Function

    Public Overrides Function Disconnect() As Integer
        Dim result As Integer = serial.Close
        Return result
    End Function

    ' event handler for AsciiDataReceived event
    Public Sub OnAsciiDataReceived(ByVal sender As SerialAsync, ByVal RecvData As String)
        Dim RecvData2 As String = Nothing
        Dim AsciiDataArray() As String = Nothing

        If Type.Equals("CustomAscii") Then
            If RecvData.Length = DataLengthWish Then
                If HeaderType.Equals("AsciiCodeArray") Then
                    RecvData2 = RecvData.Substring(HeaderCodeArray.GetLength(0), DataLengthWish - HeaderCodeArray.GetLength(0))
                ElseIf HeaderType.Equals("String") Then
                    RecvData2 = RecvData.Substring(HeaderCode.Length, DataLengthWish - HeaderCode.Length)
                Else
                    MessageBox.Show("Invalid value in <Device>.<Protocol>.<CustomCommand>.@HeaderType")
                End If

				Try
                    For Count As Integer = 0 To AsciiDataGetArray.GetLength(0) - 1
                        AsciiDataGetArray(Count).Value = Double.Parse(RecvData2.Substring(AsciiDataGetArray(Count).StartCount, AsciiDataGetArray(Count).ByteCount))
                    Next
                    hAsciiDataReceived(Me)                         ' establish AsciiDataReceived event
                Catch FormatException As FormatException
                End Try
            Else
                hErrorOccured(Me, "RecvLengthError")
            End If
        ElseIf Type.Equals("SeparableAascii") Then
            If RecvData.Length = DataLengthWish Then
                If HeaderType.Equals("AsciiCodeArray") Then
                    RecvData2 = RecvData.Substring(HeaderCodeArray.GetLength(0), DataLengthWish - HeaderCodeArray.GetLength(0))
                ElseIf HeaderType.Equals("String") Then
                    RecvData2 = RecvData.Substring(HeaderCode.Length, DataLengthWish - HeaderCode.Length)
                Else
                    MessageBox.Show("Invalid value in <Device>.<Protocol>.<CustomCommand>.@HeaderType")
                End If

                AsciiDataArray = RecvData2.Split(CChar(Delimiter))
                For count As Integer = 0 To AsciiDataGetArray.GetLength(0) - 1
                    AsciiDataGetArray(count).Value = Double.Parse(AsciiDataArray(count))
                Next

                hAsciiDataReceived(Me)                         ' establish AsciiDataReceived event
            Else
                hErrorOccured(Me, "RecvLengthError")
            End If
        Else
            MessageBox.Show("Invalid value in <Device>.<Protocol>.<CustomCommand>.@Type")
            End
        End If

    End Sub

    ' error handler for BinaryDataReceived event
    Private Sub OnBinaryDataReceived(ByVal sender As SerialAsync, ByVal Data() As Int32, ByVal MessageLength As Integer)
        Dim ByteDataArray() As Int32 = Nothing

        hBinaryDataReceived(Me, ByteDataArray)                         ' establish BinaryDataReceived event
    End Sub


    ' error handler for ErrorOccured event
    Private Sub OnErrorOccured(ByVal sender As SerialAsync, ByVal Content As String)
        hErrorOccured(Me, Content)                         ' establish ErrorOccured event
    End Sub

    Private Function MakeDispData(ByVal Data As String, ByVal DataLength As Integer) As String
        Dim DispData As String = ""

        For count As Integer = 0 To DataLength - 2
            DispData = DispData + Strings.Right("00" + Hex(Data(count)), 2) + " "
        Next
        DispData = DispData + Strings.Right("00" + Hex(Data(DataLength - 1)), 2)

        Return DispData
    End Function
End Class