﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Net

Public Class BinaryTcpClientOut
    Dim conn As TcpClientSync
    Dim err As String = ""

    Dim ServerIp As IPAddress
    Dim ServerPort As Integer
    Dim kernel As Kernel

    Public Sub New(kernel As Kernel, ServerIp As String, ServerPort As Integer)
        Me.ServerIp = IPAddress.Parse(ServerIp)
        Me.ServerPort = ServerPort
        Me.kernel = kernel

        conn = New TcpClientSync()
        'Connect()
    End Sub

    Public Function GetError() As String
        Dim ret As String = err
        err = ""
        GetError = ret
    End Function

    Public Function Connect() As Integer
        Dim result As Integer = conn.Connect(ServerIp, ServerPort)
        If result = -1 Then
            err = "Connection failed."
        End If
        Connect = result
    End Function

    Public Function Disconnect() As Integer
        Dim result As Integer = conn.Close()
        Return result
    End Function


    ' send all data to client
    Public Function SendAllData() As Integer
        Dim ReplyData() As Byte
        Dim MsgLen As Integer = 4 + 2 * kernel.DeviceArray(0).WordGetArray.GetLength(0) + 2 * (kernel.DeviceArray(0).SixteenBitsGetArray.GetLength(0))
        ReDim ReplyData(MsgLen - 1)

        ReplyData(0) = CByte(MsgLen \ 256)
        ReplyData(1) = CByte(MsgLen Mod 256)
        ReplyData(2) = &H1   ' command
        ReplyData(3) = &H0   ' result code

        ' analog value (2bytex50points)
        For count As Integer = 0 To kernel.DeviceArray(0).WordGetArray.GetLength(0) - 1
            ReplyData(4 + 2 * count) = CByte(kernel.DeviceArray(0).WordGetArray(count).Value \ 256)
            ReplyData(4 + 2 * count + 1) = CByte(kernel.DeviceArray(0).WordGetArray(count).Value Mod 256)
        Next

        ' digital value (8bit/bytesx60bytes)
        For count As Integer = 0 To kernel.DeviceArray(0).SixteenBitsGetArray.GetLength(0) - 1
            ReplyData(4 + 2 * kernel.DeviceArray(0).WordGetArray.GetLength(0) + 2 * count) = CByte(kernel.DeviceArray(0).SixteenBitsGetArray(count).Value \ 256)
            ReplyData(4 + 2 * kernel.DeviceArray(0).WordGetArray.GetLength(0) + 2 * count + 1) = CByte(kernel.DeviceArray(0).SixteenBitsGetArray(count).Value Mod 256)
        Next

        'ReDim ReplyData(162)
        'ReplyData(0) = CByte(162 \ 256)
        'ReplyData(1) = CByte(162 Mod 256)
        'ReplyData(2) = &H0   ' result code 1/2
        'ReplyData(3) = &H0   ' result code 2/2

        '' analog value (2bytex50points)
        'For count As Integer = 0 To 49
        '    Int16Value = CShort(kernel.DeviceArray(0).WordGetArray(count).Value)
        '    ReplyData(4 + 2 * count) = CByte(kernel.DeviceArray(0).WordGetArray(count).Value \ 256)
        '    ReplyData(4 + 2 * count + 1) = CByte(kernel.DeviceArray(0).WordGetArray(count).Value Mod 256)
        'Next

        '' digital value (8bit/bytesx60bytes)
        'For count As Integer = 0 To 29
        '    Int16Value = CShort(kernel.DeviceArray(0).SixteenBitsGetArray(count).Value)
        '    ReplyData(104 + 2 * count) = CByte(kernel.DeviceArray(0).SixteenBitsGetArray(count).Value \ 256)
        '    ReplyData(104 + 2 * count + 1) = CByte(kernel.DeviceArray(0).SixteenBitsGetArray(count).Value Mod 256)
        'Next

        conn.Send(ReplyData)

        Return 0
    End Function
End Class
