﻿Public Class NetworkDrive
    Public Declare Function WNetAddConnection2 Lib "mpr.dll" Alias "WNetAddConnection2A" (ByRef lpNetResource As NETRESOURCE, ByVal lpPassword As String, ByVal lpUserName As String, ByVal dwFlags As Integer) As Integer
    Private Declare Function WNetCancelConnection2 Lib "mpr.dll" Alias "WNetCancelConnection2A" (ByVal lpName As String, ByVal dwFlags As Integer, ByVal fForce As Integer) As Integer

    Public Structure NETRESOURCE
        Public dwScope As Integer
        Public dwType As Integer
        Public dwDisplayType As Integer
        Public dwUsage As Integer
        Public lpLocalName As String
        Public lpRemoteName As String
        Public lpComment As String
        Public lpProvider As String
    End Structure

    Private Const RESOURCE_CONNECTED As Integer = &H1
    Private Const RESOURCETYPE_ANY As Integer = &H0
    Private Const RESOURCEDISPLAYTYPE_SHARE As Integer = &H3
    Private Const CONNECT_UPDATE_PROFILE As Integer = &H1


    Public Function Create(ByVal pstrRemoteName As String, ByVal pstrUID As String, ByVal pstrPWD As String, ByVal LocalName As String) As Integer
        Dim typNetResource As NETRESOURCE = Nothing
        Dim ret As Integer

        With typNetResource
            .dwScope = RESOURCE_CONNECTED
            .dwType = RESOURCETYPE_ANY
            .dwDisplayType = RESOURCEDISPLAYTYPE_SHARE
            .lpLocalName = LocalName
            .lpRemoteName = pstrRemoteName
        End With

        Console.WriteLine(typNetResource.lpLocalName)
        Console.WriteLine(typNetResource.lpRemoteName)

        ret = WNetAddConnection2(typNetResource, pstrPWD, pstrUID, CONNECT_UPDATE_PROFILE)
        Return ret
    End Function

    Public Function Dispose(ByVal pstrRemoteName As String) As Integer
        Dim ret As Integer

        ret = WNetCancelConnection2(pstrRemoteName, CONNECT_UPDATE_PROFILE, 1)

        Return ret
    End Function
End Class
