﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System
Imports System.Windows
Imports System.Windows.Interop
Imports System.Runtime.InteropServices
Imports System.IO
Imports System.Text

Public Class MainWindow
    Dim Kernel As Kernel

    Dim OriginalWidth As Double
    Dim OriginalHeight As Double

    Private Const MF_BYCOMMAND As Integer = &H0&
    Private Const SC_CLOSE As Integer = &HF060&

    <DllImport("User32")> _
    Public Shared Function RemoveMenu(ByVal hMenu As IntPtr, ByVal uPosition As UInteger, ByVal uFlags As UInteger) As Boolean
    End Function

    <DllImport("User32")> _
    Public Shared Function GetSystemMenu(ByVal hWnd As IntPtr, ByVal bRevert As Boolean) As IntPtr
    End Function

    <DllImport("User32")> _
    Public Shared Function DrawMenuBar(ByVal hWnd As IntPtr) As Long
    End Function

    Private Sub AddMsg(ByVal msg As String, ByVal flag As Boolean)
        Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + msg, True)
    End Sub

    Public Sub New()
        MyBase.New()

        Me.InitializeComponent()
        Init()
    End Sub

    Private Sub Init()
        OriginalWidth = Me.Width
        OriginalHeight = Me.Height

        Me.MinWidth = OriginalWidth / 2
        Me.MinHeight = OriginalHeight / 2
    End Sub

    Private Sub Window_Loaded(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles Window.Loaded
        Kernel = New Kernel(Me)

        'If Kernel.MailSendFlag = 1 Then
        '    chkSendMail.IsChecked = True
        'Else
        '    chkSendMail.IsChecked = False
        'End If

        '' in case using DataSet
        'Dim DataSet1 As sample_basic.DataSet1 = CType(Me.FindResource("DataSet1"), sample_basic.DataSet1)
        'Dim Row As System.Data.DataRow = Nothing

        'For i As Integer = 0 To 399
        '    Row = DataSet1.DataTable1.AddDataTable1Row((i + 1).ToString(), Nothing, Nothing, Nothing, Nothing, Nothing, Nothing, Nothing, Nothing, Nothing, Nothing)
        'Next

        'ReadDataTable()
    End Sub

    Private Sub Window_SizeChanged(ByVal sender As System.Object, ByVal e As System.Windows.SizeChangedEventArgs) Handles Window.SizeChanged
        Dim AdjustScale As System.Windows.Media.ScaleTransform = New System.Windows.Media.ScaleTransform()

        AdjustScale.ScaleX = (Me.Width - 20) / (OriginalWidth - 20)
        AdjustScale.ScaleY = (Me.Height - 40) / (OriginalHeight - 40)

        Me.Height = AdjustScale.ScaleX * OriginalHeight

        CV.RenderTransform = AdjustScale
    End Sub

    Private Sub Window_Unloaded(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles Window.Unloaded
        MessageBox.Show("Closing Application", "Confirm", MessageBoxButton.OK)

        '' Better write disconnection code here

        End
    End Sub

    Private Sub Exit_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs) Handles [Exit].Click
        If MessageBox.Show("Close Application?", "Confirm", MessageBoxButton.OKCancel) = MessageBoxResult.OK Then
            AddMsg("[MainWindow.Exit_Click] Application close.", True)

            '' Better write disconnection code here

            Me.Close()
            End
        End If
    End Sub

    Private Sub ShowLog_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs) Handles ShowLog.Click
        Kernel.GetWindow(Of LOGMSG)("LOGMSG").Show()
    End Sub

    '' (Example) Open sdditional form
    'Private Sub Win2Open_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs) Handles Win2Open.Click
    '    DirectCast(Kernel.WindowHashTable("Window2"), System.Windows.Window).Show()
    'End Sub

    '********************************************************************************************

    '' (Example) bit manipulation(One address, confirm before writing)
    'Private Sub Valve001_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs) Handles Valve001.Click
    '    ' create dialog instance
    '    ' set button caption, "OPEN","CLOSE". and, and set/reset the bit item  Tag="VALVE001_SET".
    '    Dim TwoButtons As TwoButtons_SetBit = New TwoButtons_SetBit(Kernel, "Valve manipulation", "valve001", "OPEN", "CLOSE", "TEST_PLC", "VALVE001_SET", False)
    '    ' Open dialog
    '    TwoButtons.Show()
    'End Sub

    '' (Example) bit on
    'Private Sub Valve001_open_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs) Handles Valve001_open.Click
    '    CType(Kernel.SearchDevice("TEST_PLC"), PLC).SetBit(New String() {"VALVE001_SET"}, 1, True)
    'End Sub

    '' (Example) bit off
    'Private Sub Valve001_close_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs) Handles Valve001_open.Click
    '    CType(Kernel.SearchDevice("TEST_PLC"), PLC).SetBit(New String() {"VALVE001_SET"}, 0, True)
    'End Sub

    '' (Example) bit manupulation(In case manipulation 2 bits using dialog)
    'Private Sub Valve001_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs) Handles MV11.Click
    '    Dim TwoButtons As TwoButtons2 = New TwoButtons2(Kernel, "バルブ操作", "Valve001", "OPEN", "CLOSE", New String() {"VALVE001_OPEN", "VALVE001_CLOSE"}, False)
    '    TwoButtons.Show()
    'End Sub

    '' (Example) bit manipulation(In case using YesNo dialog)
    'Private Sub ALM_CLEAR_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs) Handles ALM_CLEAR.Click
    '    Dim YesNo As YesNo = New YesNo(Kernel, "操作確認", "アラームをクリアしますか？", "TEST_PLC", "ALM_CLEAR", "SetReset")
    '    YesNo.Show()
    'End Sub

    '********************************************************************************************

    '' (Example) Analog data setting
    'Private Sub flow001_execute_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs) Handles flow001_execute.Click
    '    Dim CheckedValue As Double

    '    ' Conver the textbox data into double
    '    ' Check the limitation range(0-100) and data format.
    '    If SharedFunctions.CheckValue(Of Double)("FLOW001_SET", flow001_input.Text, 0, 100, CheckedValue) = 0 Then
    '        ' set word data to PLC address
    '        AddMsg("[MainWindow.flow001_execute_Click] Trying to set value. FLOW001_SET=" + CheckedValue.ToString(), True)
    '        Kernel.SearchDevice("TEST_PLC").SetWord("FLOW001_SET", CUShort(CheckedValue / 100 * 4000), True)
    '    End If
    'End Sub

    '' (Example) convert input data into BCD and set to PLC
    'Private Sub VALUE_SET_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs) Handles VALUE_SET.Click
    '    Dim CheckedValue As UInteger
    '    Dim RetValue As UInt16

    '    If SharedFunctions.CheckValue(Of UInteger)(VALUE_input.Text, 0, 999900, CheckedValue) = 0 Then
    '        If SharedFunctions.DecToBCD(CUShort(CheckedValue / 100), RetValue) = 0 Then
    '            Kernel.SetWord("VALUE", RetValue, True)
    '        Else
    '            MessageBox.Show("[VALUE_SET_Click] DecToBCD failed.")
    '        End If
    '    End If
    'End Sub

    '' (Example) In case setting DataSet value
    'Private Sub SetArray_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs) Handles SetArray.Click
    '    Dim DataSet1 As sample_basic.DataSet1 = CType(Me.FindResource("DataSet1"), EchMirrorControl.DataSet1)
    '    Dim Xarray() As UShort = New UShort(399) {}
    '    Dim Yarray() As UShort = New UShort(399) {}
    '    Dim CheckedValue As UShort

    '    For count As Integer = 0 To 399
    '        If SharedFunctions.CheckValue(Of UShort)("X[" + (count + 1).ToString() + "]", _
    '                                                 DataSet1.DataTable1.Rows(count).Item("X"), _
    '                                                 0, _
    '                                                 100, _
    '                                                 CheckedValue) = 0 Then

    '            Xarray(count) = CheckedValue
    '        Else
    '            Exit Sub
    '        End If

    '        If SharedFunctions.CheckValue(Of UShort)("Y[" + (count + 1).ToString() + "]", _
    '                                                 DataSet1.DataTable1.Rows(count).Item("Y"), _
    '                                                 0, _
    '                                                 100, _
    '                                                 CheckedValue) = 0 Then

    '            Yarray(count) = CheckedValue
    '        Else
    '            Exit Sub
    '        End If
    '    Next

    '    Kernel.SetWords("X001", Xarray, True)
    '    Kernel.SetWords("Y001", Yarray, True)
    'End Sub



    'Private Sub MI_TrendGraph_Click(sender As System.Object, e As System.Windows.RoutedEventArgs) Handles MI_trendgraph.Click
    '    Kernel.GetWindow(Of SelectGraphItemDataGroup)("SelectGraphItemDataGroup").Show()
    'End Sub

    'Private Sub MI_SelectData_Click(sender As System.Object, e As System.Windows.RoutedEventArgs) Handles MI_SelectData.Click
    '    Kernel.GetWindow(Of SelectData)("SelectData").Show()
    'End Sub

    'Private Sub MI_AlarmAnalog_Click(sender As System.Object, e As System.Windows.RoutedEventArgs) Handles MI_AlarmAnalog.Click
    '    Kernel.GetWindow(Of AlarmAnalog)("AlarmAnalog").Show()
    'End Sub

    'Private Sub MI_AlarmDigital_Click(sender As System.Object, e As System.Windows.RoutedEventArgs) Handles MI_AlarmDigital.Click
    '    Kernel.GetWindow(Of AlarmDigital)("AlarmDigital").Show()
    'End Sub

    'Private Sub MI_MailSettingWindow_Click(sender As System.Object, e As System.Windows.RoutedEventArgs) Handles MI_MailSettingWindow.Click
    '    Kernel.GetWindow(Of MailSettingWindow)("MailSettingWindow").Show()
    'End Sub



    'Private Sub chkSendMail_Checked(sender As System.Object, e As System.Windows.RoutedEventArgs) Handles chkSendMail.Checked
    '    Dim doc As XDocument = XDocument.Load("System.xml")
    '    Dim Q_MailSetting As IEnumerable(Of XElement) = From i In doc.<SystemRoot>.<ParameterArray>.<MailSetting> Select i
    '    Q_MailSetting(0).@MailSendFlag = "1"

    '    Kernel.MailSendFlag = 1
    '    'doc.Save("..\\..\\System.xml")
    '    doc.Save("System.xml")
    'End Sub

    'Private Sub chkSendMail_Unchecked(sender As System.Object, e As System.Windows.RoutedEventArgs) Handles chkSendMail.Unchecked
    '    Dim doc As XDocument = XDocument.Load("System.xml")
    '    Dim Q_MailSetting As IEnumerable(Of XElement) = From i In doc.<SystemRoot>.<ParameterArray>.<MailSetting> Select i
    '    Q_MailSetting(0).@MailSendFlag = "0"

    '    Kernel.MailSendFlag = 0
    '    'doc.Save("..\\..\\System.xml")
    '    doc.Save("System.xml")
    'End Sub
End Class