﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Threading
Imports System.IO
Imports System.Text
'Imports System.Net

''' <summary>
''' Initially generated class
''' </summary>
''' <remarks></remarks>
Public Class Kernel
    Private trd As Thread

    Public TicksMilliSecond As Integer                          ' Minimum cyclic period(msec)
    Public AcquisitionAsyncFlag As Boolean = False              ' True: Async or False: Sync
    Public AcquisitionCycleMilliSecond As Integer               ' Data acquisition cycle (msec)
    Public ArchiveCycleMilliSecond As Integer                   ' Data archiving Cycle (msec)
    Public MailSendFlag As Integer                              ' 0: Stop mail or 1:Send mail
    Public MailServer As String                                 ' Mailserver name (SMTP server name)
    Public MailFrom As String                                   ' MaiFrom
    Public SubjectHeader As String                              ' SubjectHeader

    Public MailDestinationArray() As MailDestination            ' Mail destination

    Public DataLogFolderArray() As String                       ' Folders to save acquired data
    Public OperationLogFolderArray() As String                  ' Folders to save operational log data
    Public WindowInfoArray() As WindowInfo                     ' Instance od WindowInfo class
    Public WindowHashTable As Hashtable = New Hashtable         ' Hash table of window instance

    Public DeviceArray() As Device                              ' Device instances are stored
    Public ComStatus() As Label                                 ' Indicater for communication status.

    Private CalcDelegates As CalcDelegates
    Private ShowDelegates As ShowDelegates
    Private ChangedDelegates As ChangedDelegates

    Public LogSettingType As Integer                             ' [RawData:0] by WordGet/BitGet [PhysicalData:1] by RealData/LogicalItem [DataGroup:2] by DataGroup
    Public DataGroupArray() As DataGroup                        ' Groups of engineering value
    Public RealDataArray() As RealData                          ' Real data list
    Public RealDataArrayHt As Hashtable = New Hashtable         ' RealData index 
    Public LogicalItemArray() As LogicalItem                    ' LogicalItem list
    Public LogicalItemArrayHt As Hashtable = New Hashtable      ' LogicalItem index

    Public SMTPmail As SMTPmail

    Delegate Sub delTicks()                                     ' Delegate for Ticks event
    Public Event evtTicks As delTicks                           ' Ticks event

    Public WithEvents em As EventManager

    'Private BinaryTcpServerOut As BinaryTcpServerOut           ' In case using BinaryTcpServerOut
    'Public BinaryTcpClientOut As BinaryTcpClientOut            ' In case using push type data communication
    'Private NetworkDrive As NetworkDrive = New NetworkDrive()  ' In case of using network drive

    ''' <summary>
    ''' Thread safe callback routine and delegate for capture window
    ''' </summary>
    ''' <param name="WindowName"></param>
    ''' <param name="filename"></param>
    ''' <remarks></remarks>
    Delegate Sub CaptureWindowCallback(ByVal WindowName As String, ByVal filename As String)
    Public Sub CaptureWindow(ByVal WindowName As String, ByVal filename As String)
        Dim target As Window = GetWindow(Of Window)(WindowName)

        If target.Dispatcher.CheckAccess() Then
            target.Show()

            Dim bmp As RenderTargetBitmap = New RenderTargetBitmap(CInt(target.ActualWidth), CInt(target.ActualHeight), 96, 96, PixelFormats.Pbgra32)
            bmp.Render(target)

            Dim encoder As PngBitmapEncoder = New PngBitmapEncoder()
            encoder.Frames.Add(BitmapFrame.Create(bmp))

            Dim fs As FileStream = New FileStream(".\\Capture\\" + filename, FileMode.Create, FileAccess.Write)
            encoder.Save(fs)
            fs.Close()
        Else
            target.Dispatcher.Invoke(New CaptureWindowCallback(AddressOf CaptureWindow), New Object() {WindowName, filename})
        End If
    End Sub

    ''' <summary>
    ''' Thread safe callback routine and delegate for change text
    ''' </summary>
    ''' <param name="Control"></param>
    ''' <param name="Text"></param>
    ''' <remarks></remarks>
    Delegate Sub ChangeTextCallback(ByVal Control As System.Windows.Controls.Control, ByVal Text As String)
    Public Sub ChangeText(ByVal Control As System.Windows.Controls.Control, ByVal Text As String)
        If Control.Dispatcher.CheckAccess() Then
            If TypeOf Control Is Label Then
                DirectCast(Control, System.Windows.Controls.Label).Content = Text
            ElseIf TypeOf Control Is TextBox Then
                DirectCast(Control, System.Windows.Controls.TextBox).Text = Text
            ElseIf TypeOf Control Is Button Then
                DirectCast(Control, System.Windows.Controls.Button).Content = Text
            End If
        Else
            Control.Dispatcher.Invoke(New ChangeTextCallback(AddressOf ChangeText), New Object() {Control, Text})
        End If
    End Sub

    ''' <summary>
    ''' Thread safe callback routine and delegate for change visibility
    ''' </summary>
    ''' <param name="Control"></param>
    ''' <param name="Visibility"></param>
    ''' <remarks></remarks>
    Delegate Sub ChangeVisibilityCallback(ByVal Control As System.Windows.Controls.Control, ByVal Visibility As String)
    Public Sub ChangeVisibility(ByVal Control As System.Windows.Controls.Control, ByVal Visibility As String)
        If Control.Dispatcher.CheckAccess() Then
            If Visibility = "Visible" Then
                Control.Visibility = Windows.Visibility.Visible
            ElseIf Visibility = "Hidden" Then
                Control.Visibility = Windows.Visibility.Hidden
            End If
        Else
            Control.Dispatcher.Invoke(New ChangeVisibilityCallback(AddressOf ChangeVisibility), New Object() {Control, Visibility})
        End If
    End Sub

    ''' <summary>
    ''' Thread safe callback routine and delegate for change style
    ''' </summary>
    ''' <param name="control"></param>
    ''' <param name="style"></param>
    ''' <remarks></remarks>
    Delegate Sub ChangeStyleCallback(ByVal [control] As System.Windows.Controls.Control, ByVal [style] As String)
    Public Sub ChangeStyle(ByVal [control] As Control, ByVal [style] As String)
        If [control].Dispatcher.CheckAccess() Then
            [control].Style = DirectCast(DirectCast(WindowHashTable("MainWindow"), MainWindow).FindResource([style]), Style)
            '[control].Style = DirectCast(DirectCast(GetWindow("MainWindow"), System.Windows.Window).FindResource([style]), Style)
        Else
            [control].Dispatcher.Invoke(New ChangeStyleCallback(AddressOf ChangeStyle), New Object() {[control], [style]})
        End If
    End Sub

    ''' <summary>
    ''' Add message to the LOGMSG window
    ''' </summary>
    ''' <param name="msg"></param>
    ''' <param name="flag"></param>
    ''' <remarks></remarks>
    Public Sub AddMsg(ByVal msg As String, ByVal flag As Boolean)
        GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + msg, True)
    End Sub

    ''' <summary>
    ''' Get window instance
    ''' </summary>
    ''' <typeparam name="T"></typeparam>
    ''' <param name="TagName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetWindow(Of T)(ByVal TagName As String) As T
        Return DirectCast(WindowHashTable(TagName), T)
    End Function

    ''' <summary>
    ''' Constructor
    ''' </summary>
    ''' <param name="MainWindow"></param>
    ''' <remarks></remarks>
    Sub New(ByVal MainWindow As MainWindow)
        '' In case need connection to network drive
        'NetworkDrive.Dispose("Z:")
        'Dim ret As Integer = NetworkDrive.Create("\\192.168.0.1\public", "username", "password", "Z:")
        'If ret <> 0 Then
        '    MessageBox.Show("Failed to connect to the network drive")
        'End If
        ''

        WindowHashTable("MainWindow") = MainWindow
        CalcDelegates = New CalcDelegates(Me)
        ShowDelegates = New ShowDelegates(Me)
        ChangedDelegates = New ChangedDelegates(Me)

        'BinaryTcpClientOut = New BinaryTcpClientOut(Me, "127.0.0.1", 12000)

        ReadXML()

        '' In case User need to show connectiuon status to PLCs by button color
        ' ComStatus = New Label() {GetWindow("MainWindow").ComStatus1, GetWindow("MainWindow").ComStatus2}
        ComStatus = New Label() {GetWindow(Of MainWindow)("MainWindow").ComStatus}
        ''

        SMTPmail = New SMTPmail(Me, "mailserver")

        em = New EventManager(Me)

        trd = New Thread(AddressOf TimerThreadTask)
        trd.IsBackground = True
        trd.Start()


        'BinaryTcpServerOut = New BinaryTcpServerOut(Me)
    End Sub

    ''' <summary>
    ''' Search Window instance with Tag and create instance
    ''' </summary>
    ''' <param name="Tag"></param>
    ''' <remarks></remarks>
    Sub LoadWindow(ByVal Tag As String)
        Dim MatchCount As Integer = -1

        For count As Integer = 0 To WindowInfoArray.Count - 1
            If WindowInfoArray(count).Tag = Tag Then
                MatchCount = count
                Exit For
            End If
        Next

        If MatchCount = -1 Then
            MessageBox.Show("[LoadWindow] Tag string didn't Match.(" + Tag + ")")
        Else
            WindowHashTable(Tag) = WindowInfoArray(MatchCount).CreateInstance(New Object() {Me})
            If WindowInfoArray(MatchCount).OpenMode = "Visible" Then
                DirectCast(WindowHashTable(Tag), System.Windows.Window).Show()
            End If
        End If
    End Sub

    ''' <summary>
    ''' Replace specific string into different string 
    ''' </summary>
    ''' <param name="Original"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Function ReplaceString(ByVal Original As String) As String
        Return Original.Replace("%MyDocuments%", Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments))
    End Function

    ''' <summary>
    ''' Read System.xml
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub ReadXML()
        If File.Exists("System.xml") Then
            Dim doc As XDocument = XDocument.Load("System.xml")

            '<ParameterArray>
            If doc.<SystemRoot>.<ParameterArray>.<AcquisitionAsyncFlag>.@Value IsNot Nothing Then
                AcquisitionAsyncFlag = CBool((From i In doc.<SystemRoot>.<ParameterArray>.<AcquisitionAsyncFlag> Select i)(0).@Value)
            Else
                AcquisitionAsyncFlag = False
            End If

            TicksMilliSecond = CInt(doc.<SystemRoot>.<ParameterArray>.<TicksMilliSecond>.@Value)
            AcquisitionCycleMilliSecond = CInt((From i In doc.<SystemRoot>.<ParameterArray>.<AcquisitionCycleMilliSecond> Select i)(0).@Value)
            ArchiveCycleMilliSecond = CInt((From i In doc.<SystemRoot>.<ParameterArray>.<ArchiveCycleMilliSecond> Select i)(0).@Value)

            Dim Q_MailSetting As IEnumerable(Of XElement) = From i In doc.<SystemRoot>.<ParameterArray>.<MailSetting> Select i

            If Q_MailSetting.Count = 0 Then
                MailSendFlag = 0
            Else
                MailSendFlag = CInt(Q_MailSetting(0).@MailSendFlag)

                If (From i In doc.<SystemRoot>.<ParameterArray>.<MailSetting> Select i)(0) IsNot Nothing Then
                    MailSendFlag = CInt((From i In doc.<SystemRoot>.<ParameterArray>.<MailSetting> Select i)(0).@MailSendFlag)
                    MailServer = (From i In doc.<SystemRoot>.<ParameterArray>.<MailSetting> Select i)(0).@MailServer
                    MailFrom = (From i In doc.<SystemRoot>.<ParameterArray>.<MailSetting> Select i)(0).@MailFrom
                    SubjectHeader = (From i In doc.<SystemRoot>.<ParameterArray>.<MailSetting> Select i)(0).@SubjectHeader

                    Dim Q_MailDestination As IEnumerable(Of XElement) = From i In doc.<SystemRoot>.<ParameterArray>.<MailSetting>.<MailDestination> Select i
                    MailDestinationArray = New MailDestination(Q_MailDestination.Count - 1) {}

                    For count As Integer = 0 To Q_MailDestination.Count - 1
                        Dim MailDestinationMailSendFlag As Integer = CInt(Q_MailDestination(count).@MailSendFlag)
                        Dim MailDestinationCaptureAttached As Integer = CInt(Q_MailDestination(count).@CaptureAttached)
                        Dim MailDestinationReminderEnabled As Integer = CInt(Q_MailDestination(0).@ReminderEnabled)
                        Dim MailDestinationReminderIntervalSec As Integer = CInt(Q_MailDestination(0).@ReminderIntervalSec)

                        Dim Q_To As IEnumerable(Of XElement) = From i In Q_MailDestination(count).<ToArray>.<MailAddress> Select i
                        Dim ToArray() As MailAddress = New MailAddress(Q_To.Count - 1) {}
                        For count2 As Integer = 0 To Q_To.Count - 1
                            ToArray(count2) = New MailAddress(Q_To(count2).@Name, Q_To(count2).@Address)
                        Next

                        Dim Q_Cc As IEnumerable(Of XElement) = From i In Q_MailDestination(count).<CcArray>.<MailAddress> Select i
                        Dim CcArray() As MailAddress = New MailAddress(Q_Cc.Count - 1) {}
                        For count2 As Integer = 0 To Q_Cc.Count - 1
                            CcArray(count2) = New MailAddress(Q_Cc(count2).@Name, Q_Cc(count2).@Address)
                        Next

                        Dim Q_Bcc As IEnumerable(Of XElement) = From i In Q_MailDestination(count).<BccArray>.<MailAddress> Select i
                        Dim BccArray() As MailAddress = New MailAddress(Q_Bcc.Count - 1) {}
                        For count2 As Integer = 0 To Q_Bcc.Count - 1
                            BccArray(count2) = New MailAddress(Q_Bcc(count2).@Name, Q_Bcc(count2).@Address)
                        Next

                        MailDestinationArray(count) = New MailDestination(MailDestinationMailSendFlag, MailDestinationCaptureAttached, MailDestinationReminderEnabled, MailDestinationReminderIntervalSec, ToArray, CcArray, BccArray)
                    Next
                End If
            End If

            Dim Q_DataLogFolder As IEnumerable(Of XElement) = From i In doc.<SystemRoot>.<ParameterArray>.<LogSetting>.<DataLogFolderArray>.<DataLogFolder> Select i
            DataLogFolderArray = New String(Q_DataLogFolder.Count - 1) {}

            For count As Integer = 0 To Q_DataLogFolder.Count - 1
                DataLogFolderArray(count) = ReplaceString(Q_DataLogFolder(count).@Value)
                If Not System.IO.Directory.Exists(DataLogFolderArray(count)) Then
                    MessageBox.Show("Data log folder does not exist. (" + DataLogFolderArray(count) + ")")
                    End
                End If
            Next

            Dim Q_OperationLogFolder As IEnumerable(Of XElement) = From i In doc.<SystemRoot>.<ParameterArray>.<LogSetting>.<OperationLogFolderArray>.<OperationLogFolder> Select i
            OperationLogFolderArray = New String(Q_OperationLogFolder.Count - 1) {}

            For count As Integer = 0 To Q_OperationLogFolder.Count - 1
                OperationLogFolderArray(count) = ReplaceString(Q_OperationLogFolder(count).@Value)
                If Not System.IO.Directory.Exists(OperationLogFolderArray(count)) Then
                    MessageBox.Show("Operational log folder does ot exist. (" + OperationLogFolderArray(count) + ")")
                    End
                End If
            Next

            Dim Q_Window As IEnumerable(Of XElement) = From i In doc.<SystemRoot>.<ParameterArray>.<WindowArray>.<Window> Select i
            WindowInfoArray = New WindowInfo(Q_Window.Count - 1) {}

            For count As Integer = 0 To Q_Window.Count - 1
                Dim Tag As String = Q_Window(count).@Tag
                Dim ClassName As String = Q_Window(count).@ClassName
                Dim LoadTiming As String = Q_Window(count).@LoadTiming
                Dim OpenMode As String = Q_Window(count).@OpenMode
                Dim CaptureAttached As Integer = CInt(Q_Window(count).@CaptureAttached)

                WindowInfoArray(count) = New WindowInfo(Tag, ClassName, LoadTiming, OpenMode, CaptureAttached)

                If WindowInfoArray(count).LoadTiming = "Initial" Then
                    Try
                        WindowHashTable(WindowInfoArray(count).Tag) = WindowInfoArray(count).CreateInstance(New Object() {Me})
                        If WindowInfoArray(count).OpenMode = "Visible" Then
                            DirectCast(WindowHashTable(WindowInfoArray(count).Tag), System.Windows.Window).Show()
                        End If
                    Catch ex As Exception
                        MessageBox.Show("[Kernel.ReadXML] " + ex.Message)
                    End Try
                End If
            Next

            ' <DeviceArray>
            Dim Q_Device As IEnumerable(Of XElement) = From i In doc.<SystemRoot>.<DeviceArray>.<Device> Select i
            DeviceArray = New Device(Q_Device.Count - 1) {}

            If DeviceArray.GetLength(0) = 0 Then
                MessageBox.Show("Device undefined")
                End
            End If

            For count As Integer = 0 To Q_Device.Count - 1
                Try
                    DeviceArray(count) = CType(System.Activator.CreateInstance(Type.GetType(Me.GetType.Namespace.ToString() + "." + Q_Device(count).@Type), New Object() {Me, Q_Device(count)}), Device)
                    DeviceArray(count).DeviceId = count
                Catch ex As Exception
                    MessageBox.Show(ex.Message)
                    End
                End Try
            Next

            '<RealDataArray>
            Dim Q_RealData As IEnumerable(Of XElement) = From i In doc.<SystemRoot>.<RealDataArray>.<RealData> Select i
            RealDataArray = New RealData(Q_RealData.Count - 1) {}

            For count As Integer = 0 To Q_RealData.Count - 1
                Dim Name As String = Q_RealData(count).@Name
                Dim Tag As String = Q_RealData(count).@Tag
                Dim Unit As String = Q_RealData(count).@Unit
                Dim UnknownValue As Double = CDbl(Q_RealData(count).@UnknownValue)
                Dim GraphItemNum As Integer = CInt(Q_RealData(count).@GraphItemNum)

                '<Calculation>
                Dim Q_Calculation As IEnumerable(Of XElement) = From i In Q_RealData(count).<Calculation> Select i
                Dim CalcDelegate As CalcDelegate = Nothing
                Try
                    CalcDelegate = DirectCast([Delegate].CreateDelegate(GetType(CalcDelegate), CalcDelegates, CalcDelegates.GetType.GetMethod(Q_Calculation(0).@CalcDelegate)), CalcDelegate)
                Catch ex As ArgumentException
                    MessageBox.Show("[InternalError] Argument mismatch CalcDelegate=" + Q_Calculation(0).@CalcDelegate + " in <RealData><Calculation>")
                    End
                End Try
                Dim Q_Argument As IEnumerable(Of XElement) = From i In Q_Calculation.<Argument> Select i
                Dim ItemProfileArray() As ItemProfile = New ItemProfile(Q_Argument.Count - 1) {}

                For count2 As Integer = 0 To Q_Argument.Count - 1
                    Dim ArgumentType As String = Q_Argument(count2).@Type
                    Dim ArgumentTag As String = Q_Argument(count2).@Tag

                    ItemProfileArray(count2) = New ItemProfile(ArgumentType, ArgumentTag)
                    If SetProfile(ItemProfileArray(count2)) = -1 Then
                        MessageBox.Show("[kernel.SetProfile] ItemProfile.Tag=" + ItemProfileArray(count2).Tag + " NotFound in " + ItemProfileArray(count2).Type + " in RealData(" + count.ToString + ").")
                        End
                    End If
                Next

                Dim Calculation As Calculation = New Calculation(ItemProfileArray, CalcDelegate)

                '<AlarmItemArray>
                '<UpperLimitArray>
                Dim Q_UpperLimitItem As IEnumerable(Of XElement) = From i In Q_RealData(count).<AlarmItem>.<UpperLimitArray>.<LimitItem> Select i
                Dim UpperLimitItemArray() As LimitItem = New LimitItem(Q_UpperLimitItem.Count - 1) {}
                For count2 As Integer = 0 To Q_UpperLimitItem.Count - 1
                    Dim LimitItemLevel As Integer = CInt(Q_UpperLimitItem(count2).@Level)
                    Dim LimitItemName As String = Q_UpperLimitItem(count2).@Name
                    Dim LimitItemTag As String = Q_UpperLimitItem(count2).@Tag
                    Dim LimitItemLimitValue As Integer = CInt(Q_UpperLimitItem(count2).@LimitValue)
                    Dim LimitItemRecoveryValue As Integer = CInt(Q_UpperLimitItem(count2).@LimitValue)
                    Dim AlarmFlag As Integer = CInt(Q_UpperLimitItem(count2).@AlarmFlag)
                    Dim MailFlag As Integer = CInt(Q_UpperLimitItem(count2).@MailFlag)
                    Dim LimitItemAlarmDelegate As AlarmDelegate = Nothing

                    Try
                        LimitItemAlarmDelegate = DirectCast([Delegate].CreateDelegate(GetType(AlarmDelegate), ShowDelegates, GetType(ShowDelegates).GetMethod("Handler_Alarm_" + Tag + "_" + LimitItemTag)), AlarmDelegate)
                    Catch ex As ArgumentNullException
                        'MessageBox.Show("[InternalError] Handler_Alarm_" + Tag + "_" + LimitItemTag + " for <RealData><AlarmItem><UpperLimitArray><LimitItem> not defined!")
                        'End
                    End Try

                    UpperLimitItemArray(count2) = New LimitItem(LimitItemLevel, LimitItemName, LimitItemTag, LimitItemLimitValue, LimitItemRecoveryValue, AlarmFlag, MailFlag, LimitItemAlarmDelegate)
                Next

                '<LowerLimitArray>
                Dim Q_LowerLimitItem As IEnumerable(Of XElement) = From i In Q_RealData(count).<AlarmItem>.<LowerLimitArray>.<LimitItem> Select i
                Dim LowerLimitItemArray() As LimitItem = New LimitItem(Q_LowerLimitItem.Count - 1) {}
                For count2 As Integer = 0 To Q_LowerLimitItem.Count - 1
                    Dim LimitItemLevel As Integer = CInt(Q_LowerLimitItem(count2).@Level)
                    Dim LimitItemName As String = Q_LowerLimitItem(count2).@Name
                    Dim LimitItemTag As String = Q_LowerLimitItem(count2).@Tag
                    Dim LimitItemLimitValue As Integer = CInt(Q_LowerLimitItem(count2).@LimitValue)
                    Dim LimitItemRecoveryValue As Integer = CInt(Q_LowerLimitItem(count2).@LimitValue)
                    Dim AlarmFlag As Integer = CInt(Q_LowerLimitItem(count2).@AlarmFlag)
                    Dim MailFlag As Integer = CInt(Q_LowerLimitItem(count2).@MailFlag)
                    Dim LimitItemAlarmDelegate As AlarmDelegate = Nothing

                    Try
                        LimitItemAlarmDelegate = DirectCast([Delegate].CreateDelegate(GetType(AlarmDelegate), ShowDelegates, GetType(ShowDelegates).GetMethod("Handler_Alarm_" + Tag + "_" + LimitItemTag)), AlarmDelegate)
                    Catch ex As ArgumentNullException
                        'MessageBox.Show("[InternalError] Handler_Alarm_" + Tag + "_" + LimitItemTag + " for <RealData><AlarmItem><LowerLimitArray><LimitItem> not defined!")
                        'End
                    End Try

                    LowerLimitItemArray(count2) = New LimitItem(LimitItemLevel, LimitItemName, LimitItemTag, LimitItemLimitValue, LimitItemRecoveryValue, AlarmFlag, MailFlag, LimitItemAlarmDelegate)
                Next

                '<DisplayItemArray>
                Dim Q_DisplayItem As IEnumerable(Of XElement) = From i In Q_RealData(count).<DisplayItemArray>.<DisplayItem> Select i
                Dim DisplayItemArray() As DisplayItem = New DisplayItem(Q_DisplayItem.Count - 1) {}

                For count2 As Integer = 0 To Q_DisplayItem.Count - 1
                    Dim DisplayItemWindowName As System.Windows.Window = DirectCast(WindowHashTable(Q_DisplayItem(count2).@WindowName), System.Windows.Window)
                    If DisplayItemWindowName Is Nothing Then
                        MessageBox.Show("[Kernel.ReadXML] Undefined WindownName:" + Q_DisplayItem(count2).@WindowName + " in RealData:" + Tag)
                        End
                    End If
                    Dim DisplayItemControlName As UIElement = DirectCast(DisplayItemWindowName.FindName(Q_DisplayItem(count2).@ControlName), UIElement)

                    If DisplayItemControlName Is Nothing Then
                        MessageBox.Show("[Kernel.ReadXML] " + Q_DisplayItem(count2).@ControlName + " is not defined in " + Q_DisplayItem(count2).@WindowName + "!")
                        End
                    End If

                    Dim ShowDelegate As ShowDelegate = Nothing
                    Try
                        ShowDelegate = DirectCast([Delegate].CreateDelegate(GetType(ShowDelegate), ShowDelegates, ShowDelegates.GetType.GetMethod(Q_DisplayItem(count2).@ShowDelegate)), ShowDelegate)
                    Catch ex As ArgumentException
                        MessageBox.Show("[InternalError] Argument mismatch ShowDelegate=" + Q_DisplayItem(count2).@ShowDelegate + " in <DisplayItemArray>.<DisplayItem>")
                        End
                    End Try

                    Dim DisplayItemFormat As String = Q_DisplayItem(count2).@Format

                    DisplayItemArray(count2) = New DisplayItem(DisplayItemControlName, ShowDelegate, DisplayItemFormat)
                Next

                '' In case using DataSet
                '<DataSetItemArray>
                'Dim Q_DataSetItem As IEnumerable(Of XElement) = From i In Q_RealData(count).<DataSetItemArray>.<DataSetItem> Select i
                'Dim DataSetItemArray() As DataSetItem = New DataSetItem(Q_DataSetItem.Count - 1) {}

                'For count2 As Integer = 0 To Q_DataSetItem.Count - 1
                '    Try
                '        Dim DataSetItem As Object = DirectCast(WindowHashTable("MainWindow"), MainWindow).FindResource(Q_DataSetItem(count2).@DataSetName)
                '        Dim DataSetItemDataSetName As System.Data.DataSet = CType(DirectCast(WindowHashTable("MainWindow"), MainWindow).FindResource(Q_DataSetItem(count2).@DataSetName), System.Data.DataSet)
                '        Dim DataSetItemTableName As System.Data.DataTable = CType(DataSetItemDataSetName.Tables(Q_DataSetItem(count2).@TableName), System.Data.DataTable)

                '        If DataSetItemTableName Is Nothing Then
                '            MessageBox.Show("[InternalError] TableName=" + Q_DataSetItem(count2).@TableName + " in <RealData><DataSetItemArray><DataSetItem> not found!")
                '            End
                '        End If

                '        Dim DataSetItemCol As Int32 = DataSetItemTableName.Columns.IndexOf(Q_DataSetItem(count2).@Col)
                '        Dim DataSetItemRow As Int32 = Convert.ToInt32(Q_DataSetItem(count2).@Row)

                '        DataSetItemArray(count2) = New DataSetItem(DataSetItemDataSetName, DataSetItemTableName, DataSetItemCol, DataSetItemRow)
                '    Catch ex As ResourceReferenceKeyNotFoundException
                '        MessageBox.Show("[InternalError] DataSetName=" + Q_DataSetItem(count2).@DataSetName + " in <RealData><DataSetItemArray><DataSetItem> not found!")
                '        End
                '    End Try
                'Next
                ''

                RealDataArray(count) = New RealData(GraphItemNum, Name, Tag, Calculation, UpperLimitItemArray, LowerLimitItemArray, DisplayItemArray, Unit, UnknownValue)
                '' In case using DataSet
                ' RealDataArray(count) = New RealData(GraphItemNum, Name, Tag, Calculation, UpperLimitItemArray, LowerLimitItemArray, DisplayItemArray, DataSetItemArray, Unit, UnknownValue)
                ''

                Try
                    RealDataArrayHt.Add(Tag, count)
                Catch ArgumentException As Exception
                    MessageBox.Show("[Kernel.ReadXML] Tag= " + Tag + " is duplicated in <RealData>!")
                    End
                End Try
            Next

            '<LogicalItemArray>
            Dim Q_LogicalItem As IEnumerable(Of XElement) = From i In doc.<SystemRoot>.<LogicalItemArray>.<LogicalItem> Select i
            LogicalItemArray = New LogicalItem(Q_LogicalItem.Count - 1) {}

            For count As Integer = 0 To Q_LogicalItem.Count - 1
                Dim LogicalItemName As String = Q_LogicalItem(count).@Name
                Dim LogicalItemTag As String = Q_LogicalItem(count).@Tag
                Dim LogicalItemType As String = Q_LogicalItem(count).@Type
                Dim LogicalItemWindowName As System.Windows.Window = Nothing
                Dim LogicalItemControlName As Control = Nothing

                Try
                    If WindowHashTable(Q_LogicalItem(count).@WindowName) IsNot Nothing Then
                        LogicalItemWindowName = DirectCast(WindowHashTable(Q_LogicalItem(count).@WindowName), System.Windows.Window)

                        If LogicalItemWindowName.FindName(Q_LogicalItem(count).@ControlName) IsNot Nothing Then
                            LogicalItemControlName = DirectCast(LogicalItemWindowName.FindName(Q_LogicalItem(count).@ControlName), Control)
                        Else
                            MessageBox.Show("[Kernel.ReadXML] " + Q_LogicalItem(count).@ControlName + " is not defined in " + Q_LogicalItem(count).@WindowName + "!")
                            End
                        End If
                    Else
                        MessageBox.Show("[Kernel.ReadXML] " + Q_LogicalItem(count).@WindowName + " is not defined!")
                        End
                    End If
                Catch ex As ArgumentNullException
                    LogicalItemWindowName = Nothing
                    LogicalItemControlName = Nothing
                End Try

                '<BitItemArray>
                Dim Q_BitItem As IEnumerable(Of XElement) = From i In Q_LogicalItem(count).<BitItemArray>.<BitItem> Select i
                Dim BitItemArray() As BitItem = New BitItem(Q_BitItem.Count - 1) {}

                For count2 As Integer = 0 To Q_BitItem.Count - 1
                    Dim id As Integer = CInt(Q_BitItem(count2).@id)
                    Dim Type As String = Q_BitItem(count2).@Type
                    Dim Tag As String = Q_BitItem(count2).@Tag
                    Dim ret As Integer = -1

                    BitItemArray(count2) = New BitItem(id, Type, Tag)

                    For count3 As Integer = 0 To DeviceArray.GetLength(0) - 1
                        ret = SetProfile(BitItemArray(count2).ItemProfile)
                        If ret = 0 Then
                            Exit For
                        End If
                    Next

                    If ret = -1 Then
                        MessageBox.Show("[Kernel.SetProfile] ItemProfile.Tag=" + Tag + " NotFound in " + Type + " for BitItemArray(" + count2.ToString + ").")
                        End
                    End If
                Next

                '<StateArray>
                Dim Q_State As IEnumerable(Of XElement) = From i In Q_LogicalItem(count).<StateArray>.<State> Select i
                Dim StateArray() As State = New State(Q_State.Count - 1) {}
                Dim StateArrayChangedDelegate As ChangedDelegate = Nothing

                For count2 As Integer = 0 To Q_State.Count - 1
                    Dim Name As String = Q_State(count2).@Name
                    Dim Tag As String = Q_State(count2).@Tag
                    Dim AlarmFlag As Integer = CInt(Q_State(count2).@AlarmFlag)
                    Dim MailFlag As Integer = CInt(Q_State(count2).@MailFlag)
                    Dim ChangedDelegate As ChangedDelegate = Nothing
                    Dim Style As String = Q_State(count2).@Style
                    Dim Initial As Integer = If(Q_State(count2).@Initial Is Nothing, -1, CInt(Q_State(count2).@Initial))

                    If Q_State(count2).@ChangedDelegate IsNot Nothing Then  ' ChangedDelegate is defined by State. All actions are written in handler
                        Try
                            ChangedDelegate = DirectCast([Delegate].CreateDelegate(GetType(ChangedDelegate), ChangedDelegates, GetType(ChangedDelegates).GetMethod(Q_State(count2).@ChangedDelegate)), ChangedDelegate)
                        Catch ex As ArgumentNullException
                            MessageBox.Show("[ArgumentNullException] " + Q_State(count2).@ChangedDelegate + " in <LogicalItem><BitItemArray><BitItem> not defined!")
                            End
                        End Try
                    ElseIf (From i In Q_LogicalItem(count).<StateArray> Select i)(0).@ChangedDelegate IsNot Nothing Then ' ChangedDelegate is Defined by StateArray. Handler name is fixed. ControlName and Style are written in System.xml 
                        Try
                            ChangedDelegate = DirectCast([Delegate].CreateDelegate(GetType(ChangedDelegate), ChangedDelegates, GetType(ChangedDelegates).GetMethod((From i In Q_LogicalItem(count).<StateArray> Select i)(0).@ChangedDelegate)), ChangedDelegate)
                        Catch ex As ArgumentNullException
                            MessageBox.Show("[ArgumentNullException] " + (From i In Q_LogicalItem(count).<StateArray> Select i)(0).@ChangedDelegate + " in <LogicalItem><StateArray> not defined!")
                            End
                        End Try
                    ElseIf LogicalItemType IsNot Nothing Then               ' ChangedDelegate is Defined by LogicalItemType. <DisplayItem Style""> will not be necessary. (not implemented yet)
                        Try
                            ChangedDelegate = DirectCast([Delegate].CreateDelegate(GetType(ChangedDelegate), ChangedDelegates, GetType(ChangedDelegates).GetMethod("Handler_" + LogicalItemType)), ChangedDelegate)
                        Catch ex As ArgumentNullException
                            MessageBox.Show("[ArgumentNullException] Handler_" + LogicalItemType + " in <LogicalItem><BitItemArray><BitItem> not defined!")
                            End
                        End Try
                        'Else
                        '    MessageBox.Show("[Kernel.ReadXML] Both of Type and ChangedDelegate are not defined in <LogicalItem><BitItemArray><BitItem>!")
                        '    End
                    End If

                    Dim Q_BitCondition As IEnumerable(Of XElement) = From i In Q_State(count2).<BitConditionArray>.<BitCondition> Select i
                    Dim BitConditionArray() As Integer = New Integer(Q_BitItem.Count - 1) {}

                    For count3 As Integer = 0 To Q_BitItem.Count - 1
                        BitConditionArray(count3) = -1
                    Next

                    For count3 As Integer = 0 To Q_BitCondition.Count - 1
                        Dim id As Integer = CInt(Q_BitCondition(count3).@id)
                        Dim Value As Integer = CInt(Q_BitCondition(count3).@Value)

                        Try
                            BitConditionArray(id) = Value
                        Catch ex As IndexOutOfRangeException
                            MessageBox.Show("[IndexOutOfRangeException] <LogicalItem><StateArray><State=" + Name + "><BitCondition> id=" + id.ToString() + " value=" + Value.ToString())
                            End
                        End Try
                    Next

                    Dim Q_LogicalDisplayItem As IEnumerable(Of XElement) = From i In Q_State(count2).<DisplayItemArray>.<DisplayItem> Select i
                    Dim LogicalDisplayItemArray() As LogicalDisplayItem = New LogicalDisplayItem(Q_LogicalDisplayItem.Count - 1) {}

                    For count3 As Integer = 0 To Q_LogicalDisplayItem.Count - 1
                        If WindowHashTable(Q_LogicalDisplayItem(count3).@WindowName) IsNot Nothing Then
                            Dim LogicalDisplayItemWindowName As System.Windows.Window = DirectCast(WindowHashTable(Q_LogicalDisplayItem(count3).@WindowName), System.Windows.Window)
                            Dim LogicalDisplayItemControlName As Control = Nothing
                            Dim LogicalDisplayItemStyle As String = ""
                            Dim LogicalDisplayItemText As String = ""
                            Dim LogicalDisplayItemVisibility As String = ""

                            If LogicalDisplayItemWindowName.FindName(Q_LogicalDisplayItem(count3).@ControlName) IsNot Nothing Then
                                LogicalDisplayItemControlName = DirectCast(LogicalDisplayItemWindowName.FindName(Q_LogicalDisplayItem(count3).@ControlName), Control)
                                LogicalDisplayItemStyle = Q_LogicalDisplayItem(count3).@Style
                                LogicalDisplayItemText = Q_LogicalDisplayItem(count3).@Text
                                LogicalDisplayItemVisibility = Q_LogicalDisplayItem(count3).@Visibility
                            Else
                                MessageBox.Show("[Kernel.ReadXML] " + Q_LogicalDisplayItem(count3).@ControlName + " is not defined in " + Q_LogicalDisplayItem(count3).@WindowName + "!")
                                'End
                            End If

                            LogicalDisplayItemArray(count3) = New LogicalDisplayItem(LogicalDisplayItemControlName, LogicalDisplayItemStyle, LogicalDisplayItemText, LogicalDisplayItemVisibility)
                        Else
                            MessageBox.Show("[Kernel.ReadXML] " + Q_LogicalDisplayItem(count3).@WindowName + " is not defined!")
                            End
                        End If
                    Next

                    StateArray(count2) = New State(Name, Tag, AlarmFlag, MailFlag, ChangedDelegate, LogicalDisplayItemArray, Initial, BitConditionArray)
                Next
                LogicalItemArray(count) = New LogicalItem(LogicalItemName, LogicalItemType, LogicalItemTag, BitItemArray, StateArray)
                Try
                    LogicalItemArrayHt.Add(LogicalItemTag, count)
                Catch ArgumentNullException As ArgumentNullException
                    MessageBox.Show("[Kernel.ReadXML] LogicalItem.Tag is not defined at LogicalItemArray[" + CStr(count) + "].")
                    End
                Catch ArgumentException As ArgumentException
                    MessageBox.Show("[Kernel.ReadXML] LogicalItemTag= " + LogicalItemTag + " is duplicated in <LogicalItemArray>.")
                    End
                End Try
            Next

            ' !!! Don't move this code. Following code must be written after RealData & LogicalItem
            '<LogSetting>
            Dim LogSettingTypeStr As String = doc.<SystemRoot>.<ParameterArray>.<LogSetting>.@Type
            If LogSettingTypeStr Is Nothing Then
                LogSettingType = 1
            Else
                If LogSettingTypeStr.Equals("RawData") Then             ' RawData
                    LogSettingType = 0
                ElseIf LogSettingTypeStr.Equals("PhysicalData") Then    ' PhysicalData
                    LogSettingType = 1
                ElseIf LogSettingTypeStr.Equals("DataGroup") Then       ' DataGroup
                    LogSettingType = 2

                    '<DataGroupArray>
                    Dim Q_DataGroup As IEnumerable(Of XElement) = From i In doc.<SystemRoot>.<LogSetting>.<DataGroupArray>.<DataGroup> Select i
                    DataGroupArray = New DataGroup(Q_DataGroup.Count - 1) {}

                    For count As Integer = 0 To Q_DataGroup.Count - 1
                        Dim DataGroupName As String = Q_DataGroup(count).@Name

                        Dim Q_DataItem As IEnumerable(Of XElement) = From i In Q_DataGroup(count).<DataItem> Select i
                        Dim ItemProfileArray() As ItemProfile = New ItemProfile(Q_DataItem.Count - 1) {}

                        For count2 As Integer = 0 To Q_DataItem.Count - 1
                            Dim ItemProfileType As String = Q_DataItem(count2).@Type
                            Dim ItemProfileTag As String = Q_DataItem(count2).@Tag

                            ItemProfileArray(count2) = New ItemProfile(ItemProfileType, ItemProfileTag)
                            SetProfile(ItemProfileArray(count2))
                        Next

                        DataGroupArray(count) = New DataGroup(DataGroupName, ItemProfileArray)
                    Next
                Else
                    MessageBox.Show("[Illeagal Value] <LogSetting Type=""" + LogSettingTypeStr.ToString + """ >")
                    End
                End If
            End If

            doc = Nothing

            ' In case using AlarmAnalog/AlarmDigital window
            'DirectCast(WindowHashTable("AlarmAnalog"), AlarmAnalog).InitDataSet()
            'DirectCast(WindowHashTable("AlarmDigital"), AlarmDigital).InitDataSet()
        Else
            MessageBox.Show("System.xml not found")
            End
        End If
    End Sub

    ''' <summary>
    ''' Fixed-cycle operation. the minimum cyclic period is fixed by "TicksMilliSecond".
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub TimerThreadTask()
        Try
            Dim sw As Stopwatch = New Stopwatch()
            Dim TicksCurrentCount As Integer = 0
            Dim DataAcquisitionCurrentCount As Integer = 0
            Dim DataAcquisitionEventCount As Integer = Convert.ToInt32(AcquisitionCycleMilliSecond / TicksMilliSecond)

            Dim ArchiveCurrentCount As Integer = CInt(-30000 / TicksMilliSecond)
            Dim ArchiveEventCount As Integer = Convert.ToInt32(ArchiveCycleMilliSecond / TicksMilliSecond)

            'Ticks unit of loop (msec)
            Do
                sw.Reset()
                sw.Start()

                '' In case showing current time in MainWindow
                'TicksCurrentCount += 1
                'If TicksMilliSecond * TicksCurrentCount >= 500 Then
                '    ChangeText(DirectCast(WindowHashTable("MainWindow"), MainWindow).CurrentDateTime, System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss"))
                '    TicksCurrentCount = 0
                'Else
                'End If
                ''

                RaiseEvent evtTicks()

                '                If AcquisitionFlag Then
                '                    DataAcquisitionCurrentCount += 1
                '                    If DataAcquisitionCurrentCount >= DataAcquisitionEventCount Then
                '                        Dim trd As Thread = New Thread(AddressOf em.DataAcquisition)
                '                        trd.IsBackground = True
                '                        trd.Start()
                '                        DataAcquisitionCurrentCount = 0
                '                    End If
                '
                '                    ArchiveCurrentCount += 1
                '                    If ArchiveCurrentCount >= ArchiveEventCount Then
                '                        Dim trd As Thread = New Thread(AddressOf em.Archive)
                '                        trd.IsBackground = True
                '                        trd.Start()
                '                        ArchiveCurrentCount = 0
                '                    End If
                '                End If

                sw.Stop()

                If TicksMilliSecond - sw.ElapsedMilliseconds >= 0 Then
                    Thread.Sleep(Convert.ToInt32(TicksMilliSecond - sw.ElapsedMilliseconds))
                Else
                    Thread.Sleep(Convert.ToInt32(0))
                End If
            Loop
        Catch ex As Exception
            MessageBox.Show("[Kernel.TimerThreadTask] Error: " + ex.Message)
        End Try
    End Sub

    ''' <summary>
    ''' GetDevice instance from Device name
    ''' </summary>
    ''' <param name="DeviceName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function SearchDevice(ByVal DeviceName As String) As Device
        For count As Integer = 0 To DeviceArray.GetLength(0) - 1
            If DeviceArray(count).DeviceName = DeviceName Then
                Return DeviceArray(count)
            End If
        Next
        Return Nothing
    End Function

    ''' <summary>
    ''' Set ItemProfile field 
    ''' </summary>
    ''' <param name="ItemProfile"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Function SetProfile(ByRef ItemProfile As ItemProfile) As Integer
        Dim ret As Integer = -1

        If ItemProfile.Type = "WordGet" Then
            Dim ht As Integer = -1
            Dim ht2 As Integer = -1
            Dim count3 As Integer

            For count3 = 0 To DeviceArray.Count - 1
                ret = DeviceArray(count3).SearchWordGetArrayHt(ItemProfile.Tag, ht, ht2)
                If ret = 0 Then
                    ItemProfile.TypeIndex = 0
                    ItemProfile.DeviceIndex = count3
                    ItemProfile.TagIndex = ht
                    Exit For
                ElseIf ret = 1 Then
                    ItemProfile.TypeIndex = 0
                    ItemProfile.DeviceIndex = count3
                    ItemProfile.TagIndex = ht
                    ItemProfile.TagIndex2 = ht2
                    Exit For
                End If
            Next
        ElseIf ItemProfile.Type = "BitGet" Then
            Dim chno As Integer = -1
            Dim bitno As Integer = -1
            Dim count3 As Integer

            For count3 = 0 To DeviceArray.Count - 1
                ret = DeviceArray(count3).SearchBitGetArrayHt(ItemProfile.Tag, chno, bitno)
                If ret = 0 Then
                    ItemProfile.TypeIndex = 1
                    ItemProfile.DeviceIndex = count3
                    ItemProfile.TagIndex = chno
                    ItemProfile.TagIndex2 = bitno
                    Exit For
                End If
            Next
        ElseIf ItemProfile.Type = "RealData" Then
            If RealDataArrayHt(ItemProfile.Tag) IsNot Nothing Then
                ItemProfile.TypeIndex = 2
                ItemProfile.DeviceIndex = -1
                ItemProfile.TagIndex = CInt(RealDataArrayHt(ItemProfile.Tag))
                ItemProfile.TagIndex2 = -1
                ret = 0
            End If
        ElseIf ItemProfile.Type = "LogicalItem" Then
            If LogicalItemArrayHt(ItemProfile.Tag) IsNot Nothing Then
                ItemProfile.TypeIndex = 3
                ItemProfile.DeviceIndex = -1
                ItemProfile.TagIndex = CInt(LogicalItemArrayHt(ItemProfile.Tag))
                ItemProfile.TagIndex2 = -1
                ret = 0
            End If
        ElseIf ItemProfile.Type = "Command" Then
            Dim ht As Integer = -1

            For count3 As Integer = 0 To DeviceArray.Count - 1
                ret = CType(DeviceArray(count3).Protocol, CustomProtocol).SearchAsciiDataGetArrayHt(ItemProfile.Tag, ht)
                ItemProfile.TypeIndex = 4
                ItemProfile.DeviceIndex = count3
                ItemProfile.TagIndex = ht
                Exit For
            Next
        End If

        Return ret
    End Function
End Class
