﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System
Imports System.IO
Imports System.Net
Imports System.Windows
Imports System.Windows.Controls
Imports System.Windows.Data
Imports System.Windows.Media.Animation
Imports System.Windows.Navigation
Imports System.Drawing
Imports System.Windows.Interop
Imports System.Runtime.InteropServices


Public Class SelectGraphItem
    Const MAX_GRAPH_COUNT As Integer = 6

    Dim InitializedFlag As Integer = 0

    Dim Kernel As Kernel

    Dim ItemNameArray() As String
    Dim TagNameArray() As String

    Dim OriginalWidth As Double
    Dim OriginalHeight As Double

    Private Const MF_BYCOMMAND As Integer = &H0&
    Private Const SC_CLOSE As Integer = &HF060&

    <DllImport("User32")> _
    Public Shared Function RemoveMenu(ByVal hMenu As IntPtr, ByVal uPosition As UInteger, ByVal uFlags As UInteger) As Boolean
    End Function

    <DllImport("User32")> _
    Public Shared Function GetSystemMenu(ByVal hWnd As IntPtr, ByVal bRevert As Boolean) As IntPtr
    End Function

    <DllImport("User32")> _
    Public Shared Function DrawMenuBar(ByVal hWnd As IntPtr) As Long
    End Function

    Sub New(ByVal Kernel As Kernel)
        MyBase.New()

        Me.Kernel = Kernel

        ' この呼び出しはデザイナーで必要です。
        InitializeComponent()

        OriginalWidth = Me.Width
        OriginalHeight = Me.Height

        Me.MinWidth = OriginalWidth / 2
        Me.MinHeight = OriginalHeight / 2
    End Sub

    Private Sub Init()
        Dim i As Integer
        Dim number As Integer

        For i = 0 To Kernel.RealDataArray.GetLength(0) - 1
            If Kernel.RealDataArray(i).GraphItemNum >= 0 Then
                List1.Items.Add(New CheckBox)
            End If
        Next

        ItemNameArray = New String(List1.Items.Count - 1) {}
        TagNameArray = New String(List1.Items.Count - 1) {}

        For i = 0 To List1.Items.Count - 1
            number = Kernel.RealDataArray(i).GraphItemNum - 1
            If number >= 0 Then
                CType(List1.Items.Item(number), CheckBox).Content = Kernel.RealDataArray(i).Name + " [" + Kernel.RealDataArray(i).Tag + "]"
                AddHandler CType(List1.Items.Item(number), CheckBox).Checked, AddressOf CheckBox_Checked

                ItemNameArray(number) = Kernel.RealDataArray(i).Name
                TagNameArray(number) = Kernel.RealDataArray(i).Tag
            End If
        Next
    End Sub

    Private Sub btnHide_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs)
        For i As Integer = 0 To List1.Items.Count - 1
            CType(List1.Items.Item(i), CheckBox).IsChecked = False
        Next

        Me.Hide()
    End Sub

    Private Sub ShowGraph_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs)
        Dim TrendGraph() As TrendGraph = New TrendGraph(MAX_GRAPH_COUNT) {}
        Dim CheckedItemNameArray() As String = New String(9) {}
        Dim CheckedTagNameArray() As String = New String(9) {}
        Dim ColorArray() As Color = New Color(9) {Color.Red, Color.LightGreen, Color.Magenta, Color.Cyan, Color.Orange, Color.Pink, Color.Blue, Color.LightGray, Color.Brown, Color.White}

        Dim count As Integer = 0

        For i As Integer = 0 To List1.Items.Count - 1
            If CType(List1.Items.Item(i), CheckBox).IsChecked Then
                ''CheckedItemType()
                CheckedItemNameArray(count) = ItemNameArray(i)
                CheckedTagNameArray(count) = TagNameArray(i)
                count += 1
            End If
        Next

        Dim CheckedItemNameArraySet(count - 1) As String
        Dim CheckedTagNameArraySet(count - 1) As String
        Dim ColorArraySet(count - 1) As Color

        Array.Copy(CheckedItemNameArray, CheckedItemNameArraySet, count)
        Array.Copy(CheckedTagNameArray, CheckedTagNameArraySet, count)
        Array.Copy(ColorArray, ColorArraySet, count)

        Try
            Dim result As Integer = 0
            Dim position As Integer

            For i As Integer = 0 To MAX_GRAPH_COUNT - 1
                If TrendGraph(i) Is Nothing Then
                    position = i
                    result = 1
                    Exit For
                End If
            Next

            If result = 1 Then
                TrendGraph(position) = New TrendGraph(position, "グラフ", Kernel, CheckedItemNameArraySet, CheckedTagNameArraySet, ColorArraySet, _
                                                      CBool(LogScale.IsChecked), _
                                                      Convert.ToDouble(Min.Text), _
                                                      Convert.ToDouble(Max.Text), _
                                                      (Convert.ToInt32(Minute.Text)) * 60 * 1000, _
                                                      Convert.ToDouble(Resolution.Text), _
                                                      Convert.ToInt16(Cycle.Text))

                For i As Integer = 0 To List1.Items.Count - 1
                    CType(List1.Items.Item(i), CheckBox).IsChecked = False
                Next

                TrendGraph(position).Show()
            Else
                System.Windows.MessageBox.Show(MAX_GRAPH_COUNT.ToString + "個までしかグラフを開けられません")
            End If
        Catch FormatException As FormatException
            System.Windows.MessageBox.Show("入力値エラー(FormatException)")
        End Try
    End Sub

    Private Sub Window4_Loaded(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles Me.Loaded
        Dim windowHandle As IntPtr = (New WindowInteropHelper(Me)).Handle

        Call RemoveMenu(GetSystemMenu(windowHandle, False), SC_CLOSE, MF_BYCOMMAND)
        Call DrawMenuBar(windowHandle)
    End Sub

    Private Sub CheckBox_Checked(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs)
        Dim count As Integer = 0

        For i As Integer = 0 To List1.Items.Count - 1
            If CType(List1.Items.Item(i), CheckBox).IsChecked Then
                If count + 1 > 10 Then
                    CType(sender, CheckBox).IsChecked = False
                    System.Windows.MessageBox.Show("10個までしか選択できません")
                Else
                    count += 1
                End If
            End If
        Next
    End Sub

    Private Sub Window_SizeChanged(ByVal sender As Object, ByVal e As System.Windows.SizeChangedEventArgs)
        Dim AdjustScale As System.Windows.Media.ScaleTransform = New System.Windows.Media.ScaleTransform()

        AdjustScale.ScaleX = (Me.Width - 20) / (OriginalWidth - 20)
        AdjustScale.ScaleY = (Me.Height - 40) / (OriginalHeight - 40)

        Me.Height = AdjustScale.ScaleX * OriginalHeight

        CV.RenderTransform = AdjustScale
    End Sub

    Private Sub Window_Activated(sender As System.Object, e As System.EventArgs) Handles MyBase.Activated
        If InitializedFlag = 0 Then
            Init()
            InitializedFlag = 1
        End If
    End Sub
End Class
