﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System
Imports System.IO
Imports System.Text
Imports System.Windows
Imports System.Windows.Controls.ListBox
Imports System.Windows.Interop
Imports System.Runtime.InteropServices

Partial Public Class LOGMSG
    Dim kernel As Kernel

    Delegate Sub AddMsgCallback(ByVal [text] As String, ByVal [SaveFlag] As Boolean) ' call back for AddMsg function
    Public OperationLogFolderArray() As String
    Private DirectoryNotFoundFlag As Boolean()

    Dim OriginalWidth As Double
    Dim OriginalHeight As Double

    Private Const MF_BYCOMMAND As Integer = &H0&
    Private Const SC_CLOSE As Integer = &HF060&

    <DllImport("User32")> _
    Public Shared Function RemoveMenu(ByVal hMenu As IntPtr, ByVal uPosition As UInteger, ByVal uFlags As UInteger) As Boolean
    End Function

    <DllImport("User32")> _
    Public Shared Function GetSystemMenu(ByVal hWnd As IntPtr, ByVal bRevert As Boolean) As IntPtr
    End Function

    <DllImport("User32")> _
    Public Shared Function DrawMenuBar(ByVal hWnd As IntPtr) As Long
    End Function

    ' add message to listbox with thread safe
    Public Sub AddMsg(ByVal [text] As String, ByVal [SaveFlag] As Boolean)
        If lstMSG.Dispatcher.CheckAccess() Then
            AddListItem([text])
            If [SaveFlag] Then
                fncLogSave([text])
            End If
        Else
            lstMSG.Dispatcher.Invoke(New AddMsgCallback(AddressOf AddMsg), New Object() {[text], [SaveFlag]})
        End If
    End Sub

    Sub New(ByVal kernel As Kernel)
        Me.kernel = kernel
        Me.OperationLogFolderArray = kernel.OperationLogFolderArray

        ' この呼び出しは、Windows フォーム デザイナで必要です。
        InitializeComponent()
        Init(OperationLogFolderArray)
    End Sub

    Sub New(ByVal OperationLogFolderArray() As String)
        Me.OperationLogFolderArray = OperationLogFolderArray

        ' この呼び出しは、Windows フォーム デザイナで必要です。
        InitializeComponent()
        Init(OperationLogFolderArray)
    End Sub

    ' this function is called after InitializeComponent()
    Sub Init(ByVal LogFolderArray() As String)
        Dim i As Integer
        Dim strLine As String
        Dim fs As FileStream
        Dim FileName As String

        Me.InitializeComponent()
        OriginalWidth = Me.Width
        OriginalHeight = Me.Height

        Me.MinWidth = OriginalWidth / 2
        Me.MinHeight = OriginalHeight / 2

        DirectoryNotFoundFlag = New Boolean(LogFolderArray.GetLength(0) - 1) {}
        If LogFolderArray.GetLength(0) > 0 Then
            ' read old data from a day before
            For i = -1 To 0
                FileName = System.IO.Path.Combine(LogFolderArray(0), "MSG_" + (System.DateTime.Now.AddMilliseconds(86400000 * i)).ToString("yyyyMMdd") + ".csv")

                If System.IO.File.Exists(FileName) Then ' check if the file exists
                    fs = New FileStream(FileName, FileMode.Open, FileAccess.Read, FileShare.ReadWrite)
                    Dim sr As StreamReader = New StreamReader(fs, Encoding.GetEncoding("Shift_JIS"))

                    While True                          ' While sr.EndOfStream = False
                        Try
                            strLine = sr.ReadLine()     ' read data from file
                            If strLine = Nothing Then
                                Exit While
                            Else
                                AddListItem(strLine)
                            End If
                        Catch ex As FormatException
                            AddListItem(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + " Cyclic data read error.")
                            Continue While
                        End Try
                    End While
                    fs.Close()
                End If
            Next
        Else
            AddListItem(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + " <ParameterArray>.<LogSetting>.<OperationLogFolderArray>.<OperationLogFolder> is not set.")
        End If
    End Sub

    Private Sub btnExit_Click(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs)
        Me.Hide()
    End Sub

    Private Sub Window1_Closing(sender As Object, e As ComponentModel.CancelEventArgs)
        e.Cancel = True
        Me.Hide()
    End Sub

    ' 操作・状態変化履歴保存
    Private Function fncLogSave(ByVal data As String) As Integer
        Dim fs As FileStream = Nothing
        Dim sw As StreamWriter = Nothing
        Dim FileName As String = Nothing

        For count As Integer = 0 To OperationLogFolderArray.GetLength(0) - 1
            Try
                FileName = System.IO.Path.Combine(OperationLogFolderArray(count), "MSG_" + (System.DateTime.Now).ToString("yyyyMMdd") + ".csv")
                If Not File.Exists(FileName) Then
                    fs = New FileStream(FileName, FileMode.Create, FileAccess.Write, FileShare.ReadWrite)
                    sw = New StreamWriter(fs, Encoding.GetEncoding("Shift_JIS"))
                Else
                    fs = New FileStream(FileName, FileMode.Append, FileAccess.Write, FileShare.ReadWrite)
                    sw = New StreamWriter(fs, Encoding.GetEncoding("Shift_JIS"))
                End If

                sw.WriteLine(data)
                Try
                    If sw IsNot Nothing Then sw.Close()
                    If fs IsNot Nothing Then fs.Close()
                Catch
                End Try

                DirectoryNotFoundFlag(count) = False
            Catch ex As DirectoryNotFoundException
                If DirectoryNotFoundFlag(count) = False Then
                    DirectoryNotFoundFlag(count) = True
                    MessageBox.Show("Directory for operational log does not exist. (" + OperationLogFolderArray(count) + ")")
                    DirectoryNotFoundFlag(count) = False
                End If
                Return -1
            Catch ex As IOException
                AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + " Operational log write error. (" + FileName + ")", False)
                Return -1
            End Try
        Next

        Return 0
    End Function

    Private Sub AddListItem(ByVal message As String)
        lstMSG.Items.Add(message)

        If lstMSG.Items.Count > 500 Then
            lstMSG.Items.RemoveAt(0)
        End If

        If lstMSG.Items.Count > 0 Then
            If chkAutoScroll.IsChecked Then
                lstMSG.ScrollIntoView(lstMSG.Items(lstMSG.Items.Count - 1))
            End If
        End If
    End Sub

    Private Sub Window1_Activated(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Activated
        'kernel.ChangeStyle(kernel.GetWindow(Of MainWindow)("MainWindow").ShowLog, "ButtonDefault")

        If lstMSG.Items.Count > 0 Then
            If chkAutoScroll.IsChecked Then
                lstMSG.ScrollIntoView(lstMSG.Items(lstMSG.Items.Count - 1))
            End If
        End If
    End Sub

    Private Sub Window1_Loaded(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs)
        Dim windowHandle As IntPtr = (New WindowInteropHelper(Me)).Handle

        Call RemoveMenu(GetSystemMenu(windowHandle, False), SC_CLOSE, MF_BYCOMMAND)
        Call DrawMenuBar(windowHandle)
    End Sub

    Private Sub Window1_SizeChanged(ByVal sender As Object, ByVal e As System.Windows.SizeChangedEventArgs)
        Dim AdjustScale As System.Windows.Media.ScaleTransform = New System.Windows.Media.ScaleTransform()

        AdjustScale.ScaleX = (Me.Width - 20) / (OriginalWidth - 20)
        AdjustScale.ScaleY = (Me.Height - 40) / (OriginalHeight - 40)

        Me.Height = AdjustScale.ScaleX * OriginalHeight

        CV.RenderTransform = AdjustScale

    End Sub
End Class
