﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Windows.Interop
Imports System.Runtime.InteropServices

Public Class AlarmWindow
    Dim OriginalWidth As Double
    Dim OriginalHeight As Double

    Private Const MF_BYCOMMAND As Integer = &H0&
    Private Const SC_CLOSE As Integer = &HF060&

    <DllImport("User32")> _
    Public Shared Function RemoveMenu(ByVal hMenu As IntPtr, ByVal uPosition As UInteger, ByVal uFlags As UInteger) As Boolean
    End Function

    <DllImport("User32")> _
    Public Shared Function GetSystemMenu(ByVal hWnd As IntPtr, ByVal bRevert As Boolean) As IntPtr
    End Function

    <DllImport("User32")> _
    Public Shared Function DrawMenuBar(ByVal hWnd As IntPtr) As Long
    End Function

    Public Sub New(ByVal kernel As Kernel)
        MyBase.New()

        InitializeComponent()
        Init()
    End Sub

    Public Sub New()
        MyBase.New()

        InitializeComponent()
        Init()
    End Sub

    Private Sub Init()
        OriginalWidth = Me.Width
        OriginalHeight = Me.Height

        Me.MinWidth = OriginalWidth / 2
        Me.MinHeight = OriginalHeight / 2
    End Sub

    Private Sub Window_Loaded(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs)
        Dim windowHandle As IntPtr = (New WindowInteropHelper(Me)).Handle

        Call RemoveMenu(GetSystemMenu(windowHandle, False), SC_CLOSE, MF_BYCOMMAND)
        Call DrawMenuBar(windowHandle)

        Dim LabelArray()() As Label = New Label()() { _
            New Label() {Label0_0, Label0_1, Label0_2, Label0_3, Label0_4, Label0_5, Label0_6, Label0_7}, _
            New Label() {Label1_0, Label1_1, Label1_2, Label1_3, Label1_4, Label1_5, Label1_6, Label1_7}, _
            New Label() {Label2_0, Label2_1, Label2_2, Label2_3, Label2_4, Label2_5, Label2_6, Label2_7}, _
            New Label() {Label3_0, Label3_1, Label3_2, Label3_3, Label3_4, Label3_5, Label3_6, Label3_7}, _
            New Label() {Label4_0, Label4_1, Label4_2, Label4_3, Label4_4, Label4_5, Label4_6, Label4_7}, _
            New Label() {Label5_0, Label5_1, Label5_2, Label5_3, Label5_4, Label5_5, Label5_6, Label5_7}, _
            New Label() {Label6_0, Label6_1, Label6_2, Label6_3, Label6_4, Label6_5, Label6_6, Label6_7}, _
            New Label() {Label7_0, Label7_1, Label7_2, Label7_3, Label7_4, Label7_5, Label7_6, Label7_7} _
        }

        LabelArray(0)(0).Content = "Label0_0"
        LabelArray(0)(1).Content = "Label0_1"
        LabelArray(0)(2).Content = "Label0_2"
        LabelArray(0)(3).Content = "Label0_3"
        LabelArray(0)(4).Content = "Label0_4"
        LabelArray(0)(5).Content = "Label0_5"
        LabelArray(0)(6).Content = "Label0_6"
        LabelArray(0)(7).Content = "Label0_7"
        LabelArray(1)(0).Content = "Label1_0"
        LabelArray(1)(1).Content = "Label1_1"
        LabelArray(1)(2).Content = "Label1_2"
        LabelArray(1)(3).Content = "Label1_3"
        LabelArray(1)(4).Content = "Label1_4"
        LabelArray(1)(5).Content = "Label1_5"
        LabelArray(1)(6).Content = "Label1_6"
        LabelArray(1)(7).Content = "Label1_7"
        LabelArray(2)(0).Content = "Label2_0"
        LabelArray(2)(1).Content = "Label2_1"
        LabelArray(2)(2).Content = "Label2_2"
        LabelArray(2)(3).Content = "Label2_3"
        LabelArray(2)(4).Content = "Label2_4"
        LabelArray(2)(5).Content = "Label2_5"
        LabelArray(2)(6).Content = "Label2_6"
        LabelArray(2)(7).Content = "Label2_7"
        LabelArray(3)(0).Content = "Label3_0"
        LabelArray(3)(1).Content = "Label3_1"
        LabelArray(3)(2).Content = "Label3_2"
        LabelArray(3)(3).Content = "Label3_3"
        LabelArray(3)(4).Content = "Label3_4"
        LabelArray(3)(5).Content = "Label3_5"
        LabelArray(3)(6).Content = "Label3_6"
        LabelArray(3)(7).Content = "Label3_7"
        LabelArray(4)(0).Content = "Label4_0"
        LabelArray(4)(1).Content = "Label4_1"
        LabelArray(4)(2).Content = "Label4_2"
        LabelArray(4)(3).Content = "Label4_3"
        LabelArray(4)(4).Content = "Label4_4"
        LabelArray(4)(5).Content = "Label4_5"
        LabelArray(4)(6).Content = "Label4_6"
        LabelArray(4)(7).Content = "Label4_7"
        LabelArray(5)(0).Content = "Label5_0"
        LabelArray(5)(1).Content = "Label5_1"
        LabelArray(5)(2).Content = "Label5_2"
        LabelArray(5)(3).Content = "Label5_3"
        LabelArray(5)(4).Content = "Label5_4"
        LabelArray(5)(5).Content = "Label5_5"
        LabelArray(5)(6).Content = "Label5_6"
        LabelArray(5)(7).Content = "Label5_7"
        LabelArray(6)(0).Content = "Label6_0"
        LabelArray(6)(1).Content = "Label6_1"
        LabelArray(6)(2).Content = "Label6_2"
        LabelArray(6)(3).Content = "Label6_3"
        LabelArray(6)(4).Content = "Label6_4"
        LabelArray(6)(5).Content = "Label6_5"
        LabelArray(6)(6).Content = "Label6_6"
        LabelArray(6)(7).Content = "Label6_7"
        LabelArray(7)(0).Content = "Label7_0"
        LabelArray(7)(1).Content = "Label7_1"
        LabelArray(7)(2).Content = "Label7_2"
        LabelArray(7)(3).Content = "Label7_3"
        LabelArray(7)(4).Content = "Label7_4"
        LabelArray(7)(5).Content = "Label7_5"
        LabelArray(7)(6).Content = "Label7_6"
        LabelArray(7)(7).Content = "Label7_7"
    End Sub

    Private Sub Window_SizeChanged(ByVal sender As System.Object, ByVal e As System.Windows.SizeChangedEventArgs)
        Dim AdjustScale As System.Windows.Media.ScaleTransform = New System.Windows.Media.ScaleTransform()

        AdjustScale.ScaleX = (Me.Width - 20) / (OriginalWidth - 20)
        AdjustScale.ScaleY = (Me.Height - 40) / (OriginalHeight - 40)

        Me.Height = AdjustScale.ScaleX * OriginalHeight

        CV.RenderTransform = AdjustScale
    End Sub

    Private Sub HideWindow_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs) Handles HideWindow.Click
        Me.Hide()
    End Sub
End Class