﻿Option Explicit On
'Option Strict On
Option Infer Off

Imports System.Windows.Interop
Imports System.Runtime.InteropServices

Public Class AlarmDigital
    Dim Kernel As Kernel

    Dim OriginalWidth As Double
    Dim OriginalHeight As Double

    Dim dsAlarmDigital As shmit.dsAlarmDigital
    Dim DataTable As System.Data.DataTable

    Private Const MF_BYCOMMAND As Integer = &H0&
    Private Const SC_CLOSE As Integer = &HF060&

    <DllImport("User32")> _
    Public Shared Function RemoveMenu(ByVal hMenu As IntPtr, ByVal uPosition As UInteger, ByVal uFlags As UInteger) As Boolean
    End Function

    <DllImport("User32")> _
    Public Shared Function GetSystemMenu(ByVal hWnd As IntPtr, ByVal bRevert As Boolean) As IntPtr
    End Function

    <DllImport("User32")> _
    Public Shared Function DrawMenuBar(ByVal hWnd As IntPtr) As Long
    End Function

    Private Sub AddMsg(ByVal msg As String, ByVal flag As Boolean)
        Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + msg, True)
    End Sub

    Public Sub New(ByVal kernel As Kernel)
        MyBase.New()

        InitializeComponent()
        Init()

        Me.Kernel = kernel
    End Sub

    Public Sub New()
        MyBase.New()

        InitializeComponent()
        Init()
    End Sub

    Private Sub Init()
        OriginalWidth = Me.Width
        OriginalHeight = Me.Height

        Me.MinWidth = OriginalWidth / 2
        Me.MinHeight = OriginalHeight / 2
    End Sub

    Private Sub Window_SizeChanged(ByVal sender As System.Object, ByVal e As System.Windows.SizeChangedEventArgs) Handles AlarmDigital.SizeChanged
        Dim AdjustScale As System.Windows.Media.ScaleTransform = New System.Windows.Media.ScaleTransform()

        AdjustScale.ScaleX = (Me.Width - 20) / (OriginalWidth - 20)
        AdjustScale.ScaleY = (Me.Height - 40) / (OriginalHeight - 40)

        Me.Height = AdjustScale.ScaleX * OriginalHeight

        CV.RenderTransform = AdjustScale
    End Sub

    Private Sub HideWindow_Click(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles HideWindow.Click
        Me.Hide()
    End Sub

    Public Sub InitDataSet()
        DataTable.Clear()

        For count As Integer = 0 To Kernel.LogicalItemArray.Count - 1
            Try
                DataTable.Rows.Add()
                DataTable.Rows(count).Item(DataTable.Columns.IndexOf("NameSet")) = Kernel.LogicalItemArray(count).Name

                DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State1Set")) = Kernel.LogicalItemArray(count).StateArray(0).Name
                DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State1Input")) = Kernel.LogicalItemArray(count).StateArray(0).Name
                If Kernel.LogicalItemArray(count).StateArray(0).MailFlag = 1 Then
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State1MailSet")) = True
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State1MailInput")) = True
                Else
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State1MailSet")) = False
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State1MailInput")) = False
                End If

                DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State2Set")) = Kernel.LogicalItemArray(count).StateArray(1).Name
                DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State2Input")) = Kernel.LogicalItemArray(count).StateArray(1).Name
                If Kernel.LogicalItemArray(count).StateArray(1).MailFlag = 1 Then
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State2MailSet")) = True
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State2MailInput")) = True
                Else
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State2MailSet")) = False
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State2MailInput")) = False
                End If

                If Kernel.LogicalItemArray(count).StateArray.Count > 3 Then
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State3Set")) = Kernel.LogicalItemArray(count).StateArray(2).Name
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State3Input")) = Kernel.LogicalItemArray(count).StateArray(2).Name
                    If Kernel.LogicalItemArray(count).StateArray(2).MailFlag = 1 Then
                        DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State3MailSet")) = True
                        DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State3MailInput")) = True
                    Else
                        DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State3MailSet")) = False
                        DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State3MailInput")) = False
                    End If
                Else
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State3Set")) = "-----"
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State3Input")) = "-----"
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State3MailSet")) = False
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State3MailInput")) = False
                End If

            Catch ex As ResourceReferenceKeyNotFoundException
                MessageBox.Show("[InternalError] DataSetName = dsAlarmDigital not found!")
                End
            End Try
        Next
    End Sub

    Public Sub UpdateDataSet()
        For count As Integer = 0 To Kernel.LogicalItemArray.Count - 1
            Try
                If Kernel.LogicalItemArray(count).StateArray(0).MailFlag = 1 Then
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State1MailSet")) = True
                Else
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State1MailSet")) = False
                End If

                If Kernel.LogicalItemArray(count).StateArray(1).MailFlag = 1 Then
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State2MailSet")) = True
                Else
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State2MailSet")) = False
                End If

                If Kernel.LogicalItemArray(count).StateArray.Count > 3 Then
                    If Kernel.LogicalItemArray(count).StateArray(2).MailFlag = 1 Then
                        DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State3MailSet")) = True
                    Else
                        DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State3MailSet")) = False
                    End If
                Else
                    DataTable.Rows(count).Item(DataTable.Columns.IndexOf("State3MailSet")) = False
                End If

            Catch ex As ResourceReferenceKeyNotFoundException
                MessageBox.Show("[InternalError] Da taSetName = dsAlarmDigital not found!")
                End
            End Try
        Next
    End Sub


    Private Sub AlarmDigital_Initialized(ByVal sender As Object, ByVal e As System.EventArgs)
        'TODO: ここにイベント ハンドラーのコードを追加します。
        dsAlarmDigital = CType(Me.FindResource("dsAlarmDigital"), shmit.dsAlarmDigital)
        DataTable = CType(dsAlarmDigital.Tables("DataTable1"), System.Data.DataTable)
    End Sub

    Private Sub AlarmDigital_Loaded(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs)
        Dim windowHandle As IntPtr = (New WindowInteropHelper(Me)).Handle

        Call RemoveMenu(GetSystemMenu(windowHandle, False), SC_CLOSE, MF_BYCOMMAND)
        Call DrawMenuBar(windowHandle)
        'Dim dsAlarmDigital As shmit.dsAlarmDigital = CType(Me.FindResource("dsAlarmDigital"), shmit.dsAlarmDigital)


    End Sub

        Private Sub SetData_Click(ByVal sender as Object, ByVal e as System.Windows.RoutedEventArgs)
        	'TODO: ここにイベント ハンドラーのコードを追加します。
			        Dim doc As XDocument = XDocument.Load("System.xml")
        Dim Q_LogicalItem As IEnumerable(Of XElement) = From i In doc.<SystemRoot>.<LogicalItemArray>.<LogicalItem> Select i
        For count As Integer = 0 To Q_LogicalItem.Count - 1
            Dim Q_State As IEnumerable(Of XElement) = From i In Q_LogicalItem(count).<StateArray>.<State> Select i
            If CBool(CType(DataTable1ListView.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("State1MailInput"))) = True Then
                Q_State(0).@MailFlag = "1"
            Else
                Q_State(0).@MailFlag = "0"
            End If
            Kernel.LogicalItemArray(count).StateArray(0).MailFlag = CInt(Q_State(0).@MailFlag)

            If CBool(CType(DataTable1ListView.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("State2MailInput"))) = True Then
                Q_State(1).@MailFlag = "1"
            Else
                Q_State(1).@MailFlag = "0"
            End If
            Kernel.LogicalItemArray(count).StateArray(1).MailFlag = CInt(Q_State(1).@MailFlag)


            If Kernel.LogicalItemArray(count).StateArray.Count > 3 Then
                If CBool(CType(DataTable1ListView.Items(count), System.Data.DataRowView).Item(DataTable.Columns.IndexOf("State3MailInput"))) = True Then
                    Q_State(2).@MailFlag = "1"
                Else
                    Q_State(2).@MailFlag = "0"
                End If
                Kernel.LogicalItemArray(count).StateArray(2).MailFlag = CInt(Q_State(2).@MailFlag)
            End If
        Next

        'doc.Save("..\\..\\System.xml")
        doc.Save("System.xml")

        UpdateDataSet()
        End Sub
End Class