﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System
Imports System.Windows
Imports System.Threading
Imports System.IO
Imports System.Text

''' <summary>
''' DataAcquisition
''' </summary>
''' <remarks></remarks>
Public Class DataAcquisitionSync
    Inherits DataAcquisition
    Public ConnectStatus As Integer = -1
    Private ErrFlagPre() As Integer
    Private Kernel As Kernel
    Private LogicalItemPreStatusArray() As Integer

    Dim MailToArray() As String
    Dim ErrorMessageTotal As String = ""

    Public PreviousServerConnectionStatus As Integer = -1
    Public PreviousPlcConnectionStatus As Boolean = False

    ''' <summary>
    ''' Constructor
    ''' </summary>
    ''' <param name="em"></param>
    ''' <param name="Kernel"></param>
    ''' <remarks></remarks>
    Sub New(ByVal em As EventManager, ByVal Kernel As Kernel)
        Me.Kernel = Kernel
        ReDim ErrFlagPre(Kernel.DeviceArray.GetLength(0) - 1)

        If Kernel.MailDestinationArray IsNot Nothing And Kernel.MailSendFlag = 1 Then
            MailToArray = New String(Kernel.MailDestinationArray(0).ToArray.Count - 1) {}
            For count As Integer = 0 To MailToArray.Count - 1
                MailToArray(count) = Kernel.MailDestinationArray(0).ToArray(count).Address
            Next
        End If

        AddHandler em.evtDataAcquisition, AddressOf DataAcquisition ' register DataAcquisition event handler
        AddHandler em.evtMailReminder, AddressOf MailReminder       ' register MailReminder event handler

        LogicalItemPreStatusArray = New Integer(Kernel.LogicalItemArray.Count - 1) {}
        For count As Integer = 0 To Kernel.DeviceArray.GetLength(0) - 1
            ErrFlagPre(count) = -1
        Next

        For count As Integer = 0 To LogicalItemPreStatusArray.Count - 1
            LogicalItemPreStatusArray(count) = Kernel.LogicalItemArray(count).StateArray.Count - 1
        Next
    End Sub

    ''' <summary>
    ''' Acquire data
    ''' </summary>
    ''' <remarks></remarks>
    Sub DataAcquisition()
        Dim j As Integer
        Dim EventCount As Integer = 1
        Dim ErrFlag(Kernel.DeviceArray.GetLength(0) - 1) As Integer

        For count As Integer = 0 To Kernel.DeviceArray.GetLength(0) - 1
            If Kernel.DeviceArray(count).ActiveFlag = 1 Then
                ErrFlag(count) = -1
                j = 0

                ' In case of PLC
                If Kernel.DeviceArray(count).DeviceType.Equals("PLC") Then
                    ErrFlag(count) = Kernel.DeviceArray(count).DoQuery()

                    If ErrFlag(count) <> ErrFlagPre(count) Then
                        If ErrFlag(count) = 1 Then
                            Dim ErrorKind As String = Kernel.DeviceArray(count).GetError()

                            Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + " [DataAcquisition.DataAcquisition] Data acquisition failed. re-connect to " + Kernel.DeviceArray(count).DeviceName + " at intervals of " + Kernel.AcquisitionCycleMilliSecond.ToString + "msec...", True)

                            If Kernel.ComStatus IsNot Nothing Then
                                If Kernel.ComStatus(count) IsNot Nothing Then
                                    Kernel.ChangeStyle(Kernel.ComStatus(count), "LabelWithContent2.0_Red_Blink")
                                End If
                            End If

                            DirectCast(Kernel.DeviceArray(count), PLC).Protocol.Disconnect()
                            DirectCast(Kernel.DeviceArray(count), PLC).CommunicationStatus = False
                        Else
                            Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + " [DataAcquisition.DataAcquisition] Connection recovered. Data acquisition OK. (" + Kernel.DeviceArray(count).DeviceName + ")", True)

                            If Kernel.ComStatus IsNot Nothing Then
                                If Kernel.ComStatus(count) IsNot Nothing Then
                                    Kernel.ChangeStyle(Kernel.ComStatus(count), "LabelWithContent2.0_Green")
                                End If
                            End If
                        End If

                        ErrFlagPre(count) = ErrFlag(count)
                    End If
                End If

                '' In case of BinaryTcpSync
                'If Kernel.DeviceArray(count).DeviceType.Equals("BinaryTcpSync") Then
                '    If Kernel.DeviceArray(count).ActiveFlag = 1 Then
                '        ErrFlag(count) = -1
                '        j = 0

                '        ' データ収集
                '        If Kernel.DeviceArray(count).CommunicationStatus = True Then
                '            ErrFlag(count) = Kernel.DeviceArray(count).DoQuery()
                '        Else
                '            ErrFlag(count) = 1
                '            If DirectCast(Kernel.DeviceArray(count), BinaryTcpSync).BinaryTcpClientIn.Connect = 0 Then
                '                DirectCast(Kernel.DeviceArray(count), BinaryTcpSync).CommunicationStatus = True
                '                ErrFlag(count) = Kernel.DeviceArray(count).DoQuery()
                '            End If
                '        End If

                '        If ErrFlag(count) <> ErrFlagPre(count) Then
                '            If ErrFlag(count) = 1 Then
                '                Dim ErrorKind As String = Kernel.DeviceArray(count).GetError()

                '                If ErrorKind <> "LowerConnectionError" Then
                '                    Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + " [DataAcquisition.DataAcquisition] Data acquisition failed. re-connect to " + Kernel.DeviceArray(count).DeviceName + " at intervals of " + Kernel.AcquisitionCycleMilliSecond.ToString + "msec...", True)
                '                    'Kernel.ChangeStyle(Kernel.GetWindow(Of MainWindow)("MainWindow").ShowLog, "ButtonRoundWithContentRed")

                '                    If Kernel.ComStatus IsNot Nothing Then
                '                        If Kernel.ComStatus(count) IsNot Nothing Then
                '                            Kernel.ChangeStyle(Kernel.ComStatus(count), "LabelWithContent2.0_Red_Blink")
                '                        End If
                '                    End If


                '                    DirectCast(Kernel.DeviceArray(count), BinaryTcpSync).BinaryTcpClientIn.Disconnect()
                '                    DirectCast(Kernel.DeviceArray(count), BinaryTcpSync).CommunicationStatus = False
                '                Else
                '                    Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + " [DataAcquisition.DataAcquisition] Data acquisition failed. LowerConnectionError at " + Kernel.DeviceArray(count).DeviceName, True)
                '                    If Kernel.ComStatus IsNot Nothing Then
                '                        If Kernel.ComStatus(count) IsNot Nothing Then
                '                            Kernel.ChangeStyle(Kernel.ComStatus(count), "LabelWithContent2.0_Yellow")
                '                        End If
                '                    End If
                '                End If
                '            Else
                '                Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + " [DataAcquisition.DataAcquisition] Connection recovered. Data acquisition OK. (" + Kernel.DeviceArray(count).DeviceName + ")", True)

                '                If Kernel.ComStatus IsNot Nothing Then
                '                    If Kernel.ComStatus(count) IsNot Nothing Then
                '                        Kernel.ChangeStyle(Kernel.ComStatus(count), "LabelWithContent2.0_Green")
                '                    End If
                '                End If
                '            End If
                '        End If
                '    End If
                'End If

                ErrFlagPre(count) = ErrFlag(count)
            End If
        Next

        ' Calculate and show LogicalItem 
        For count3 As Integer = 0 To Kernel.LogicalItemArray.GetLength(0) - 1
            Dim UnknownFlag As Integer = -1

            For count2 As Integer = 0 To Kernel.LogicalItemArray(count3).BitItemArray.GetLength(0) - 1
                If ErrFlag(Kernel.LogicalItemArray(count3).BitItemArray(count2).ItemProfile.DeviceIndex) = 1 Then
                    UnknownFlag = 1
                    Exit For
                Else
                    Kernel.LogicalItemArray(count3).BitItemArray(count2).Value = Kernel.DeviceArray(Kernel.LogicalItemArray(count3).BitItemArray(count2).ItemProfile.DeviceIndex).SixteenBitsGetArray(Kernel.LogicalItemArray(count3).BitItemArray(count2).ItemProfile.TagIndex).BitGetArray(Kernel.LogicalItemArray(count3).BitItemArray(count2).ItemProfile.TagIndex2).Value
                End If
            Next

            If UnknownFlag = 1 Then
                For count4 As Integer = 0 To Kernel.LogicalItemArray(count3).BitItemArray.GetLength(0) - 1
                    Kernel.LogicalItemArray(count3).BitItemArray(count4).Value = -1
                Next
            End If

            Kernel.LogicalItemArray(count3).Show()
        Next

        ' Calculate and show RealData
        For count3 As Integer = 0 To Kernel.RealDataArray.GetLength(0) - 1
            Dim DataItemArray() As Double = New Double(Kernel.RealDataArray(count3).Calculation.ItemProfileArray.GetLength(0) - 1) {}
            Dim UnknownFlag As Integer = -1
            Dim WordGetArrayType As String

            For count2 As Integer = 0 To DataItemArray.GetLength(0) - 1
                If Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).Type = "WordGet" Then
                    If ErrFlag(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).DeviceIndex) = 1 Then
                        UnknownFlag = 1
                        Exit For
                    Else
                        WordGetArrayType = Kernel.DeviceArray(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).DeviceIndex).WordGetArray(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).TagIndex).Type

                        If WordGetArrayType Is Nothing Then
                            DataItemArray(count2) = Kernel.DeviceArray(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).DeviceIndex).WordGetArray(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).TagIndex).Value
                        Else
                            If WordGetArrayType.Equals("Array") Then
                                DataItemArray(count2) = Kernel.DeviceArray(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).DeviceIndex).WordGetArray(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).TagIndex).WordItemArray(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).TagIndex2).value
                            Else
                                DataItemArray(count2) = Kernel.DeviceArray(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).DeviceIndex).WordGetArray(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).TagIndex).Value
                            End If
                        End If
                    End If
                ElseIf Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).Type = "RealData" Then
                    DataItemArray(count2) = Kernel.RealDataArray(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).TagIndex).CalData
                Else
                    MessageBox.Show("Illeagal Value or RealDataArray(" + "count3" + ").Calculation.Argument(" + "count2" + ").Type: " + Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).Type)
                End If
            Next

            If UnknownFlag = 1 Then
                Kernel.RealDataArray(count3).CalData = Kernel.RealDataArray(count3).CalDataUnknown
            Else
                Kernel.RealDataArray(count3).Calc(DataItemArray)
            End If

            Kernel.RealDataArray(count3).Show()
        Next

        DataCheck()


        ' In case of BinaryTcpServerIn(PlantInterface)
        'If CType(Kernel.DeviceArray(0), PlantInterface).LastAcquisitionTime.AddSeconds(30) > System.DateTime.Now Then
        '    If ConnectStatus <> 1 Then
        '        Kernel.ChangeStyle(Kernel.GetWindow(Of MainWindow)("MainWindow").PlantInterfaceStatus, "LabelWithContent2.0_Green")
        '        Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + " [DataAcquisition.DataAcquisition] Connection to PlantInterface is OK.", True)
        '        ConnectStatus = 1
        '    End If
        'Else
        '    If ConnectStatus <> 0 Then
        '        For count As Integer = 0 To Kernel.DeviceArray(0).WordGetArray.Count - 1
        '            Kernel.DeviceArray(0).WordGetArray(count).Value = &HFFFF
        '        Next

        '        For count As Integer = 0 To Kernel.DeviceArray(0).SixteenBitsGetArray.Count - 1
        '            Kernel.DeviceArray(0).SixteenBitsGetArray(count).Value = &HFFFF
        '        Next

        '        Kernel.ChangeStyle(Kernel.GetWindow(Of MainWindow)("MainWindow").PlantInterfaceStatus, "LabelWithContent2.0_Red_Blink")
        '        Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + " [DataAcquisition.DataAcquisition] Connection to PlantInterface is NG.", True)
        '        ConnectStatus = 0
        '    End If
        'End If

        ' In case of BinaryTcpClientOut
        'If PreviousServerConnectionStatus = 1 Then                      ' Previous server connection status is "Connected".
        '    If Kernel.DeviceArray(0).CommunicationStatus = True Then    ' PLC connection status is "Connected".
        '        If Kernel.BinaryTcpClientOut.SendAllData() <> 0 Then  ' SendAllData() is failed.
        '            Kernel.BinaryTcpClientOut.Disconnect()

        '            Kernel.ChangeStyle(Kernel.GetWindow(Of MainWindow)("MainWindow").PlantServerStatus, "LabelWithContent2.0_Red_Blink")
        '            Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + " [DataAcquisition.DataAcquisition] Connection to PlantServer is NG.", True)
        '            PreviousServerConnectionStatus = 0                  ' Previous server connection status = "Disconnected".
        '        End If
        '    Else                                                        ' PLC connection status is "Disconnected".
        '        If PreviousPlcConnectionStatus = True Then              ' PLC previous connection status is "Connected"
        '            Kernel.ChangeStyle(Kernel.GetWindow(Of MainWindow)("MainWindow").PlantServerStatus, "LabelWithContent2.0_Yellow")
        '            Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + " [DataAcquisition.DataAcquisition] Connection to PlantServer is OK but the data is not sent.", True)
        '        End If
        '    End If
        'Else                                                            ' Previous server connection status is "Disconnected" or "Unknown".
        '    If Kernel.BinaryTcpClientOut.Connect() = 0 Then           ' Connect server successfully. 
        '        If Kernel.BinaryTcpClientOut.SendAllData() = 0 Then   ' SendAllData() successfully.
        '            Kernel.ChangeStyle(Kernel.GetWindow(Of MainWindow)("MainWindow").PlantServerStatus, "LabelWithContent2.0_Green")
        '            Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + " [DataAcquisition.DataAcquisition] Connection to PlantServer is OK.", True)
        '        Else                                                       ' SendAllData() failed.
        '            Kernel.ChangeStyle(Kernel.GetWindow(Of MainWindow)("MainWindow").PlantServerStatus, "LabelWithContent2.0_Red_Blink")
        '            Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + " [DataAcquisition.DataAcquisition] Connection to PlantServer is NG.", True)
        '        End If
        '        PreviousServerConnectionStatus = 1
        '    Else                                                        ' Connect server failed.
        '        Kernel.BinaryTcpClientOut.Disconnect()

        '        If PreviousServerConnectionStatus = -1 Then             ' Previous server connection status is "Unknown". 
        '            Kernel.ChangeStyle(Kernel.GetWindow(Of MainWindow)("MainWindow").PlantServerStatus, "LabelWithContent2.0_Red_Blink")
        '            Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + " [DataAcquisition.DataAcquisition] Connection to PlantServer is NG.", True)
        '        End If
        '        PreviousServerConnectionStatus = 0
        '    End If
        'End If

        PreviousPlcConnectionStatus = Kernel.DeviceArray(0).CommunicationStatus
    End Sub

    ''' <summary>
    ''' Check data consistency
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function DataCheck() As Integer
        Dim ErrorMessage As String = ""
        Dim RecoveryMessage As String = ""

        Dim RecoveryMessageTotal As String = ""

        For count As Integer = 0 To Kernel.RealDataArray.Count - 1
            For count2 As Integer = 0 To Kernel.RealDataArray(count).UpperLimitItemArray.Count - 1
                Dim CurrentAlarmStatus As Integer = Kernel.RealDataArray(count).UpperLimitItemArray(count2).Status

                If (CurrentAlarmStatus = 0 Or CurrentAlarmStatus = -1) And Kernel.RealDataArray(count).CalData > Kernel.RealDataArray(count).UpperLimitItemArray(count2).LimitValue Then
                    If Kernel.RealDataArray(count).UpperLimitItemArray(count2).AlarmFlag = 1 Then
                        ErrorMessage = "Range over: " + Kernel.RealDataArray(count).Name + " " + Kernel.RealDataArray(count).UpperLimitItemArray(count2).Name
                        DirectCast(Kernel.WindowHashTable("LOGMSG"), LOGMSG).AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + "[DataAcquisitionSync.DataCheck] " + ErrorMessage, True)
                    End If

                    If Kernel.MailSendFlag = 1 And Kernel.RealDataArray(count).UpperLimitItemArray(count2).MailFlag = 1 Then
                        ErrorMessageTotal = ErrorMessageTotal + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss ") + ErrorMessage + vbCrLf
                    End If

                    Kernel.RealDataArray(count).UpperLimitItemArray(count2).Status = 1
                ElseIf CurrentAlarmStatus = 1 And Kernel.RealDataArray(count).CalData < Kernel.RealDataArray(count).UpperLimitItemArray(count2).RecoveryValue Then
                    If Kernel.RealDataArray(count).UpperLimitItemArray(count2).AlarmFlag = 1 Then
                        RecoveryMessage = "Range recovery: " + Kernel.RealDataArray(count).Name + " " + Kernel.RealDataArray(count).UpperLimitItemArray(count2).Name
                        DirectCast(Kernel.WindowHashTable("LOGMSG"), LOGMSG).AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + "[DataAcquisitionSync.DataCheck] " + RecoveryMessage, True)
                    End If

                    If Kernel.MailSendFlag = 1 And Kernel.RealDataArray(count).UpperLimitItemArray(count2).MailFlag = 1 Then
                        RecoveryMessageTotal = RecoveryMessageTotal + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss ") + RecoveryMessage + vbCrLf
                    End If

                    Kernel.RealDataArray(count).UpperLimitItemArray(count2).Status = 0
                ElseIf CurrentAlarmStatus = -1 And Kernel.RealDataArray(count).CalData < Kernel.RealDataArray(count).UpperLimitItemArray(count2).RecoveryValue Then
                    Kernel.RealDataArray(count).UpperLimitItemArray(count2).Status = 0
                End If
            Next

            For count2 As Integer = 0 To Kernel.RealDataArray(count).LowerLimitItemArray.Count - 1
                Dim CurrentAlarmStatus As Integer = Kernel.RealDataArray(count).LowerLimitItemArray(count2).Status

                If (CurrentAlarmStatus = 0 Or CurrentAlarmStatus = -1) And Kernel.RealDataArray(count).CalData < Kernel.RealDataArray(count).LowerLimitItemArray(count2).LimitValue Then
                    If Kernel.RealDataArray(count).LowerLimitItemArray(count2).AlarmFlag = 1 Then
                        ErrorMessage = "Range over: " + Kernel.RealDataArray(count).Name + " " + Kernel.RealDataArray(count).LowerLimitItemArray(count2).Name
                        DirectCast(Kernel.WindowHashTable("LOGMSG"), LOGMSG).AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + "[DataAcquisitionSync.DataCheck] " + ErrorMessage, True)
                    End If

                    If Kernel.MailSendFlag = 1 And Kernel.RealDataArray(count).LowerLimitItemArray(count2).MailFlag = 1 Then
                        ErrorMessageTotal = ErrorMessageTotal + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss ") + ErrorMessage + vbCrLf
                    End If

                    Kernel.RealDataArray(count).LowerLimitItemArray(count2).Status = 1
                ElseIf CurrentAlarmStatus = 1 And Kernel.RealDataArray(count).CalData > Kernel.RealDataArray(count).LowerLimitItemArray(count2).RecoveryValue Then
                    If Kernel.RealDataArray(count).LowerLimitItemArray(count2).AlarmFlag = 1 Then
                        RecoveryMessage = "Range recovery: " + Kernel.RealDataArray(count).Name + " " + Kernel.RealDataArray(count).LowerLimitItemArray(count2).Name
                        DirectCast(Kernel.WindowHashTable("LOGMSG"), LOGMSG).AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + "[DataAcquisitionSync.DataCheck] " + RecoveryMessage, True)
                    End If

                    If Kernel.MailSendFlag = 1 And Kernel.RealDataArray(count).LowerLimitItemArray(count2).MailFlag = 1 Then
                        RecoveryMessageTotal = RecoveryMessageTotal + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss ") + RecoveryMessage + vbCrLf
                    End If

                    Kernel.RealDataArray(count).LowerLimitItemArray(count2).Status = 0
                ElseIf CurrentAlarmStatus = -1 And Kernel.RealDataArray(count).CalData > Kernel.RealDataArray(count).LowerLimitItemArray(count2).RecoveryValue Then
                    Kernel.RealDataArray(count).LowerLimitItemArray(count2).Status = 0
                End If
            Next
        Next

        For count As Integer = 0 To Kernel.LogicalItemArray.Count - 1
            If Kernel.LogicalItemArray(count).CurrentStatusId <> LogicalItemPreStatusArray(count) Then
                If Kernel.LogicalItemArray(count).StateArray(Kernel.LogicalItemArray(count).CurrentStatusId).AlarmFlag = 1 Then
                    ErrorMessage = "Status error: " + Kernel.LogicalItemArray(count).Name + " " + Kernel.LogicalItemArray(count).StateArray(Kernel.LogicalItemArray(count).CurrentStatusId).Name
                    DirectCast(Kernel.WindowHashTable("LOGMSG"), LOGMSG).AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + "[DataAcquisitionSync.DataCheck] " + ErrorMessage, True)
                End If

                If Kernel.MailSendFlag = 1 And Kernel.LogicalItemArray(count).StateArray(Kernel.LogicalItemArray(count).CurrentStatusId).MailFlag = 1 Then
                    ErrorMessageTotal = ErrorMessageTotal + DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss ") + ErrorMessage + vbCrLf
                End If
                LogicalItemPreStatusArray(count) = Kernel.LogicalItemArray(count).CurrentStatusId
            End If
        Next

        If Kernel.MailSendFlag = 1 And Not ErrorMessageTotal.Equals("") Then
            Kernel.SMTPmail.SendMail("sender@domainname", MailToArray, Nothing, Nothing, "Error occured", ErrorMessageTotal)
            If Kernel.MailDestinationArray(0).ReminderEnabled = 1 Then
                Kernel.em.MailReminderCurrentCount = Kernel.em.MailReminderEventCount
            End If
        End If

        If Kernel.MailSendFlag = 1 And Not RecoveryMessageTotal.Equals("") Then
            Kernel.SMTPmail.SendMail("sender@domainname", MailToArray, Nothing, Nothing, "Error recovered", RecoveryMessageTotal)
        End If

        Return 0
    End Function

    Sub MailReminder()
        Kernel.SMTPmail.SendMail("sender@domainname", MailToArray, Nothing, Nothing, "Error occured (reminder)", ErrorMessageTotal)
    End Sub
End Class

