﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Net

''' <summary>
''' ClockDivider
''' </summary>
''' <remarks></remarks>
Public Class StandardEmbededLinux
    Inherits Device

    Private Kernel As Kernel
    Private err As String = ""

    ''' <summary>
    ''' Get error details
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function GetError() As String
        GetError = err
    End Function

    ''' <summary>
    ''' Construction
    ''' </summary>
    ''' <param name="Kernel"></param>
    ''' <param name="Q_Device"></param>
    ''' <remarks></remarks>
    Sub New(ByVal Kernel As Kernel, ByVal Q_Device As System.Xml.Linq.XElement)
        Me.Kernel = Kernel
        Resource = New Object

        DeviceName = Q_Device.@Name
        DeviceType = Q_Device.@Type
        ActiveFlag = CInt(Q_Device.@ActiveFlag)

        Dim Q_Protocol As IEnumerable(Of XElement) = Q_Device.<Protocol>

        Try
            Protocol = CType(System.Activator.CreateInstance(Type.GetType(Me.GetType.Namespace.ToString() + "." + Q_Protocol.@Name), New Object() {Q_Protocol}), StandardBinaryProtocol)
        Catch ex As Exception
            MessageBox.Show("[BinaryTcpSync.New] CreateInstance (" + Me.GetType.Namespace.ToString() + "." + Q_Protocol.@Name + ") failed.")
        End Try

        '<WordGetArray>
        Dim Q_WordGet As IEnumerable(Of XElement) = From i In Q_Device.<WordGetArray>.<WordGet> Select i
        WordGetArray = New WordGet(Q_WordGet.Count - 1) {}

        For count2 As Integer = 0 To Q_WordGet.Count - 1
            Dim Name As String = Q_WordGet(count2).@Name
            Dim Tag As String = Q_WordGet(count2).@Tag
            Dim Type As String = Q_WordGet(count2).@Type
            Dim Address As UInt32 = CUInt(Q_WordGet(count2).@Address)

            If Type Is Nothing Then
                WordGetArray(count2) = New WordGet(Name, Tag, Nothing, Address)
                WordGetArray(count2).IsArrayFlag = False
                Try
                    WordGetArrayHt.Add(Tag, count2)
                Catch ArgumentException As Exception
                    MessageBox.Show("[ClockDivider.New] Tag= " + Tag + " is duplicated in <WordGetArray>!")
                    End
                End Try
            ElseIf Type.Equals("Array") Then
                Dim Address2 As UInt32 = CUInt(Q_WordGet(count2).@Address2)

                '<WordItem>
                Dim Q_WordItem As IEnumerable(Of XElement) = From i In Q_WordGet(count2).<WordItem> Select i

                WordItemArray = New WordItem(Q_WordItem.Count - 1) {}
                For count3 As Integer = 0 To Q_WordItem.Count - 1
                    Dim WordItemName As String = Q_WordItem(count3).@Name
                    Dim WordItemTag As String = Q_WordItem(count3).@Tag
                    Dim WordItemIndex As Integer = CInt(Q_WordItem(count3).@Index)

                    WordItemArray(count3) = New WordItem(WordItemName, WordItemTag, WordItemIndex)

                    Try
                        WordGetArrayHt.Add(WordItemTag, count2)
                    Catch ArgumentException As Exception
                        MessageBox.Show("[ClockDivider.New] WordItemTag= " + WordItemTag + " is duplicated in <WordGetArray>!")
                        End
                    End Try

                    Try
                        WordGetArrayHt2.Add(WordItemTag, count3)
                    Catch ArgumentException As Exception
                        MessageBox.Show("[ClockDivider.New] WordItemTag= " + WordItemTag + " is duplicated in <WordGetArray><WordItem>!")
                        End
                    End Try
                Next

                WordGetArray(count2) = New WordGet(Name, Tag, Type, Address, Address2, WordItemArray)
                WordGetArray(count2).IsArrayFlag = True
            Else
                WordGetArray(count2) = New WordGet(Name, Tag, Type, Address)
                WordGetArray(count2).IsArrayFlag = False
                Try
                    WordGetArrayHt.Add(Tag, count2)
                Catch ArgumentException As Exception
                    MessageBox.Show("[ClockDivider.New] Tag= " + Tag + " is duplicated in <WordGetArray>!")
                    End
                End Try
            End If
        Next

        '<WordGetQueryArray>
        Dim Q_WordGetQuery As IEnumerable(Of XElement) = From i In Q_Device.<WordGetQueryArray>.<WordGetQuery> Select i
        WordGetQueryArray = New GetQuery(Q_WordGetQuery.Count - 1) {}

        For count2 As Integer = 0 To Q_WordGetQuery.Count - 1
            Dim Type As String = Q_WordGetQuery(count2).@Type

            If Type.Equals("Sequencial") Then
                Dim VariableAddress As UInt32 = CUInt(Q_WordGetQuery(count2).@VariableAddress)
                Dim StartValue As Int32 = CInt(Q_WordGetQuery(count2).@StartValue)
                Dim EndValue As Int32 = CInt(Q_WordGetQuery(count2).@EndValue)
                Dim DataAddress As UInt32 = CUInt(Q_WordGetQuery(count2).@DataAddress)

                Dim Q_GetItem As IEnumerable(Of XElement) = From i In Q_WordGetQuery(count2).<GetItem> Select i
                Dim GetItemArray() As Integer = New Integer(Q_GetItem.Count - 1) {} ' data sequence for each WordGet query

                For count3 As Integer = 0 To Q_GetItem.Count - 1
                    GetItemArray(count3) = CInt(Q_GetItem(count3).@Num)
                Next

                WordGetQueryArray(count2) = New GetQuery(Type, VariableAddress, StartValue, EndValue, DataAddress, GetItemArray)
            Else
                Dim StartAddress As UInt32 = CUInt(Q_WordGetQuery(count2).@StartAddress)
                Dim GetCount As Int32 = CInt(Q_WordGetQuery(count2).@Count)

                Dim Q_GetItem As IEnumerable(Of XElement) = From i In Q_WordGetQuery(count2).<GetItem> Select i
                Dim GetItemArray() As Integer = New Integer(Q_GetItem.Count - 1) {} ' data sequence for each WordGet query

                For count3 As Integer = 0 To Q_GetItem.Count - 1
                    GetItemArray(count3) = CInt(Q_GetItem(count3).@Num)
                Next

                WordGetQueryArray(count2) = New GetQuery(Type, StartAddress, GetCount, GetItemArray)
            End If
        Next

        '<WordSetArray>
        Dim Q_WordSet As IEnumerable(Of XElement) = From i In Q_Device.<WordSetArray>.<WordSet> Select i
        WordSetArray = New WordSet(Q_WordSet.Count - 1) {}

        For count2 As Integer = 0 To Q_WordSet.Count - 1
            Dim Name As String = Q_WordSet(count2).@Name
            Dim Tag As String = Q_WordSet(count2).@Tag
            Dim Type As String = Q_WordSet(count2).@Type
            Dim Address As UInteger = CUInt(Q_WordSet(count2).@Address)
            Dim Format As String = Q_WordSet(count2).@Format
            Dim Unit As String = Q_WordSet(count2).@Unit

            If Type Is Nothing Then
                WordSetArray(count2) = New WordSet(Name, Tag, Nothing, Address, Format, Unit)
                WordSetArray(count2).IsArrayFlag = False

                Try
                    WordSetArrayHt.Add(Tag, count2)
                Catch ArgumentException As Exception
                    MessageBox.Show("[ClockDivider.New] Tag= " + Tag + " is duplicated in <WordSetArray>!")
                    End
                End Try
            ElseIf Type.Equals("Array") Then
                Dim Address2 As UInteger = CUInt(Q_WordSet(count2).@Address2)

                '<WordItem>
                Dim Q_WordItem As IEnumerable(Of XElement) = From i In Q_WordSet(count2).<WordItem> Select i

                WordItemArray = New WordItem(Q_WordItem.Count - 1) {}
                For count3 As Integer = 0 To Q_WordItem.Count - 1
                    Dim WordItemName As String = Q_WordItem(count3).@Name
                    Dim WordItemTag As String = Q_WordItem(count3).@Tag
                    Dim WordItemIndex As Integer = CInt(Q_WordItem(count3).@Index)

                    WordItemArray(count3) = New WordItem(WordItemName, WordItemTag, WordItemIndex)

                    Try
                        WordSetArrayHt.Add(WordItemTag, count2)
                    Catch ArgumentException As Exception
                        MessageBox.Show("[ClockDivider.New] WordItemTag= " + WordItemTag + " is duplicated in <WordSetArray>!")
                        End
                    End Try

                    Try
                        WordSetArrayHt2.Add(WordItemTag, count3)
                    Catch ArgumentException As Exception
                        MessageBox.Show("[ClockDivider.New] WordItemTag= " + WordItemTag + " is duplicated in <WordSetArray><WordItem>!")
                        End
                    End Try
                Next

                WordSetArray(count2) = New WordSet(Name, Tag, Type, Address, Address2, WordItemArray, Format, Unit)
                WordSetArray(count2).IsArrayFlag = True
            Else
                WordSetArray(count2) = New WordSet(Name, Tag, Type, Address, Format, Unit)
                WordSetArray(count2).IsArrayFlag = False
                Try
                    WordSetArrayHt.Add(Tag, count2)
                Catch ArgumentException As Exception
                    MessageBox.Show("[ClockDivider.New] Tag= " + Tag + " is duplicated in <WordsetArray>!")
                    End
                End Try
            End If
        Next

        '<SixteenBitsGetArray>
        Dim Q_SixteenBitsGet As IEnumerable(Of XElement) = From i In Q_Device.<SixteenBitsGetArray>.<SixteenBitsGet> Select i
        SixteenBitsGetArray = New SixteenBitsGet(Q_SixteenBitsGet.Count - 1) {}

        For count2 As Integer = 0 To Q_SixteenBitsGet.Count - 1
            Dim Type As String = Q_SixteenBitsGet(count2).@Type
            Dim Address As UInt32 = CUInt(Q_SixteenBitsGet(count2).@Address)

            Dim Q_BitGet As IEnumerable(Of XElement) = From i In Q_SixteenBitsGet(count2).<BitGet> Select i
            Dim BitGetArray() As BitGet = New BitGet(Q_BitGet.Count - 1) {}

            For count3 As Integer = 0 To Q_BitGet.Count - 1
                Dim BitNum As Integer = CInt(Q_BitGet(count3).@BitNum)
                Dim Name As String = Q_BitGet(count3).@Name
                Dim Tag As String = Q_BitGet(count3).@Tag
                BitGetArray(count3) = New BitGet(BitNum, Name, Tag)

                Try
                    SixteenBitsGetArrayHt.Add(Tag, count2)
                Catch ArgumentException As Exception
                    MessageBox.Show("[ClockDivider.New] Tag= " + Tag + " is duplicated in <SixteenBitsGetArray>!")
                    End
                End Try

                Try
                    BitGetArrayHt.Add(Tag, count3)
                Catch ArgumentException As Exception
                    MessageBox.Show("[ClockDivider.New] Tag= " + Tag + " is duplicated in <BitGetArray>!")
                    End
                End Try
            Next

            SixteenBitsGetArray(count2) = New SixteenBitsGet(Type, Address, BitGetArray)
        Next


        '<SixteenBitsGetQueryArray>
        Dim Q_SixteenBitsGetQuery As IEnumerable(Of XElement) = From i In Q_Device.<SixteenBitsGetQueryArray>.<SixteenBitsGetQuery> Select i
        SixteenBitsGetQueryArray = New GetQuery(Q_SixteenBitsGetQuery.Count - 1) {}

        For count2 As Integer = 0 To Q_SixteenBitsGetQuery.Count - 1
            Dim Type As String = Q_SixteenBitsGetQuery(count2).@Type
            Dim StartAddress As UInt32 = CUInt(Q_SixteenBitsGetQuery(count2).@StartAddress)
            Dim GetCount As Int32 = CInt(Q_SixteenBitsGetQuery(count2).@Count)

            Dim Q_GetItem As IEnumerable(Of XElement) = From i In Q_SixteenBitsGetQuery(count2).<GetItem> Select i
            Dim GetItemArray() As Integer = New Integer(Q_GetItem.Count - 1) {} '' Data sequence in query

            For count3 As Integer = 0 To Q_GetItem.Count - 1
                GetItemArray(count3) = CInt(Q_GetItem(count3).@Num)
            Next

            SixteenBitsGetQueryArray(count2) = New GetQuery(Type, StartAddress, GetCount, GetItemArray)
        Next


        '<BitSetArray>
        Dim Q_BitSet As IEnumerable(Of XElement) = From i In Q_Device.<BitSetArray>.<BitSet> Select i
        BitSetArray = New BitSet(Q_BitSet.Count - 1) {}

        For count2 As Integer = 0 To Q_BitSet.Count - 1
            Dim Name As String = Q_BitSet(count2).@Name
            Dim Tag As String = Q_BitSet(count2).@Tag
            Dim Type As String = Q_BitSet(count2).@Type
            Dim Address As UInteger = CUInt(Q_BitSet(count2).@Address)
            Dim BitNum As Integer = CInt(Q_BitSet(count2).@BitNum)

            BitSetArray(count2) = New BitSet(Name, Tag, Type, Address, BitNum)
        Next


        If ActiveFlag = 1 Then
            If Protocol.Connect() = 0 Then
                CommunicationStatus = True
                Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + "[ClockDivider.New] Connected! (" + DeviceName + ")", True)
            Else
                Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + "[ClockDivider.New] Connection failed... (" + DeviceName + ")", True)
            End If
        End If
    End Sub

    ''' <summary>
    ''' Acquire digital and analog data
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function DoQuery() As Integer
        Dim UInt16Array() As UInt16 = New UInt16() {}
        Dim ErrFlag As Integer = 0
        Dim Result As Integer
        Dim i As Integer, j As Integer, k As Integer, l As Integer
        Dim TempValue As UInt16

        ' Acquire digital data
        j = 0
        For i = 0 To SixteenBitsGetQueryArray.GetLength(0) - 1
            SyncLock Resource
                Result = DirectCast(Protocol, StandardBinaryProtocol).ReadWords(SixteenBitsGetQueryArray(i).StartAddress, SixteenBitsGetQueryArray(i).Count, UInt16Array)
            End SyncLock

            If Result <> 0 Then
                Dim ErrMsg As String = Protocol.GetError()
                If ErrMsg.Equals("TIMEOUT") Or ErrMsg.Equals("RecvErr") Or ErrMsg.Equals("RecvLengthError") Or ErrMsg.Equals("PORT_CLOSED") Then
                    ErrFlag = 1
                    Exit For
                Else
                    ErrFlag = 1
                    Continue For
                End If
            Else
                For k = 0 To SixteenBitsGetQueryArray(i).GetItemArray.GetLength(0) - 1
                    TempValue = UInt16Array(SixteenBitsGetQueryArray(i).GetItemArray(k))
                    SixteenBitsGetArray(j).Value = TempValue
                    For l = 0 To 15
                        If (TempValue And CType(2 ^ l, Long)) = 0 Then
                            SixteenBitsGetArray(j).ValueArray(l) = 0
                        Else
                            SixteenBitsGetArray(j).ValueArray(l) = 1
                        End If
                    Next

                    j = j + 1
                Next

                ' Separate into bit data
                For k = 0 To SixteenBitsGetArray.GetLength(0) - 1
                    For l = 0 To SixteenBitsGetArray(k).BitGetArray.GetLength(0) - 1
                        SixteenBitsGetArray(k).BitGetArray(l).Value = SixteenBitsGetArray(k).ValueArray(SixteenBitsGetArray(k).BitGetArray(l).BitNum)
                    Next
                Next
            End If
        Next

        ' Acquire analog data
        j = 0
        For i = 0 To WordGetQueryArray.GetLength(0) - 1
            If WordGetQueryArray(i).Type.Equals("Sequencial") Then
                SyncLock Resource
                    Result = DirectCast(Protocol, StandardBinaryProtocol).SequencialReadWords(WordGetQueryArray(i).VariableAddress, WordGetQueryArray(i).StartValue, WordGetQueryArray(i).EndValue, WordGetQueryArray(i).DataAddress, UInt16Array)
                End SyncLock
                If Result <> 0 Then
                    Dim ErrMsg As String = Protocol.GetError()
                    If ErrMsg.Equals("TIMEOUT") Or ErrMsg.Equals("RecvErr") Or ErrMsg.Equals("RecvLengthError") Then
                        ErrFlag = 1
                        Exit For
                    Else
                        ErrFlag = 1
                        Continue For
                    End If
                Else
                    For k = 0 To WordGetQueryArray(i).GetItemArray.GetLength(0) - 1
                        Dim Int32Value As Int32 = UInt16Array(WordGetQueryArray(i).GetItemArray(k))
                        'If Int32Value >= 32768 Then
                        '    Int32Value = Int32Value - 65536
                        'End If
                        If Int32Value >= 32768 Then
                            Int32Value = 0
                        End If

                        WordGetArray(j).WordItemArray(k).value = Int32Value
                    Next

                    j = j + 1
                End If
            Else    'Single
                SyncLock Resource
                    Result = DirectCast(Protocol, StandardBinaryProtocol).ReadWords(WordGetQueryArray(i).StartAddress, WordGetQueryArray(i).Count, UInt16Array)
                End SyncLock
                If Result <> 0 Then
                    Dim ErrMsg As String = Protocol.GetError()
                    If ErrMsg.Equals("TIMEOUT") Or ErrMsg.Equals("RecvErr") Or ErrMsg.Equals("RecvLengthError") Then
                        ErrFlag = 1
                        Exit For
                    Else
                        ErrFlag = 1
                        Continue For
                    End If
                Else
                    For k = 0 To WordGetQueryArray(i).GetItemArray.GetLength(0) - 1
                        Dim Int32Value As Int32 = UInt16Array(WordGetQueryArray(i).GetItemArray(k))
                        'If Int32Value >= 32768 Then
                        '    Int32Value = Int32Value - 65536
                        'End If
                        If Int32Value >= 32768 Then
                            Int32Value = 0
                        End If

                        WordGetArray(j).Value = Int32Value
                        j = j + 1
                    Next
                End If
            End If
        Next

        'j = 0
        'For i = 0 To WordGetQueryArray.GetLength(0) - 1
        '    SyncLock Resource
        '        Result = StandardBinaryProtocol.ReadWords(WordGetQueryArray(i).StartAddress, WordGetQueryArray(i).Count, UInt16Array)
        '    End SyncLock
        '    If Result <> 0 Then
        '        Dim ErrMsg As String = StandardBinaryProtocol.GetError()
        '        If ErrMsg.Equals("TIMEOUT") Or ErrMsg.Equals("RecvErr") Or ErrMsg.Equals("RecvLengthError") Then
        '            ErrFlag = 1
        '            Exit For
        '        Else
        '            ErrFlag = 1
        '            Continue For
        '        End If
        '    Else
        '        For k = 0 To WordGetQueryArray(i).GetItemArray.GetLength(0) - 1
        '            Dim Int32Value As Int32 = UInt16Array(WordGetQueryArray(i).GetItemArray(k))
        '            'If Int32Value >= 32768 Then
        '            '    Int32Value = Int32Value - 65536
        '            'End If
        '            If Int32Value >= 32768 Then
        '                Int32Value = 0
        '            End If

        '            WordGetArray(j).Value = Int32Value
        '            j = j + 1
        '        Next
        '    End If
        'Next

        Return ErrFlag
    End Function

    ''' <summary>
    ''' Set word data to ClockDivider
    ''' </summary>
    ''' <param name="Tag"></param>
    ''' <param name="value"></param>
    ''' <param name="LogFlag"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function SetWord(ByVal Tag As String, ByVal value As UInt16, ByVal LogFlag As Boolean) As Integer
        Dim result As Integer
        Dim ShowFormat As String = Nothing
        Dim ht As Integer
        Dim ht2 As Integer

        result = SearchWordSetArrayHt(Tag, ht, ht2)
        If result = 0 Then
            SyncLock Resource
                result = DirectCast(Protocol, StandardBinaryProtocol).WriteWords(Nothing, WordSetArray(ht).Address, 1, New UInt16() {value})
            End SyncLock

            If result <> 0 Then
                'MessageBox.Show("[ClockDivider.SetWord] Error: " + Protocol.GetError + ":" + result.ToString("X"))
                MessageBox.Show("[ClockDivider.SetWord] Error: Set failed.(" + Tag + ")")
                'Kernel.AddMsg("[ClockDivider.SetWord] Error: Set Failed.(" + Tag + ")", LogFlag)
                Return -1
            Else

                ShowFormat = WordSetArray(ht).Format

                'Kernel.AddMsg("[ClockDivider.SetWord] " + Tag + "=" + value.ToString(ShowFormat), LogFlag)
                Return 0
            End If
        ElseIf result = 1 Then
            SyncLock Resource
                result = DirectCast(Protocol, StandardBinaryProtocol).SequencialWriteWords(WordSetArray(ht).Address2, WordSetArray(ht).WordItemArray(ht2).Index, WordSetArray(ht).WordItemArray(ht2).Index, WordSetArray(ht).Address, New UInt16() {value})
            End SyncLock

            If result <> 0 Then
                'MessageBox.Show("[ClockDivider.SetWord] Error: " + Protocol.GetError + ":" + result.ToString("X"))
                MessageBox.Show("[ClockDivider.SetWord] Error: Set failed.(" + Tag + ")")
                '.AddMsg("[ClockDivider.SetWord] Error: Set Failed.(" + Tag + ")", LogFlag)
                Return -1
            Else

                ShowFormat = WordSetArray(ht).Format

                Kernel.AddMsg("[ClockDivider.SetWord] " + Tag + "=" + value.ToString(ShowFormat), LogFlag)
                Return 0
            End If
        Else
            MessageBox.Show("[ClockDivider.SetWord] Error: Tag not found.(" + Tag + ")")
            'Kernel.AddMsg("[ClockDivider.SetWord] Error: TagName not found.(" + Tag + ")", LogFlag)
            Return -1
        End If
    End Function

    ''' <summary>
    ''' Set multiple word data to ClockDivider
    ''' </summary>
    ''' <param name="Tag"></param>
    ''' <param name="value"></param>
    ''' <param name="LogFlag"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function SetWords(ByVal Tag() As String, ByVal value() As UInt16, ByVal LogFlag As Boolean) As Integer
        Dim result As Integer
        Dim FindFlag As Boolean = False
        Dim MatchFlag As Boolean = True
        Dim ht As Integer
        Dim ht2 As Integer

        result = SearchWordSetArrayHt(Tag(0), ht, ht2)

        If result = 0 Then
            For count2 As Integer = 1 To Tag.GetLength(0) - 1
                If WordSetArray(ht + count2).Tag <> Tag(count2) Or WordSetArray(ht).Type <> WordSetArray(ht + count2).Type Or WordSetArray(ht).Address + count2 <> WordSetArray(ht + count2).Address Then
                    MatchFlag = False
                    Exit For
                End If
            Next

            If MatchFlag = True Then
                SyncLock Resource
                    result = DirectCast(Protocol, StandardBinaryProtocol).WriteWords(WordSetArray(ht).Type, WordSetArray(ht).Address, Tag.GetLength(0), value)
                End SyncLock

                If result <> 0 Then
                    'MessageBox.Show("[ClockDivider.SetWord] Error: " + Protocol.GetError + ":" + result.ToString("X"))
                    MessageBox.Show("[ClockDivider.SetWords] Error: Set failed.(" + Tag(0) + "and the other" + (Tag.GetLength(0) - 1).ToString() + ")")
                    'Kernel.AddMsg("[ClockDivider.SetWords] Error: Set Failed.(" + Tag(0) + "and the other " + (Tag.GetLength(0) - 1).ToString() + "items)", LogFlag)
                    Return -1
                Else
                    'Kernel.AddMsg("[ClockDivider.SetWord] " + Tag(0) + "and the other " + (Tag.GetLength(0) - 1).ToString() + "items", LogFlag)
                    Return 0
                End If
            Else
                MessageBox.Show("[ClockDivider.SetWords] Error: Tag not match.(" + Tag(0) + "and the other" + (Tag.GetLength(0) - 1).ToString() + ")")
                'Kernel.AddMsg("[ClockDivider.SetWords] Error: TagName not match.(" + Tag(0) + "and the other" + (Tag.GetLength(0) - 1).ToString() + ")", LogFlag)
                Return -1
            End If
        ElseIf result = 1 Then
            For count2 As Integer = 1 To Tag.GetLength(0) - 1
                If WordSetArray(ht).WordItemArray(ht2 + count2).Tag <> Tag(count2) Then
                    MatchFlag = False
                    Exit For
                End If
            Next

            If MatchFlag = True Then
                SyncLock Resource
                    result = DirectCast(Protocol, StandardBinaryProtocol).SequencialWriteWords(WordSetArray(ht).Address2, WordSetArray(ht).WordItemArray(ht2).Index, WordSetArray(ht).WordItemArray(ht2).Index + Tag.GetLength(0) - 1, WordSetArray(ht).Address, value)
                End SyncLock

                If result <> 0 Then
                    'MessageBox.Show("[ClockDivider.SetWord] Error: " + Protocol.GetError + ":" + result.ToString("X"))
                    MessageBox.Show("[ClockDivider.SetWords] Error: Set failed.(" + Tag(0) + "and the other" + (Tag.GetLength(0) - 1).ToString() + ")")
                    'Kernel.AddMsg("[ClockDivider.SetWords] Error: Set Failed.(" + Tag(0) + "and the other " + (Tag.GetLength(0) - 1).ToString() + "items)", LogFlag)
                    Return -1
                Else
                    'Kernel.AddMsg("[ClockDivider.SetWord] " + Tag(0) + "and the other " + (Tag.GetLength(0) - 1).ToString() + "items", LogFlag)
                    Return 0
                End If
            Else
                MessageBox.Show("[ClockDivider.SetWords] Error: Tag not match.(" + Tag(0) + "and the other" + (Tag.GetLength(0) - 1).ToString() + ")")
                'Kernel.AddMsg("[ClockDivider.SetWords] Error: TagName not match.(" + Tag(0) + "and the other" + (Tag.GetLength(0) - 1).ToString() + ")", LogFlag)
                Return -1
            End If
        Else
            MessageBox.Show("[ClockDivider.SetWords] Error: Tag not found.(" + Tag(0) + ")")
            'Kernel.AddMsg("[ClockDivider.SetWords] Error: TagName not found.(" + Tag(0) + ")", LogFlag)
            Return -1
        End If
    End Function

    ''' <summary>
    ''' Set multiple word data to ClockDivider
    ''' </summary>
    ''' <param name="Tag"></param>
    ''' <param name="value"></param>
    ''' <param name="LogFlag"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function SetWords(ByVal Tag As String, ByVal value() As UInt16, ByVal LogFlag As Boolean) As Integer
        Dim result As Integer
        Dim FindFlag As Boolean = False
        Dim MatchFlag As Boolean = True
        Dim ht As Integer
        Dim ht2 As Integer

        result = SearchWordSetArrayHt(Tag, ht, ht2)

        If result = 0 Then
            For count2 As Integer = 1 To value.GetLength(0) - 1
                If WordSetArray(ht).Type <> WordSetArray(ht + count2).Type Or WordSetArray(ht).Address + count2 <> WordSetArray(ht + count2).Address Then
                    MatchFlag = False
                    Exit For
                End If
            Next

            If MatchFlag = True Then
                SyncLock Resource
                    result = DirectCast(Protocol, StandardBinaryProtocol).WriteWords(WordSetArray(ht).Type, WordSetArray(ht).Address, value.GetLength(0), value)
                End SyncLock

                If result <> 0 Then
                    'MessageBox.Show("[ClockDivider.SetWord] Error: " + Protocol.GetError + ":" + result.ToString("X"))
                    MessageBox.Show("[ClockDivider.SetWords] Error: Set failed.(" + Tag + "and the other" + (value.GetLength(0) - 1).ToString() + ")")
                    'Kernel.AddMsg("[ClockDivider.SetWords] Error: Set Failed.(" + Tag(0) + "and the other " + (value.GetLength(0) - 1).ToString() + "items)", LogFlag)
                    Return -1
                Else

                    'Kernel.AddMsg("[ClockDivider.SetWord] " + Tag(0) + "and the other " + (value.GetLength(0) - 1).ToString() + "items", LogFlag)
                    Return 0
                End If
            Else
                MessageBox.Show("[ClockDivider.SetWords] Error: Tag not match.(" + Tag(0) + "and the other" + (value.GetLength(0) - 1).ToString() + ")")
                'Kernel.AddMsg("[ClockDivider.SetWords] Error: TagName not match.(" + Tag(0) + "and the other" + (value.GetLength(0) - 1).ToString() + ")", LogFlag)
                Return -1
            End If
        ElseIf result = 1 Then
            For count2 As Integer = 1 To value.GetLength(0) - 1
                If WordSetArray(ht).WordItemArray(ht2 + count2).Index <> WordSetArray(ht).WordItemArray(ht2).Index + count2 Then
                    MatchFlag = False
                    Exit For
                End If
            Next

            If MatchFlag = True Then
                SyncLock Resource
                    result = DirectCast(Protocol, StandardBinaryProtocol).SequencialWriteWords(WordSetArray(ht).Address2, WordSetArray(ht).WordItemArray(ht2).Index, WordSetArray(ht).WordItemArray(ht2).Index, WordSetArray(ht).Address, value)
                End SyncLock

                If result <> 0 Then
                    'MessageBox.Show("[ClockDivider.SetWord] Error: " + Protocol.GetError + ":" + result.ToString("X"))
                    MessageBox.Show("[ClockDivider.SetWords] Error: Set failed.(" + Tag + "and the other" + (value.GetLength(0) - 1).ToString() + ")")
                    'Kernel.AddMsg("[ClockDivider.SetWords] Error: Set Failed.(" + Tag + "and the other " + (value.GetLength(0) - 1).ToString() + "items)", LogFlag)
                    Return -1
                Else
                    'Kernel.AddMsg("[ClockDivider.SetWord] " + Tag(0) + "and the other " + (value.GetLength(0) - 1).ToString() + "items", LogFlag)
                    Return 0
                End If
            Else
                MessageBox.Show("[ClockDivider.SetWords] Error: Tag not match.(" + Tag(0) + "and the other" + (value.GetLength(0) - 1).ToString() + ")")
                'Kernel.AddMsg("[ClockDivider.SetWords] Error: TagName not match.(" + Tag(0) + "and the other" + (value.GetLength(0) - 1).ToString() + ")", LogFlag)
                Return -1
            End If
        Else
            MessageBox.Show("[ClockDivider.SetWords] Error: Tag not found.(" + Tag + ")")
            'Kernel.AddMsg("[ClockDivider.SetWords] Error: TagName not found.(" + Tag + ")", LogFlag)
            Return -1
        End If
    End Function

    ''' <summary>
    ''' Set bit data to ClockDivider
    ''' </summary>
    ''' <param name="TargetArray"></param>
    ''' <param name="value"></param>
    ''' <param name="LogFlag"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function SetBit(ByVal TargetArray() As String, ByVal value As UInt16, ByVal LogFlag As Boolean) As Integer
        Dim result As Integer
        Dim FindFlag As Integer

        For TargetArrayCount As Integer = 0 To TargetArray.GetLength(0) - 1
            FindFlag = -1

            For BitSetArrayCount As Integer = 0 To BitSetArray.GetLength(0) - 1
                If TargetArray(TargetArrayCount) = BitSetArray(BitSetArrayCount).Tag Then
                    FindFlag = 0

                    Dim Address As UInteger = BitSetArray(BitSetArrayCount).Address

                    SyncLock Resource
                        result = DirectCast(Protocol, StandardBinaryProtocol).WriteBits(BitSetArray(BitSetArrayCount).Type, Address, BitSetArray(BitSetArrayCount).BitNum, value)
                    End SyncLock

                    If result <> 0 Then
                        MessageBox.Show("[ClockDivider.SetBit] Error: " + Protocol.GetError + ":" + result.ToString("X"))
                    End If
                    Exit For
                End If
            Next

            If FindFlag = -1 Then
                MessageBox.Show("[ClockDivider.SetBit] Error: TagName not found.(" + TargetArray(TargetArrayCount) + ")")
                'Kernel.AddMsg("[ClockDivider.SetBit] Error: TagName not found.(" + TargetArray(TargetArrayCount) + ")", LogFlag)
                Return -1
            ElseIf result <> 0 Then
                MessageBox.Show("[ClockDivider.SetBit] Error: Set Bit Failed.(" + TargetArray(TargetArrayCount) + ")")
                'Kernel.AddMsg("[ClockDivider.SetBit] Error: Set Bit Failed.(" + TargetArray(TargetArrayCount) + ")", LogFlag)
                Return -1
            Else
                'Kernel.AddMsg("[ClockDivider.SetBit] " + TargetArray(TargetArrayCount) + "=" + value.ToString(), LogFlag)
                Return 0
            End If
        Next

        Return -1
    End Function
End Class

