﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Threading
Imports System.Net


Public Class AsciiSerialAsync
    Inherits Device

    Dim Kernel As Kernel
    Dim err As String = ""

    Public Overrides Function GetError() As String
        GetError = err
    End Function


    Sub New(ByVal Kernel As Kernel, ByVal Q_Device As System.Xml.Linq.XElement)
        Me.Kernel = Kernel
        Resource = New Object

        DeviceName = Q_Device.@Name
        DeviceType = Q_Device.@Type

        ActiveFlag = CInt(Q_Device.@ActiveFlag)


        Dim Q_Protocol As IEnumerable(Of XElement) = Q_Device.<Protocol>
        Try
            Protocol = CType(System.Activator.CreateInstance(Type.GetType(Me.GetType.Namespace.ToString() + "." + Q_Protocol.@Name), New Object() {Q_Protocol}), Protocol)
        Catch ex As Exception
            MessageBox.Show("[BinaryTcpSync.New] CreateInstance (" + Me.GetType.Namespace.ToString() + "." + Q_Protocol.@Name + ") is failed.")
        End Try


        AddHandler Protocol.AsciiDataReceived, AddressOf OnAsciiDataReceived    ' register DataReceived event
        AddHandler Protocol.ErrorOccured, AddressOf OnErrorOccured              ' register ErrorOccured event

        'If ActiveFlag = 1 Then
        '    If Conn.Connect() = 0 Then
        '        Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + "[BinaryTcpSync.New] Connected! (" + DeviceName + ")", True)
        '    Else
        '        Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + "[BinaryTcpSync.New] Connection failed... (" + DeviceName + ")", True)
        '    End If
        'End If
    End Sub

    Public Overrides Function DoQuery() As Integer
        Return 0
    End Function

    ' event handler for AsciiDataReceived event
    Private Sub OnAsciiDataReceived(ByVal sender As Protocol)
        'AddText("Recv: " + ConnId.ToString + ": " + MakeDispData(data, BytesReceived))

        Try
            ' save data acquisition start time
            LastAcquisitionTime = System.DateTime.Now


            ' calculate RealData
            For count3 As Integer = 0 To Kernel.RealDataArray.GetLength(0) - 1
                Dim ItemProfileArray() As Double = New Double(Kernel.RealDataArray(count3).Calculation.ItemProfileArray.GetLength(0) - 1) {}
                Dim UnknownFlag As Integer = -1

                For count2 As Integer = 0 To ItemProfileArray.GetLength(0) - 1
                    If Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).Type.Equals("WordGet") Then
                        ItemProfileArray(count2) = Kernel.DeviceArray(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).DeviceIndex).WordGetArray(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).TagIndex).Value
                    ElseIf Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).Type.Equals("RealData") Then
                        ItemProfileArray(count2) = Kernel.RealDataArray(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).TagIndex).CalData
                    ElseIf Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).Type.Equals("Command") Then
                        ItemProfileArray(count2) = CType(Kernel.DeviceArray(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).DeviceIndex).Protocol, CustomProtocol). _
                            CustomCommand.AsciiDataGetArray(Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).TagIndex).Value
                    Else
                        MessageBox.Show("Illeagal Value or RealDataArray(" + "count3" + ").Calculation.ItemProfileArray(" + "count2" + ").Type: " + Kernel.RealDataArray(count3).Calculation.ItemProfileArray(count2).Type)
                        End
                    End If
                Next

                If UnknownFlag = 1 Then
                    Kernel.RealDataArray(count3).CalData = Kernel.RealDataArray(count3).CalDataUnknown
                Else
                    Kernel.RealDataArray(count3).Calc(ItemProfileArray)
                End If

                Kernel.RealDataArray(count3).Show()
            Next

            DirectCast(Kernel.em.DataAcquisitionInst, DataAcquisitionAsync).DataReceivedFlag = True
            DirectCast(Kernel.em.DataAcquisitionInst, DataAcquisitionAsync).TimeoutFlag = False
            DirectCast(Kernel.em.DataAcquisitionInst, DataAcquisitionAsync).ConnectStatus = 1

            Dim trd As Thread = New Thread(New ThreadStart(AddressOf Kernel.em.Archive))
            trd.IsBackground = True
            trd.Start()
        Catch ex As Exception
            err = ex.Message
            Kernel.AddMsg("[WetherMonitor.OnDataReceived] Exception! ", True)
        End Try
    End Sub

    ' event handler for ErrorOccured event
    Private Sub OnErrorOccured(ByVal sender As Protocol, ByVal Content As String)
        Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss") + "[AsciiSerialAsync.OnErrorOccured] Error Occured! (" + Content + ")", True)
    End Sub
End Class