﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System
Imports System.IO.Ports

''' <summary>
''' Serial connection
''' </summary>
''' <remarks></remarks>
Public Class SerialSync
    Private Const OK As Integer = 0
    Private Const LOG_ERR As Integer = -1

    Private port As SerialPort              ' Communication port
    Private err As String = ""              ' Error message
    Private Shared Resource1 As New Object  ' For exclusive access control

    Dim PortName As String
    Dim BaudRate As Integer
    Dim Parity As Parity
    Dim DataBits As Integer
    Dim StopBits As StopBits
    Dim NewLine As String
    Dim ReceivedBytesThreshold As Integer
    Dim ReadBufferSize As Integer
    Dim ReadTimeout As Integer
    Dim DtrEnable As Boolean
    Dim RtsEnable As Boolean = False

    Dim NewLineHt As Hashtable = New Hashtable()

    ''' <summary>
    ''' Constructor
    ''' </summary>
    ''' <remarks></remarks>
    Sub New(ByVal PortName As String, ByVal BaudRate As Integer, _
            Optional ByVal Parity As Parity = IO.Ports.Parity.None, Optional ByVal DataBits As Integer = 8, Optional ByVal StopBits As StopBits = IO.Ports.StopBits.One, _
            Optional ByVal NewLine As String = "CrLf", Optional ByVal ReceivedBytesThreshold As Integer = 1, _
            Optional ByVal ReadBufferSize As Integer = 4096, Optional ByVal ReadTimeout As Integer = SerialPort.InfiniteTimeout, _
            Optional ByVal DtrEnable As Boolean = False, Optional ByVal RtsEnable As Boolean = False)

        NewLineHt.Add("Cr", ControlChars.Cr)
        NewLineHt.Add("Lf", ControlChars.Lf)
        NewLineHt.Add("CrLf", ControlChars.CrLf)

        Me.PortName = PortName
        Me.BaudRate = BaudRate
        Me.Parity = Parity
        Me.DataBits = DataBits
        Me.StopBits = StopBits
        Me.NewLine = NewLineHt(NewLine).ToString
        Me.ReceivedBytesThreshold = ReceivedBytesThreshold
        Me.ReadBufferSize = ReadBufferSize
        Me.ReadTimeout = ReadTimeout
        Me.DtrEnable = DtrEnable
        Me.RtsEnable = RtsEnable
    End Sub

    ''' <summary>
    ''' Open serial communication
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Open() As Integer
        Try
            port = New SerialPort(PortName, BaudRate, Parity, DataBits, StopBits)
            port.NewLine = NewLine
            port.ReceivedBytesThreshold = ReceivedBytesThreshold
            port.ReadBufferSize = ReadBufferSize
            port.ReadTimeout = ReadTimeout
            port.DtrEnable = DtrEnable
            port.RtsEnable = RtsEnable
            port.Open()

            Open = 0
        Catch ex As Exception
            Open = -1
        End Try
    End Function

    ''' <summary>
    ''' Get error details
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetError() As String
        GetError = err
    End Function

    ''' <summary>
    ''' Send data through serial connection
    ''' </summary>
    ''' <param name="SendData"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Send(ByVal SendData As String) As Integer
        Try
            port.WriteLine(SendData)
            Send = 0
        Catch ex As InvalidOperationException
            Send = -1
        End Try
    End Function

    ''' <summary>
    ''' Receive data through serial connection
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Recv() As String
        Try
            Dim RecvData As String = port.ReadLine()

            Return RecvData
        Catch ex As TimeoutException
            Return "TIMEOUT"
        Catch ex As InvalidOperationException
            Return "PORT_CLOSED"
        Catch ex As Exception
            Return ex.Message
        End Try
    End Function

    ''' <summary>
    ''' Close serial port
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function Close() As Integer
        Try
            port.Close()
            Close = 0
        Catch ex As Exception
            Close = -1
        End Try
    End Function
End Class
