﻿Option Explicit On
Option Strict On
Option Infer Off

''' <summary>
''' Protocol
''' </summary>
''' <remarks></remarks>
Public MustInherit Class Protocol
    MustOverride Function Connect() As Integer
    MustOverride Function Disconnect() As Integer

    Protected err As String = ""


    Public Name As String
    Public Type As String
    Public HeaderType As String
    Protected HeaderCode As String
    Protected Delimiter As String
    Public CustomCommand As CustomCommand
    Protected HeaderCodeArray() As Byte
    Public AsciiDataGetArray() As AsciiDataGet
    Protected DataLengthWish As Integer
    Protected AsciiDataGetArrayHt As Hashtable = New Hashtable

    ' For asynchronous data acquisition
    Public Event AsciiDataReceived(ByVal sender As Protocol)
    Public Event BinaryDataReceived(ByVal sender As Protocol, ByVal ByteDataArray() As Int32)
    Public Event ErrorOccured(ByVal sender As Protocol, ByVal Content As String)

    ''' <summary>
    ''' Get error details
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetError() As String
        GetError = err
    End Function

    ' For asynchronous data acquisition
    Public Overridable Sub hAsciiDataReceived(ByVal sender As Protocol)
        RaiseEvent AsciiDataReceived(Me)
    End Sub

    ' For asynchronous data acquisition
    Public Overridable Sub hErrorOccured(ByVal sender As Protocol, ByVal Content As String)
        RaiseEvent ErrorOccured(Me, Content)
    End Sub

    ' For asynchronous data acquisition
    Public Overridable Sub hBinaryDataReceived(ByVal sender As Protocol, ByVal ByteDataArray() As Int32)
        RaiseEvent BinaryDataReceived(Me, ByteDataArray)
    End Sub
End Class
