﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System
Imports System.IO
Imports System.Net
Imports System.Windows
Imports System.Windows.Controls
Imports System.Windows.Data
Imports System.Windows.Media.Animation
Imports System.Windows.Navigation
Imports System.Drawing
Imports System.Windows.Interop
Imports System.Runtime.InteropServices


Public Class SelectGraphItemDataGroup
    Const MAX_GRAPH_COUNT As Integer = 6

    Dim InitializedFlag As Integer = 0

    Dim Kernel As Kernel

    Dim DataItemIndexArray(,) As Integer

    Dim OriginalWidth As Double
    Dim OriginalHeight As Double

    Private Const MF_BYCOMMAND As Integer = &H0&
    Private Const SC_CLOSE As Integer = &HF060&

    <DllImport("User32")> _
    Public Shared Function RemoveMenu(ByVal hMenu As IntPtr, ByVal uPosition As UInteger, ByVal uFlags As UInteger) As Boolean
    End Function

    <DllImport("User32")> _
    Public Shared Function GetSystemMenu(ByVal hWnd As IntPtr, ByVal bRevert As Boolean) As IntPtr
    End Function

    <DllImport("User32")> _
    Public Shared Function DrawMenuBar(ByVal hWnd As IntPtr) As Long
    End Function

    Sub New(ByVal Kernel As Kernel)
        MyBase.New()

        Me.Kernel = Kernel

        ' この呼び出しはデザイナーで必要です。
        InitializeComponent()

        OriginalWidth = Me.Width
        OriginalHeight = Me.Height

        Me.MinWidth = OriginalWidth / 2
        Me.MinHeight = OriginalHeight / 2
    End Sub

    Private Sub Init()
        Dim num As Integer = 0
        DataItemIndexArray = New Integer(Kernel.DataGroupArray.GetLength(0) - 1, 9) {}

        For count As Integer = 0 To Kernel.DataGroupArray.GetLength(0) - 1
            If count >= 1 Then
                TabControl1.Items.Add(New TabItem)
                CType(TabControl1.Items(count), TabItem).Content = New ListBox
            End If

            CType(CType(TabControl1.Items(count), TabItem).Content, ListBox).FontSize = 16
            CType(TabControl1.Items(count), TabItem).Header = Kernel.DataGroupArray(count).Name

            For count2 As Integer = 0 To Kernel.DataGroupArray(count).DataItemArray.GetLength(0) - 1
                CType(CType(TabControl1.Items(count), TabItem).Content, ListBox).Items.Add(New CheckBox)
                AddHandler CType(CType(CType(TabControl1.Items(count), TabItem).Content, ListBox).Items(count2), CheckBox).Checked, AddressOf CheckBox_Checked
                num += 1
            Next
        Next

        For count As Integer = 0 To Kernel.DataGroupArray.GetLength(0) - 1
            For count2 As Integer = 0 To CType(CType(TabControl1.Items(count), TabItem).Content, ListBox).Items.Count - 1
                If Kernel.DataGroupArray(count).DataItemArray(count2).Type = "RealData" Then
                    CType(CType(CType(TabControl1.Items(count), TabItem).Content, ListBox).Items(count2), CheckBox).Content = Kernel.RealDataArray(Kernel.DataGroupArray(count).DataItemArray(count2).TagIndex).Name + " [" + Kernel.RealDataArray(Kernel.DataGroupArray(count).DataItemArray(count2).TagIndex).Tag + "]"
                ElseIf Kernel.DataGroupArray(count).DataItemArray(count2).Type = "BitGet" Then
                    CType(CType(CType(TabControl1.Items(count), TabItem).Content, ListBox).Items(count2), CheckBox).Content = Kernel.DeviceArray(Kernel.DataGroupArray(count).DataItemArray(count2).DeviceIndex).SixteenBitsGetArray(Kernel.DataGroupArray(count).DataItemArray(count2).TagIndex).BitGetArray(Kernel.DataGroupArray(count).DataItemArray(count2).TagIndex2).Name _
                        + " [" + Kernel.DeviceArray(Kernel.DataGroupArray(count).DataItemArray(count2).DeviceIndex).SixteenBitsGetArray(Kernel.DataGroupArray(count).DataItemArray(count2).TagIndex).BitGetArray(Kernel.DataGroupArray(count).DataItemArray(count2).TagIndex2).Tag + "]"
                End If
            Next
        Next
    End Sub

    Private Sub btnHide_Click(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs)
        For i As Integer = 0 To List1.Items.Count - 1
            CType(List1.Items.Item(i), CheckBox).IsChecked = False
        Next

        Me.Hide()
    End Sub

    Private Sub ShowGraph_Click(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs)
        Dim TrendGraph() As TrendGraph = New TrendGraph(MAX_GRAPH_COUNT) {}
        Dim CheckedItemCountArray(Kernel.DataGroupArray.GetLength(0) - 1) As Integer
        Dim ColorArray() As Color = New Color(9) {Color.Red, Color.LightGreen, Color.Magenta, Color.Cyan, Color.Orange, Color.Pink, Color.Blue, Color.LightGray, Color.Brown, Color.White}
        Dim numtotal As Integer = 0
        Dim num As Integer = 0

        For count As Integer = 0 To TabControl1.Items.Count - 1
            For count2 As Integer = 0 To CType(CType(TabControl1.Items(count), TabItem).Content, ListBox).Items.Count - 1
                If CType(CType(CType(TabControl1.Items(count), TabItem).Content, ListBox).Items(count2), CheckBox).IsChecked Then
                    DataItemIndexArray(count, num) = count2
                    numtotal += 1
                    num += 1
                End If
            Next

            CheckedItemCountArray(count) = num
            num = 0
        Next

        Dim ColorArraySet(numtotal - 1) As Color

        Array.Copy(ColorArray, ColorArraySet, numtotal)

        Try
            Dim result As Integer = 0
            Dim position As Integer

            For i As Integer = 0 To MAX_GRAPH_COUNT - 1
                If TrendGraph(i) Is Nothing Then
                    position = i
                    result = 1
                    Exit For
                End If
            Next

            If result = 1 Then
                TrendGraph(position) = New TrendGraph(position, "グラフ", Kernel, DataItemIndexArray, CheckedItemCountArray, ColorArraySet, _
                                    CBool(LogScale.IsChecked), _
                                    Convert.ToDouble(Min.Text), _
                                    Convert.ToDouble(Max.Text), _
                                    (Convert.ToInt32(Minute.Text)) * 60 * 1000, _
                                    Convert.ToDouble(Resolution.Text), _
                                    Convert.ToInt16(Cycle.Text))

                For count As Integer = 0 To Kernel.DataGroupArray.GetLength(0) - 1
                    For count2 As Integer = 0 To CType(CType(TabControl1.Items(count), TabItem).Content, ListBox).Items.Count - 1
                        CType(CType(CType(TabControl1.Items(count), TabItem).Content, ListBox).Items(count2), CheckBox).IsChecked = False
                    Next
                Next

                For count As Integer = 0 To DataItemIndexArray.GetLength(0) - 1
                    For count2 As Integer = 0 To DataItemIndexArray.GetLength(1) - 1
                        DataItemIndexArray(count, count2) = 0
                    Next
                Next

                TrendGraph(position).Show()
            Else
                System.Windows.MessageBox.Show(MAX_GRAPH_COUNT.ToString + "個までしかグラフを開けられません")
            End If
        Catch FormatException As FormatException
            System.Windows.MessageBox.Show("入力値エラー(FormatException)")
        End Try
    End Sub

    Private Sub Window4_Loaded(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles Me.Loaded
        Dim windowHandle As IntPtr = (New WindowInteropHelper(Me)).Handle

        Call RemoveMenu(GetSystemMenu(windowHandle, False), SC_CLOSE, MF_BYCOMMAND)
        Call DrawMenuBar(windowHandle)
    End Sub

    Private Sub CheckBox_Checked(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs)
        Dim num As Integer = 0


        For count As Integer = 0 To TabControl1.Items.Count - 1
            For count2 As Integer = 0 To CType(CType(TabControl1.Items(count), TabItem).Content, ListBox).Items.Count - 1
                If CType(CType(CType(TabControl1.Items(count), TabItem).Content, ListBox).Items(count2), CheckBox).IsChecked Then
                    If num + 1 > 10 Then
                        CType(sender, CheckBox).IsChecked = False
                        System.Windows.MessageBox.Show("10個までしか選択できません")
                    Else
                        num += 1
                    End If
                End If
            Next
        Next
    End Sub

    Private Sub Window_SizeChanged(ByVal sender As Object, ByVal e As System.Windows.SizeChangedEventArgs)
        Dim AdjustScale As System.Windows.Media.ScaleTransform = New System.Windows.Media.ScaleTransform()

        AdjustScale.ScaleX = (Me.Width - 20) / (OriginalWidth - 20)
        AdjustScale.ScaleY = (Me.Height - 40) / (OriginalHeight - 40)

        Me.Height = AdjustScale.ScaleX * OriginalHeight

        CV.RenderTransform = AdjustScale
    End Sub

    Private Sub Window_Activated(sender As Object, e As System.EventArgs) Handles MyBase.Activated
        If InitializedFlag = 0 Then
            Init()
            InitializedFlag = 1
        End If
    End Sub
End Class
