﻿Option Explicit On
'Option Strict On
Option Infer Off

Imports System.Windows.Interop
Imports System.Runtime.InteropServices

Public Class SelectData
    Dim Kernel As Kernel

    Dim OriginalWidth As Double
    Dim OriginalHeight As Double

    Private Const MF_BYCOMMAND As Integer = &H0&
    Private Const SC_CLOSE As Integer = &HF060&

    Dim AllItemArray As New ArrayList
    Dim SelectedIndexArray As New ArrayList

    <DllImport("User32")> _
    Public Shared Function RemoveMenu(ByVal hMenu As IntPtr, ByVal uPosition As UInteger, ByVal uFlags As UInteger) As Boolean
    End Function

    <DllImport("User32")> _
    Public Shared Function GetSystemMenu(ByVal hWnd As IntPtr, ByVal bRevert As Boolean) As IntPtr
    End Function

    <DllImport("User32")> _
    Public Shared Function DrawMenuBar(ByVal hWnd As IntPtr) As Long
    End Function

    Private Sub AddMsg(ByVal msg As String, ByVal flag As Boolean)
        Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + msg, True)
    End Sub

    Public Sub New(ByVal Kernel As Kernel)
        MyBase.New()
        Me.Kernel = Kernel

        InitializeComponent()
        Init()
    End Sub

    Public Sub New()
        MyBase.New()

        InitializeComponent()
        Init()
    End Sub

    Private Sub Init()
        OriginalWidth = Me.Width
        OriginalHeight = Me.Height

        Me.MinWidth = OriginalWidth / 2
        Me.MinHeight = OriginalHeight / 2
    End Sub

    Private Sub HideWindow_Click(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles HideWindow.Click
        Me.Hide()
    End Sub

    Private Sub Delete_Click(sender As System.Object, e As System.Windows.RoutedEventArgs) Handles Delete.Click
        For count As Integer = 0 To GroupDataSelect.SelectedItems.Count - 1
            SelectedIndexArray.Remove(AllItemArray.IndexOf(GroupDataSelect.SelectedItems(count)))
        Next

        SelectedIndexArray.Sort()

        GroupDataAll.SelectedIndex = -1

        GroupDataSelect.Items.Clear()

        For count2 As Integer = 0 To SelectedIndexArray.Count - 1
            GroupDataSelect.Items.Add(AllItemArray(SelectedIndexArray.Item(count2)))
        Next
    End Sub

    Private Sub SelectData_Loaded(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs)
        'TODO: ここにイベント ハンドラーのコードを追加します。
        Dim windowHandle As IntPtr = (New WindowInteropHelper(Me)).Handle

        Call RemoveMenu(GetSystemMenu(windowHandle, False), SC_CLOSE, MF_BYCOMMAND)
        Call DrawMenuBar(windowHandle)

        ComboBox1.SelectedIndex = 0
    End Sub

    Private Sub GroupChanged(GroupId As Integer)
        GroupDataAll.Items.Clear()
        GroupDataSelect.Items.Clear()

        AllItemArray.Clear()
        SelectedIndexArray.Clear()

        For count As Integer = 0 To Kernel.DataGroupArray(GroupId).DataItemArray.Count - 1
            If Kernel.DataGroupArray(GroupId).DataItemArray(count).Type = "RealData" Then
                AllItemArray.Add(Kernel.RealDataArray(Kernel.DataGroupArray(GroupId).DataItemArray(count).TagIndex).Name)
            ElseIf Kernel.DataGroupArray(GroupId).DataItemArray(count).Type = "BitGet" Then
                AllItemArray.Add(Kernel.DeviceArray(Kernel.DataGroupArray(GroupId).DataItemArray(count).DeviceIndex).SixteenBitsGetArray(Kernel.DataGroupArray(GroupId).DataItemArray(count).TagIndex).BitGetArray(Kernel.DataGroupArray(GroupId).DataItemArray(count).TagIndex2).Name)
            End If
            GroupDataAll.Items.Add(AllItemArray.Item(count))
        Next

        GroupDataAll.ScrollIntoView(AllItemArray.Item(0))

        'For count As Integer = 0 To Kernel.DataGroupArray(GroupId).DataItemArray.Count - 1
        '    GroupDataAll.Items.Add(AllItemArray.Item(count))
        'Next
    End Sub

    Private Sub SelectData_SizeChanged(ByVal sender As Object, ByVal e As System.Windows.SizeChangedEventArgs)
        'TODO: ここにイベント ハンドラーのコードを追加します。
        Dim AdjustScale As System.Windows.Media.ScaleTransform = New System.Windows.Media.ScaleTransform()

        AdjustScale.ScaleX = (Me.Width - 20) / (OriginalWidth - 20)
        AdjustScale.ScaleY = (Me.Height - 40) / (OriginalHeight - 40)

        Me.Height = AdjustScale.ScaleX * OriginalHeight

        CV.RenderTransform = AdjustScale
    End Sub

    Private Sub Add_Click(sender As System.Object, e As System.Windows.RoutedEventArgs) Handles Add.Click
        For count As Integer = 0 To GroupDataAll.SelectedItems.Count - 1
            If SelectedIndexArray.IndexOf(AllItemArray.IndexOf(GroupDataAll.SelectedItems(count))) = -1 Then
                SelectedIndexArray.Add(AllItemArray.IndexOf(GroupDataAll.SelectedItems(count)))
            End If
        Next

        SelectedIndexArray.Sort()

        GroupDataAll.SelectedIndex = -1

        GroupDataSelect.Items.Clear()

        For count2 As Integer = 0 To SelectedIndexArray.Count - 1
            GroupDataSelect.Items.Add(AllItemArray(SelectedIndexArray.Item(count2)))
        Next
    End Sub

    Private Sub Confirm_Click(sender As System.Object, e As System.Windows.RoutedEventArgs) Handles Confirm.Click
        Dim FromDate As Date
        Dim ToDate As Date
        Dim IntervalSec As Long
        Dim FileNameArray() As String
        Dim dt As Date
        Dim lv As Long

        If Not Date.TryParse(FromDateInput.Text, dt) Then
            MessageBox.Show("開始日フォーマットエラー")
            Exit Sub
        ElseIf Not Date.TryParse(FromTimeInput.Text, dt) Then
            MessageBox.Show("開始時刻フォーマットエラー")
            Exit Sub
        ElseIf Not Date.TryParse(ToDateInput.Text, dt) Then
            MessageBox.Show("終了日フォーマットエラー")
            Exit Sub
        ElseIf Not Date.TryParse(ToTimeInput.Text, dt) Then
            MessageBox.Show("終了時刻フォーマットエラー")
            Exit Sub
        End If

        If Not Long.TryParse(IntervalInput.Text, lv) Then
            MessageBox.Show("取得時間間隔フォーマットエラー")
            Exit Sub
        Else
            Long.TryParse(IntervalInput.Text, lv)
            If lv < 1 Or lv > 999 Then
                MessageBox.Show("取得時間間隔 範囲エラー(0<value<999)")
            End If
        End If

        FromDate = Date.Parse(FromDateInput.Text + " " + FromTimeInput.Text)
        ToDate = Date.Parse(ToDateInput.Text + " " + ToTimeInput.Text)

        If SelectSecond.IsChecked Then
            IntervalSec = lv
        ElseIf SelectMinute.IsChecked Then
            IntervalSec = lv * 60
        ElseIf SelectHour.IsChecked Then
            IntervalSec = lv * 60 * 60
        ElseIf SelectDay.IsChecked Then
            IntervalSec = lv * 24 * 60 * 60
        End If

        Dim FromFileDate As Date = Date.Parse(FromDateInput.Text)
        Dim ToFileDate As Date = Date.Parse(ToDateInput.Text + " " + ToTimeInput.Text).Date.AddMilliseconds(Kernel.ArchiveCycleMilliSecond)
        Dim DurationDay As Long = (ToFileDate.Ticks - FromFileDate.Ticks) / 10000000 / (24 * 60 * 60)

        ReDim FileNameArray(DurationDay)

        For count As Integer = 0 To DurationDay
            'FileNameArray(count) = "File" + (ComboBox1.SelectedIndex + 1).ToString("0") + "_PlantInterface_" + FromFileDate.AddDays(count).ToString("yyyyMMdd") + ".csv"
            FileNameArray(count) = "File" + (ComboBox1.SelectedIndex + 1).ToString("0") + "_PlantServer_" + FromFileDate.AddDays(count).ToString("yyyyMMdd") + ".csv"
            'FileNameArray(count) = "File" + (ComboBox1.SelectedIndex + 1).ToString("0") + "_PlantTerm_" + FromFileDate.AddDays(count).ToString("yyyyMMdd") + ".csv"
        Next


        Dim DataView As DataView = New DataView(Kernel, FromDate, ToDate, IntervalSec, ComboBox1.SelectedIndex, SelectedIndexArray, FileNameArray)
        DataView.Show()
    End Sub

    Private Sub ComboBox1_SelectionChanged(sender As System.Object, e As System.Windows.Controls.SelectionChangedEventArgs) Handles ComboBox1.SelectionChanged
        GroupChanged(ComboBox1.SelectedIndex)
    End Sub
End Class