﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Windows.Interop
Imports System.Runtime.InteropServices

Public Class SHMITwindow
    Dim Kernel As Kernel

    Dim OriginalWidth As Double
    Dim OriginalHeight As Double

    Private Const MF_BYCOMMAND As Integer = &H0&
    Private Const SC_CLOSE As Integer = &HF060&

    <DllImport("User32")> _
    Public Shared Function RemoveMenu(ByVal hMenu As IntPtr, ByVal uPosition As UInteger, ByVal uFlags As UInteger) As Boolean
    End Function

    <DllImport("User32")> _
    Public Shared Function GetSystemMenu(ByVal hWnd As IntPtr, ByVal bRevert As Boolean) As IntPtr
    End Function

    <DllImport("User32")> _
    Public Shared Function DrawMenuBar(ByVal hWnd As IntPtr) As Long
    End Function

    Private Sub AddMsg(ByVal msg As String, ByVal flag As Boolean)
        Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + msg, True)
    End Sub

    Public Sub New(ByVal kernel As Kernel)
        MyBase.New()

        Me.Kernel = kernel
        InitializeComponent()
        Init()
    End Sub

    Public Sub New()
        MyBase.New()

        InitializeComponent()
        Init()
    End Sub

    Private Sub Init()
        OriginalWidth = Me.Width
        OriginalHeight = Me.Height

        Me.MinWidth = OriginalWidth / 2
        Me.MinHeight = OriginalHeight / 2
    End Sub

    Private Sub Window_Loaded(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles HideWindow.Loaded
        Dim windowHandle As IntPtr = (New WindowInteropHelper(Me)).Handle

        Call RemoveMenu(GetSystemMenu(windowHandle, False), SC_CLOSE, MF_BYCOMMAND)
        Call DrawMenuBar(windowHandle)
    End Sub

    Private Sub Window_SizeChanged(ByVal sender As System.Object, ByVal e As System.Windows.SizeChangedEventArgs) Handles HideWindow.SizeChanged
        Dim AdjustScale As System.Windows.Media.ScaleTransform = New System.Windows.Media.ScaleTransform()

        AdjustScale.ScaleX = (Me.Width - 20) / (OriginalWidth - 20)
        AdjustScale.ScaleY = (Me.Height - 40) / (OriginalHeight - 40)

        Me.Height = AdjustScale.ScaleX * OriginalHeight

        CV.RenderTransform = AdjustScale
    End Sub

    Private Sub HideWindow_Click(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles HideWindow.Click
        Me.Hide()
    End Sub
End Class