﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Windows
Imports System

Partial Public Class TwoButtons_SetBit
    Dim TitleBar As String
    Dim Msg As String
    Dim BtnLabel1 As String
    Dim BtnLabel2 As String
    Dim DeviceName As String
    Dim Target As String = Nothing
    Dim TargetArray(1) As String
    Dim Kernel As Kernel
    Dim DblCheckFlag As Boolean
    Dim Type As String
    Dim Mode As String

    Private Sub AddMsg(ByVal msg As String, ByVal flag As Boolean)
        Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + msg, True)
    End Sub

    Sub Init(ByVal Kernel As Kernel, ByVal TitleBar As String, ByVal Msg As String, ByVal BtnLabel1 As String, ByVal BtnLabel2 As String, ByVal DblCheckFlag As Boolean)
        ' InitializeComponent() 呼び出しの後で初期化を追加します。
        Me.Kernel = Kernel
        Me.Title = TitleBar
        Me.Msg = Msg
        Label1.Content = Msg

        Me.BtnLabel1 = BtnLabel1
        Button1.Content = BtnLabel1

        Me.BtnLabel2 = BtnLabel2
        Button2.Content = BtnLabel2

        Me.DblCheckFlag = DblCheckFlag
    End Sub


    Sub New(ByVal Kernel As Kernel, ByVal TitleBar As String, ByVal Msg As String, ByVal BtnLabel1 As String, ByVal BtnLabel2 As String, ByVal DeviceName As String, ByVal Target As String, ByVal DblCheckFlag As Boolean)

        ' この呼び出しは、Windows フォーム デザイナで必要です。
        InitializeComponent()

        Init(Kernel, TitleBar, Msg, BtnLabel1, BtnLabel2, DblCheckFlag)
        Me.DeviceName = DeviceName
        Me.Target = Target
        Me.Type = "Set"
        Mode = "SwitchByOneID"
    End Sub

    Sub New(ByVal Kernel As Kernel, ByVal TitleBar As String, ByVal Msg As String, ByVal BtnLabel1 As String, ByVal BtnLabel2 As String, ByVal DeviceName As String, ByVal TargetArray() As String, ByVal DblCheckFlag As Boolean)

        ' この呼び出しは、Windows フォーム デザイナで必要です。
        InitializeComponent()

        Init(Kernel, TitleBar, Msg, BtnLabel1, BtnLabel2, DblCheckFlag)

        Me.DeviceName = DeviceName
        System.Array.Copy(TargetArray, Me.TargetArray, 2)
        Me.Type = "Set"
        Mode = "SwitchByTwoID"
    End Sub

    'Sub New(ByVal Kernel As Kernel, ByVal TitleBar As String, ByVal Msg As String, ByVal BtnLabel1 As String, ByVal BtnLabel2 As String, ByVal DeviceName As String, ByVal Target As String, ByVal Type As String, ByVal DblCheckFlag As Boolean)

    '    ' この呼び出しは、Windows フォーム デザイナで必要です。
    '    InitializeComponent()

    '    Init(Kernel, TitleBar, Msg, BtnLabel1, BtnLabel2, DblCheckFlag)
    '    Me.DeviceName = DeviceName
    '    Me.Target = Target
    '    Me.Type = Type
    '    Mode = "SwitchByOneID"
    'End Sub

    Sub New(ByVal Kernel As Kernel, ByVal TitleBar As String, ByVal Msg As String, ByVal BtnLabel1 As String, ByVal BtnLabel2 As String, ByVal DeviceName As String, ByVal TargetArray() As String, ByVal Type As String, ByVal DblCheckFlag As Boolean)

        ' この呼び出しは、Windows フォーム デザイナで必要です。
        InitializeComponent()

        Init(Kernel, TitleBar, Msg, BtnLabel1, BtnLabel2, DblCheckFlag)

        Me.DeviceName = DeviceName
        System.Array.Copy(TargetArray, Me.TargetArray, 2)
        Me.Type = Type
        Mode = "SwitchByTwoID"
    End Sub



    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs) Handles Button1.Click
        If Mode = "SwitchByOneID" Then
            If DblCheckFlag Then
                Dim YesNo As YesNo_SetBit = New YesNo_SetBit(Kernel, Title, "[" + Msg + "]を[" + BtnLabel1 + "]しますか？", DeviceName, Target, "Set")
                YesNo.Show()
            Else
                Kernel.SearchDevice(DeviceName).SetBit(New String() {Target}, 1, True)
            End If
        ElseIf Mode = "SwitchByTwoID" Then
            If DblCheckFlag Then
                Dim YesNo As YesNo_SetBit = New YesNo_SetBit(Kernel, Title, "[" + Msg + "]を[" + BtnLabel1 + "]しますか？", DeviceName, TargetArray(0), Type)
                YesNo.Show()
            Else
                If Type = "Set" Then
                    Kernel.SearchDevice(DeviceName).SetBit(New String() {TargetArray(0)}, 1, True)
                ElseIf Type = "Reset" Then
                    Kernel.SearchDevice(DeviceName).SetBit(New String() {TargetArray(0)}, 0, True)
                ElseIf Type = "SetReset" Then
                    Kernel.SearchDevice(DeviceName).SetBit(New String() {TargetArray(0)}, 1, True)
                    Kernel.SearchDevice(DeviceName).SetBit(New String() {TargetArray(0)}, 0, True)
                ElseIf Type = "ResetSet" Then
                    Kernel.SearchDevice(DeviceName).SetBit(New String() {TargetArray(0)}, 0, True)
                    Kernel.SearchDevice(DeviceName).SetBit(New String() {TargetArray(0)}, 1, True)
                End If
            End If
        End If

        Me.Close()
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs) Handles Button2.Click
        If Mode = "SwitchByOneID" Then
            If DblCheckFlag Then
                Dim YesNo As YesNo_SetBit = New YesNo_SetBit(Kernel, Title, "[" + Msg + "]を[" + BtnLabel1 + "]しますか？", DeviceName, Target, "Reset")
                YesNo.Show()
            Else
                Kernel.SearchDevice(DeviceName).SetBit(New String() {Target}, 0, True)

            End If
        ElseIf Mode = "SwitchByTwoID" Then
            If DblCheckFlag Then
                Dim YesNo As YesNo_SetBit = New YesNo_SetBit(Kernel, Title, "[" + Msg + "]を[" + BtnLabel1 + "]しますか？", DeviceName, TargetArray(1), Type)
                YesNo.Show()
            Else
                If Type = "Set" Then
                    Kernel.SearchDevice(DeviceName).SetBit(New String() {TargetArray(1)}, 1, True)
                ElseIf Type = "Reset" Then
                    Kernel.SearchDevice(DeviceName).SetBit(New String() {TargetArray(1)}, 0, True)
                ElseIf Type = "SetReset" Then
                    Kernel.SearchDevice(DeviceName).SetBit(New String() {TargetArray(1)}, 1, True)
                    Kernel.SearchDevice(DeviceName).SetBit(New String() {TargetArray(1)}, 0, True)
                ElseIf Type = "ResetSet" Then
                    Kernel.SearchDevice(DeviceName).SetBit(New String() {TargetArray(1)}, 0, True)
                    Kernel.SearchDevice(DeviceName).SetBit(New String() {TargetArray(1)}, 1, True)
                End If
            End If
        End If

        Me.Close()
    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs) Handles Button4.Click
        Me.Close()
    End Sub

End Class
