﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System.Threading

''' <summary>
''' Event Manager
''' </summary>
''' <remarks></remarks>
Public Class EventManager
    Dim kernel As Kernel

    'Dim TicksCurrentCount As Integer = 0 ' For current time display

    Public DataAcquisitionInst As DataAcquisition
    Delegate Sub delDataAcquisition()  ' Deligate for DataAcquisition event
    Public Event evtDataAcquisition As delDataAcquisition 'DataAcquisition event
    Dim DataAcquisitionCurrentCount As Integer
    Dim DataAcquisitionEventCount As Integer

    Public ArchiveInst As Archive
    Delegate Sub delArchive()  ' Deligate for Archive event
    Public Event evtArchive As delArchive 'Archive event
    Dim ArchiveCurrentCount As Integer
    Dim ArchiveEventCount As Integer
    Delegate Sub delMailReminder()  ' Delegate for MailReminder event
    Public Event evtMailReminder As delMailReminder 'MailReminder event
    Public MailReminderCurrentCount As Integer = 0
    Public MailReminderEventCount As Integer = 0

    Sub New(ByVal kernel As Kernel)
        Me.kernel = kernel
        AddHandler kernel.evtTicks, AddressOf TicksHandler     'Register Archive event handleracquisitioninst..

        DataAcquisitionEventCount = Convert.ToInt32(kernel.AcquisitionCycleMilliSecond / kernel.TicksMilliSecond)
        DataAcquisitionCurrentCount = DataAcquisitionEventCount
        If kernel.AcquisitionAsyncFlag Then
            'DataAcquisitionInst = CType(System.Activator.CreateInstance(Type.GetType(Me.GetType.Namespace.ToString() + ".DataAcquisitionAsync"), New Object() {Me, kernel}), DataAcquisitionAsync)
            DataAcquisitionInst = New DataAcquisitionAsync(Me, kernel)
        Else
            'DataAcquisitionInst = CType(System.Activator.CreateInstance(Type.GetType(Me.GetType.Namespace.ToString() + ".DataAcquisitionSync"), New Object() {Me, kernel}), DataAcquisitionSync)
            DataAcquisitionInst = New DataAcquisitionSync(Me, kernel)
        End If

        ArchiveEventCount = Convert.ToInt32(kernel.ArchiveCycleMilliSecond / kernel.TicksMilliSecond)
        ArchiveCurrentCount = ArchiveEventCount
        ArchiveInst = New Archive(Me, kernel)

        If kernel.MailDestinationArray IsNot Nothing Then
            MailReminderEventCount = Convert.ToInt32(kernel.MailDestinationArray(0).ReminderIntervalSec * 1000 / kernel.TicksMilliSecond)
        End If
    End Sub

    Sub TicksHandler()
        'TicksCurrentCount += 1
        'If kernel.TicksMilliSecond * TicksCurrentCount >= 500 Then
        '    kernel.ChangeText(DirectCast(kernel.WindowHashTable("MainWindow"), MainWindow).CurrentDateTime, System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss"))
        '    TicksCurrentCount = 0
        'Else
        'End If

        If DataAcquisitionCurrentCount > 0 Then
            DataAcquisitionCurrentCount -= 1
            If DataAcquisitionCurrentCount = 0 Then
                Dim trd As Thread = New Thread(AddressOf DataAcquisition)
                trd.IsBackground = True
                trd.Start()
                DataAcquisitionCurrentCount = DataAcquisitionEventCount
            End If
        End If

        If Not kernel.AcquisitionAsyncFlag Then         ' Incase of Sync (Not Async)
            If ArchiveCurrentCount > 0 Then
                ArchiveCurrentCount -= 1
                If ArchiveCurrentCount = 0 Then
                    Dim trd As Thread = New Thread(AddressOf Archive)
                    trd.IsBackground = True
                    trd.Start()
                    ArchiveCurrentCount = ArchiveEventCount
                End If
            End If
        End If

        If MailReminderCurrentCount > 0 Then
            MailReminderCurrentCount -= 1
            If MailReminderCurrentCount = 0 Then
                RaiseEvent evtMailReminder()
            End If
        End If
    End Sub

    Sub DataAcquisition()
        RaiseEvent evtDataAcquisition()
    End Sub

    Sub Archive()
        RaiseEvent evtArchive()
    End Sub
End Class