﻿Option Explicit On
Option Strict On
Option Infer Off

Imports System
Imports System.Windows
Imports System.Threading
Imports System.IO
Imports System.Text

''' <summary>
''' Archive
''' </summary>
''' <remarks></remarks>
Public Class Archive
    Private DataLogFolderArray() As String
    Private DirectoryNotFoundFlag As Boolean()
    Private Kernel As Kernel

    ''' <summary>
    ''' Constructor
    ''' </summary>
    ''' <param name="em"></param>
    ''' <param name="Kernel"></param>
    ''' <remarks></remarks>
    Sub New(ByVal em As EventManager, ByVal Kernel As Kernel)
        Me.Kernel = Kernel

        AddHandler em.evtArchive, AddressOf Archive     'Register Archive event handler

        Me.DataLogFolderArray = Kernel.DataLogFolderArray
        DirectoryNotFoundFlag = New Boolean(DataLogFolderArray.GetLength(0) - 1) {}
    End Sub

    ''' <summary>
    ''' Save data into logfile
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub Archive()
        Dim fs As FileStream = Nothing
        Dim sw As StreamWriter = Nothing
        Dim data As String
        Dim FileName As String

        For DataLogFolderArrayCount As Integer = 0 To DataLogFolderArray.GetLength(0) - 1
            Try
                If Kernel.LogSettingType = 2 Then 'DataGroup
                    For count As Integer = 0 To Kernel.DataGroupArray.Count - 1
                        ' file name
                        FileName = System.IO.Path.Combine(DataLogFolderArray(DataLogFolderArrayCount), Kernel.DataGroupArray(count).Name + "_" + System.DateTime.Now.ToString("yyyyMMdd") + ".csv")

                        ' In case file doesn't exist. create file and write title
                        If Not System.IO.File.Exists(FileName) Then
                            fs = New FileStream(FileName, FileMode.Create, FileAccess.Write, FileShare.ReadWrite)
                            sw = New StreamWriter(fs, Encoding.GetEncoding("Shift_JIS"))

                            data = "Time,"

                            For count2 As Integer = 0 To Kernel.DataGroupArray(count).DataItemArray.Count - 2
                                If Kernel.DataGroupArray(count).DataItemArray(count2).TypeIndex = 0 Then
                                    data = data + Kernel.DeviceArray(Kernel.DataGroupArray(count).DataItemArray(count2).DeviceIndex).WordGetArray(Kernel.DataGroupArray(count).DataItemArray(count2).TagIndex).Name + ","
                                ElseIf Kernel.DataGroupArray(count).DataItemArray(count2).TypeIndex = 1 Then
                                    data = data + Kernel.DeviceArray(Kernel.DataGroupArray(count).DataItemArray(count2).DeviceIndex).SixteenBitsGetArray(Kernel.DataGroupArray(count).DataItemArray(count2).TagIndex).BitGetArray(Kernel.DataGroupArray(count).DataItemArray(count2).TagIndex2).Name + ","
                                ElseIf Kernel.DataGroupArray(count).DataItemArray(count2).TypeIndex = 2 Then
                                    data = data + Kernel.RealDataArray(Kernel.DataGroupArray(count).DataItemArray(count2).TagIndex).Name + ","
                                ElseIf Kernel.DataGroupArray(count).DataItemArray(count2).TypeIndex = 3 Then
                                    data = data + Kernel.LogicalItemArray(Kernel.DataGroupArray(count).DataItemArray(count2).TagIndex).Name + ","
                                End If
                            Next

                            If Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).TypeIndex = 0 Then
                                data = data + Kernel.DeviceArray(Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).DeviceIndex).WordGetArray(Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).TagIndex).Name + ","
                            ElseIf Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).TypeIndex = 1 Then
                                data = data + Kernel.DeviceArray(Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).DeviceIndex).SixteenBitsGetArray(Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).TagIndex).BitGetArray(Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).TagIndex2).Name + ","
                            ElseIf Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).TypeIndex = 2 Then
                                data = data + Kernel.RealDataArray(Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).TagIndex).Name + ","
                            ElseIf Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).TypeIndex = 3 Then
                                data = data + Kernel.LogicalItemArray(Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).TagIndex).Name + ","
                            End If

                            sw.WriteLine(data)
                        Else
                            fs = New FileStream(FileName, FileMode.Append, FileAccess.Write, FileShare.ReadWrite)
                            sw = New StreamWriter(fs, Encoding.GetEncoding("Shift_JIS"))
                        End If

                        ' make write data
                        data = System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + ","     ' Date & Time

                        For count2 As Integer = 0 To Kernel.DataGroupArray(count).DataItemArray.Count - 2
                            If Kernel.DataGroupArray(count).DataItemArray(count2).TypeIndex = 0 Then
                                data = data + Kernel.DeviceArray(Kernel.DataGroupArray(count).DataItemArray(count2).DeviceIndex).WordGetArray(Kernel.DataGroupArray(count).DataItemArray(count2).TagIndex).Value.ToString + ","
                            ElseIf Kernel.DataGroupArray(count).DataItemArray(count2).TypeIndex = 1 Then
                                data = data + Kernel.DeviceArray(Kernel.DataGroupArray(count).DataItemArray(count2).DeviceIndex).SixteenBitsGetArray(Kernel.DataGroupArray(count).DataItemArray(count2).TagIndex).BitGetArray(Kernel.DataGroupArray(count).DataItemArray(count2).TagIndex2).Value.ToString + ","
                            ElseIf Kernel.DataGroupArray(count).DataItemArray(count2).TypeIndex = 2 Then    ' In case of RealData
                                data = data + Kernel.RealDataArray(Kernel.DataGroupArray(count).DataItemArray(count2).TagIndex).CalData.ToString("0.000E00") + ","
                            ElseIf Kernel.DataGroupArray(count).DataItemArray(count2).TypeIndex = 3 Then    ' In case of LogicalItem
                                data = data + Kernel.LogicalItemArray(Kernel.DataGroupArray(count).DataItemArray(count2).TagIndex).GetStatus() + ","
                            End If
                        Next


                        If Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).TypeIndex = 0 Then
                            data = data + Kernel.DeviceArray(Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).DeviceIndex).WordGetArray(Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).TagIndex).Value.ToString + ","
                        ElseIf Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).TypeIndex = 1 Then
                            data = data + Kernel.DeviceArray(Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).DeviceIndex).SixteenBitsGetArray(Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).TagIndex).BitGetArray(Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).TagIndex2).Value.ToString + ","
                        ElseIf Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).TypeIndex = 2 Then    ' In case of RealData
                            data = data + Kernel.RealDataArray(Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).TagIndex).CalData.ToString("0.000E00") + ","
                        ElseIf Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).TypeIndex = 3 Then    ' In case of LogicalItem
                            data = data + Kernel.LogicalItemArray(Kernel.DataGroupArray(count).DataItemArray(Kernel.DataGroupArray(count).DataItemArray.Count - 1).TagIndex).GetStatus() + ","
                        End If

                        sw.WriteLine(data)

                        Try
                            If sw IsNot Nothing Then sw.Close()
                            If fs IsNot Nothing Then fs.Close()
                        Catch
                        End Try
                    Next
                ElseIf Kernel.LogSettingType = 1 Then   ' PhysicalData
                    Dim RealDataArrayCount As Integer = Kernel.RealDataArray.GetLength(0)
                    Dim LogicalItemArrayCount As Integer = Kernel.LogicalItemArray.GetLength(0)

                    If RealDataArrayCount > 0 Or LogicalItemArrayCount > 0 Then
                        FileName = System.IO.Path.Combine(DataLogFolderArray(DataLogFolderArrayCount), "LOG" + System.DateTime.Now.ToString("yyyyMMdd") + ".csv")

                        If Not System.IO.File.Exists(FileName) Then
                            fs = New FileStream(FileName, FileMode.Create, FileAccess.Write, FileShare.ReadWrite)
                            sw = New StreamWriter(fs, Encoding.GetEncoding("Shift_JIS"))

                            data = "Time,"
                            If RealDataArrayCount > 0 Then
                                For RealDataArrayIndex As Integer = 0 To Kernel.RealDataArray.GetLength(0) - 1
                                    data = data + Kernel.RealDataArray(RealDataArrayIndex).Name + ","
                                Next
                            End If

                            If LogicalItemArrayCount > 0 Then
                                For LogicalItemArrayIndex As Integer = 0 To Kernel.LogicalItemArray.GetLength(0) - 2
                                    data = data + Kernel.LogicalItemArray(LogicalItemArrayIndex).Name + ","
                                Next
                                data = data + Kernel.LogicalItemArray(Kernel.LogicalItemArray.GetLength(0) - 1).Name
                            End If

                            sw.WriteLine(data)
                        Else
                            fs = New FileStream(FileName, FileMode.Append, FileAccess.Write, FileShare.ReadWrite)
                            sw = New StreamWriter(fs, Encoding.GetEncoding("Shift_JIS"))

                        End If

                        ' make write data
                        data = System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + ","     ' Date & Time

                        If RealDataArrayCount > 0 Then
                            For RealDataArrayIndex As Integer = 0 To Kernel.RealDataArray.GetLength(0) - 1
                                data = data + Kernel.RealDataArray(RealDataArrayIndex).CalData.ToString("0.000E00") + ","
                            Next
                        End If

                        If LogicalItemArrayCount > 0 Then
                            For LogicalItemArrayIndex As Integer = 0 To Kernel.LogicalItemArray.GetLength(0) - 2
                                data = data + Kernel.LogicalItemArray(LogicalItemArrayIndex).GetStatus() + ","
                            Next
                            data = data + Kernel.LogicalItemArray(Kernel.LogicalItemArray.GetLength(0) - 1).GetStatus()
                        End If

                        sw.WriteLine(data)
                    End If
                ElseIf Kernel.LogSettingType = 0 Then   ' RawData
                    FileName = System.IO.Path.Combine(DataLogFolderArray(DataLogFolderArrayCount), "LOG" + System.DateTime.Now.ToString("yyyyMMdd") + ".csv")

                    If Not System.IO.File.Exists(FileName) Then
                        fs = New FileStream(FileName, FileMode.Create, FileAccess.Write, FileShare.ReadWrite)
                        sw = New StreamWriter(fs, Encoding.GetEncoding("Shift_JIS"))

                        data = "Time,"


                        For DeviceArrayCount As Integer = 0 To Kernel.DeviceArray.GetLength(0) - 1
                            For SixteenBitsGetArrayCount As Integer = 0 To CType(Kernel.DeviceArray(DeviceArrayCount), PLC).SixteenBitsGetArray.GetLength(0) - 1
                                ' In case last BitGet in last SixteenBitGet in last PLC consists only one member
                                If DeviceArrayCount = Kernel.DeviceArray.GetLength(0) - 1 And SixteenBitsGetArrayCount = CType(Kernel.DeviceArray(DeviceArrayCount), PLC).SixteenBitsGetArray.GetLength(0) - 1 _
                                    And CType(Kernel.DeviceArray(DeviceArrayCount), PLC).SixteenBitsGetArray(SixteenBitsGetArrayCount).BitGetArray.GetLength(0) <= 1 Then
                                    Exit For
                                Else
                                    ' In caser last SixteenBitsGet in last PLC
                                    If DeviceArrayCount = Kernel.DeviceArray.GetLength(0) - 1 _
                                        And SixteenBitsGetArrayCount = CType(Kernel.DeviceArray(DeviceArrayCount), PLC).SixteenBitsGetArray.GetLength(0) - 1 Then
                                        For BitGetArrayCount As Integer = 0 To CType(Kernel.DeviceArray(DeviceArrayCount), PLC).SixteenBitsGetArray(SixteenBitsGetArrayCount).BitGetArray.GetLength(0) - 2
                                            data = data + CType(Kernel.DeviceArray(DeviceArrayCount), PLC).SixteenBitsGetArray(SixteenBitsGetArrayCount).BitGetArray(BitGetArrayCount).Name + ","
                                        Next
                                    Else
                                        For BitGetArrayCount As Integer = 0 To CType(Kernel.DeviceArray(DeviceArrayCount), PLC).SixteenBitsGetArray(SixteenBitsGetArrayCount).BitGetArray.GetLength(0) - 1
                                            data = data + CType(Kernel.DeviceArray(DeviceArrayCount), PLC).SixteenBitsGetArray(SixteenBitsGetArrayCount).BitGetArray(BitGetArrayCount).Name + ","
                                        Next
                                    End If
                                End If
                            Next
                        Next


                        If CType(Kernel.DeviceArray(Kernel.DeviceArray.GetLength(0) - 1), PLC).SixteenBitsGetArray.GetLength(0) > 0 Then
                            If CType(Kernel.DeviceArray(Kernel.DeviceArray.GetLength(0) - 1), PLC).SixteenBitsGetArray(CType(Kernel.DeviceArray(Kernel.DeviceArray.GetLength(0) - 1), PLC).SixteenBitsGetArray.GetLength(0) - 1).BitGetArray.GetLength(0) > 0 Then
                                data = data + CType(Kernel.DeviceArray(Kernel.DeviceArray.GetLength(0) - 1), PLC).SixteenBitsGetArray(CType(Kernel.DeviceArray(Kernel.DeviceArray.GetLength(0) - 1), PLC).SixteenBitsGetArray.GetLength(0) - 1).BitGetArray(CType(Kernel.DeviceArray(Kernel.DeviceArray.GetLength(0) - 1), PLC).SixteenBitsGetArray(CType(Kernel.DeviceArray(Kernel.DeviceArray.GetLength(0) - 1), PLC).SixteenBitsGetArray.GetLength(0) - 1).BitGetArray.GetLength(0) - 1).Name
                                sw.WriteLine(data)
                            Else
                                MessageBox.Show("PlcArray(" + (Kernel.DeviceArray.GetLength(0) - 1).ToString() + ").WordGet16BitArray(" + (CType(Kernel.DeviceArray(Kernel.DeviceArray.GetLength(0) - 1), PLC).SixteenBitsGetArray.GetLength(0) - 1).ToString() + ").BitGetArray Undefined")
                            End If
                        Else
                            MessageBox.Show("PlcArray(" + (Kernel.DeviceArray.GetLength(0) - 1).ToString() + ").WordGet16BitArray Undefined")
                        End If
                    Else
                        fs = New FileStream(FileName, FileMode.Append, FileAccess.Write, FileShare.ReadWrite)
                        sw = New StreamWriter(fs, Encoding.GetEncoding("Shift_JIS"))
                    End If

                    ' make write data
                    data = System.DateTime.Now.ToString("yyyy/MM/dd HH:mm:ss") + ","     ' Date & Time


                    For DeviceArrayCount As Integer = 0 To Kernel.DeviceArray.GetLength(0) - 1
                        For SixteenBitsGetArrayCount As Integer = 0 To CType(Kernel.DeviceArray(DeviceArrayCount), PLC).SixteenBitsGetArray.GetLength(0) - 1
                            If DeviceArrayCount = Kernel.DeviceArray.GetLength(0) - 1 _
                                And SixteenBitsGetArrayCount = CType(Kernel.DeviceArray(DeviceArrayCount), PLC).SixteenBitsGetArray.GetLength(0) - 1 _
                                And CType(Kernel.DeviceArray(DeviceArrayCount), PLC).SixteenBitsGetArray(SixteenBitsGetArrayCount).BitGetArray.GetLength(0) <= 1 Then
                                Exit For
                            Else
                                If DeviceArrayCount = Kernel.DeviceArray.GetLength(0) - 1 _
                                    And SixteenBitsGetArrayCount = CType(Kernel.DeviceArray(DeviceArrayCount), PLC).SixteenBitsGetArray.GetLength(0) - 1 Then
                                    For BitGetArrayCount As Integer = 0 To CType(Kernel.DeviceArray(DeviceArrayCount), PLC).SixteenBitsGetArray(SixteenBitsGetArrayCount).BitGetArray.GetLength(0) - 2
                                        data = data + CType(Kernel.DeviceArray(DeviceArrayCount), PLC).SixteenBitsGetArray(SixteenBitsGetArrayCount).BitGetArray(BitGetArrayCount).Value.ToString + ","
                                    Next
                                Else
                                    For count2 As Integer = 0 To CType(Kernel.DeviceArray(DeviceArrayCount), PLC).SixteenBitsGetArray(SixteenBitsGetArrayCount).BitGetArray.GetLength(0) - 1
                                        data = data + CType(Kernel.DeviceArray(DeviceArrayCount), PLC).SixteenBitsGetArray(SixteenBitsGetArrayCount).BitGetArray(count2).Value.ToString + ","
                                    Next
                                End If
                            End If
                        Next
                    Next

                    If CType(Kernel.DeviceArray(Kernel.DeviceArray.GetLength(0) - 1), PLC).SixteenBitsGetArray.GetLength(0) > 0 Then
                        If CType(Kernel.DeviceArray(Kernel.DeviceArray.GetLength(0) - 1), PLC).SixteenBitsGetArray(CType(Kernel.DeviceArray(Kernel.DeviceArray.GetLength(0) - 1), PLC).SixteenBitsGetArray.GetLength(0) - 1).BitGetArray.GetLength(0) > 0 Then
                            sw.WriteLine(data)
                        Else
                            MessageBox.Show("PlcArray(" + (Kernel.DeviceArray.GetLength(0) - 1).ToString() + ").WordGet16BitArray(" + (CType(Kernel.DeviceArray(Kernel.DeviceArray.GetLength(0) - 1), PLC).SixteenBitsGetArray.GetLength(0) - 1).ToString() + ").BitGetArray が定義されていません")
                        End If
                    Else
                        MessageBox.Show("PlcArray(" + (Kernel.DeviceArray.GetLength(0) - 1).ToString() + ").WordGet16BitArray not defined.")
                    End If
                Else

                End If

                Try
                    If sw IsNot Nothing Then sw.Close()
                    If fs IsNot Nothing Then fs.Close()
                Catch
                End Try

                DirectoryNotFoundFlag(DataLogFolderArrayCount) = False
            Catch ex As DirectoryNotFoundException
                If DirectoryNotFoundFlag(DataLogFolderArrayCount) = False Then
                    DirectoryNotFoundFlag(DataLogFolderArrayCount) = True
                    MessageBox.Show("Directory for cyclic data does not exist. (" + DataLogFolderArray(DataLogFolderArrayCount) + ")")
                    DirectoryNotFoundFlag(DataLogFolderArrayCount) = False
                End If
            Catch ex As IOException
                DirectCast(Kernel.WindowHashTable("LOGMSG"), LOGMSG).AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + " cyclic data read error.", False)
                ' DirectCast(Kernel.WindowHashTable("MAinWindow"), MainWindow).LogMsgWinOpen, "ButtonRedRoundWithContent")
            End Try
        Next
    End Sub
End Class
