﻿Imports System
Imports System.Net
Imports System.IO

Public Class TcpClientSync
    Private err As String = ""
    Private Shared Resource1 As New Object

    Dim host As IPAddress               ' server's hostname or ipaddress
    Dim port As Integer                 ' port number
    Dim MaxMsgLen As Integer

    Dim tcp As Sockets.TcpClient        'TcpClient instance
    Dim ns As Sockets.NetworkStream
    Dim sr As StreamReader
    Dim sw As StreamWriter

    ' constructor
    Sub New(Optional MaxMsgLen As Integer = 1024)
        Me.MaxMsgLen = MaxMsgLen
    End Sub

    Private Function MakeDispData(ByVal Data As Byte(), ByVal DataLength As Integer) As String
        ' make display string
        Dim DispData As String = ""

        For count As Integer = 0 To DataLength - 2
            DispData = DispData + Strings.Right("00" + Hex(Data(count)), 2) + " "
        Next
        DispData = DispData + Strings.Right("00" + Hex(Data(DataLength - 1)), 2)

        Return DispData
    End Function

    Private Function SaveLog(ByVal Message As String) As Integer
        Dim fs As FileStream = Nothing
        Dim sw As StreamWriter = Nothing
        Dim strFilename As String = System.IO.Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments), _
                                                    "Log\\" + "MSG_CLIENT" + System.DateTime.Now.ToString("yyyyMMdd") + ".csv")
        Try
            If Not File.Exists(strFilename) Then
                fs = New FileStream(strFilename, FileMode.Create, IO.FileAccess.Write, FileShare.Read)
                sw = New StreamWriter(fs)
            Else
                fs = New FileStream(strFilename, FileMode.Append, IO.FileAccess.Write, FileShare.Read)
                sw = New StreamWriter(fs)
            End If

            sw.WriteLine(DateTime.Now + " " + Message)
            sw.Close()
            fs.Close()

            Return 0
        Catch ex As IOException
            sw.Close()
            fs.Close()

            Return -1
        End Try
    End Function

    Public Function GetError() As String
        Dim ret As String = err
        err = ""
        GetError = ret
    End Function

    Public Function Connect(ByVal IpAddress As IPAddress, ByVal Port As Integer) As Integer
        Try
            tcp = New System.Net.Sockets.TcpClient()    ' connect to server
            tcp.Connect(IpAddress, Port)
            ns = tcp.GetStream()                        ' get NetworkStream
            sr = New System.IO.StreamReader(ns)
            sw = New System.IO.StreamWriter(ns)

            Connect = 0
        Catch ex As Exception
            err = ex.Message
            Connect = -1
        End Try
    End Function


    Public Function Connect(ByVal HostName As String, ByVal Port As Integer) As Integer
        Try
            tcp = New System.Net.Sockets.TcpClient(HostName, Port)  ' connect to server
            ns = tcp.GetStream()                                    ' get NetworkStream
            sr = New System.IO.StreamReader(ns)
            sw = New System.IO.StreamWriter(ns)

            Connect = 0
        Catch ex As Exception
            err = ex.Message
            Connect = -1
        End Try
    End Function


    ' send ASCII data
    Public Function Send(ByVal SendData As String) As Integer
        Try
            sw.WriteLine(SendData)                       ' send data
            sw.Flush()
            SaveLog("Send:[" + SendData + "]")
            Send = 0
        Catch ex As System.IO.IOException
            err = "IOException"
            Send = -1
        Catch ex As Exception
            err = "Exception"
            Send = -1
        End Try
    End Function

    ' send BINARY data
    Public Function Send(ByVal SendData() As Byte) As Integer
        Try
            ns.Write(SendData, 0, SendData.GetLength(0))
            SaveLog("Send:[" + MakeDispData(SendData, SendData.GetLength(0)) + "]")
            ns.Flush()
            Send = 0
        Catch ex As System.IO.IOException
            err = "IOException"
            Send = -1
        Catch ex As Exception
            err = "Exception"
            Send = -1
        End Try
    End Function

    ' receive ASCII data
    Public Function RecvAscii(ByRef RecvData As String) As Integer
        Try
            RecvData = sr.ReadLine()
            Return 0 ' receive data
        Catch ex As TimeoutException
            err = "TIMEOUT"
            Return -1
        Catch ex As Exception
            err = ex.Message
            Return -1
        End Try
    End Function

    ' receive binary data
    Public Function RecvBinary(ByRef RecvDataRet() As Byte) As Integer
        Try
            ns.Read(RecvDataRet, 0, MaxMsgLen)
            SaveLog("Recv:[" + MakeDispData(RecvDataRet, RecvDataRet.GetLength(0)) + "]")
            Return 0 ' binary data
        Catch ex As TimeoutException
            err = "TIMEOUT"
            Return -1
        Catch ex As Exception
            err = ex.Message
            Return -1
        End Try
    End Function

    ' receive binary data
    Public Function RecvBinary(ByRef RecvDataRet() As Byte, ByVal HeaderBytes As Integer, ByVal CountNumberStart As Integer, ByVal CountNumberBytes As Integer, ByVal CountStart As Integer, ByVal CountOrder As Integer) As Integer
        Dim RecvData(HeaderBytes - 1) As Byte
        Dim MsgLen As Integer = 0
        Dim ReceivedBytes As Integer = 0, ret As Integer = 0
        Dim count1 As Integer
        Dim count2 As Integer

        Try
            While True
                MsgLen = 0
                ReceivedBytes = 0

                Do Until ReceivedBytes = HeaderBytes
                    ret = ns.Read(RecvData, 0, HeaderBytes)
                    If ret > 0 Then
                        ReceivedBytes = ReceivedBytes + ret
                    Else
                        err = "Recv zero byte"
                        Return -1
                    End If
                Loop

                For count1 = 0 To CountNumberBytes - 1
                    If CountOrder = 1 Then  'Index=CountStartIndex+CountBytes-1 is higer digit
                        MsgLen += RecvData(count1 + CountNumberStart - 1) * CType(256 ^ count1, Integer)
                    Else                    'Index=0 is higer digit
                        MsgLen += RecvData(count1 + CountNumberStart - 1) * CType(256 ^ ((CountNumberBytes - 1) - count1), Integer)
                    End If
                Next

                ReDim RecvDataRet(CountStart - 1 + MsgLen - 1)
                For count2 = 0 To HeaderBytes - 1
                    RecvDataRet(count2) = RecvData(count2)
                Next

                ReceivedBytes = 0

                Do Until ReceivedBytes = CountStart - 1 + MsgLen - HeaderBytes
                    ret = ns.Read(RecvDataRet, HeaderBytes, CountStart - 1 + MsgLen - HeaderBytes - ReceivedBytes)
                    If ret > 0 Then
                        ReceivedBytes = ReceivedBytes + ret
                    Else
                        err = "Recv zero byte"
                        Return -1
                    End If
                Loop

                Return 0
                'RaiseEvent BinaryReceived(Me, ConnId, RecvDataRet, CountStart + RecvLength)    ' establish BinaryReceived event
            End While
        Catch ex As TimeoutException
            err = "TIMEOUT"
            Return -1
        Catch ex As System.IO.IOException
            err = "IOException"
            Return -1
            'RaiseEvent Disconnected(Me, ConnId)                                                ' establish Disconnected event
        Catch ex As Exception
            err = ex.Message
            Return -1
        End Try

        Return -1
    End Function

    ' close port
    Public Function Close() As Integer
        Try
            tcp.Close()
            ns.Close()
            sr.Close()
            sw.Close()

            Close = 0
        Catch ex As Exception
            Close = -1
        End Try
    End Function
End Class
