﻿Public MustInherit Class ChangedDelegatesBase
    Public Kernel As Kernel

    ''' <summary>
    ''' Show LogicalItem status
    ''' </summary>
    ''' <param name="LogicalItem"></param>
    ''' <param name="StatusTag"></param>
    ''' <param name="Control"></param>
    ''' <param name="ApplyStyle"></param>
    ''' <remarks></remarks>
    Public Sub CommonAction(ByVal LogicalItem As LogicalItem, ByVal StatusTag As String, ByVal Control() As Control, ByVal ApplyStyle() As String)
        For count As Integer = 0 To Control.GetLength(0) - 1
            Kernel.ChangeStyle(Control(count), ApplyStyle(count)) ' Valve
        Next

        If LogicalItem.PreStatusId <> CType(LogicalItem.ht(StatusTag), Integer) And LogicalItem.PreStatusId <> -1 Then
            Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + "[Delegates.CommonAction] " + LogicalItem.StateArray(LogicalItem.CurrentStatusId).Name + "(" + LogicalItem.StateArray(LogicalItem.CurrentStatusId).Tag + ")", True)
        End If
    End Sub

    '------------------------------------------------------------------------------------------------------------------------------------------
    ''' <summary>
    ''' Change style and add message in LOGMSG window
    ''' </summary>
    ''' <param name="LogicalItem"></param>
    ''' <remarks></remarks>
    Public Sub Handler_CHANGESTYLE_AND_LOGMSG(ByVal LogicalItem As LogicalItem)
        For count As Integer = 0 To LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray.GetLength(0) - 1
            Kernel.ChangeStyle(LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).ControlName, LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).Style)
        Next

        If LogicalItem.PreStatusId <> LogicalItem.CurrentStatusId And LogicalItem.PreStatusId <> -1 Then
            Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + "[Delegates.Handler_CHANGESTYLE_AND_LOGMSG] " + LogicalItem.Name + LogicalItem.StateArray(LogicalItem.CurrentStatusId).Name + "(" + LogicalItem.StateArray(LogicalItem.CurrentStatusId).Tag + ")", True)
        End If
    End Sub

    ''' <summary>
    ''' Change text and add message in LOGMSG window
    ''' </summary>
    ''' <param name="LogicalItem"></param>
    ''' <remarks></remarks>
    Public Sub Handler_CHANGETEXT_AND_LOGMSG(ByVal LogicalItem As LogicalItem)
        For count As Integer = 0 To LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray.GetLength(0) - 1
            Kernel.ChangeText(LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).ControlName, LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).Text)
        Next

        If LogicalItem.PreStatusId <> LogicalItem.CurrentStatusId And LogicalItem.PreStatusId <> -1 Then
            Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + "[Delegates.Handler_CHANGESTYLE_AND_LOGMSG] " + LogicalItem.Name + LogicalItem.StateArray(LogicalItem.CurrentStatusId).Name + "(" + LogicalItem.StateArray(LogicalItem.CurrentStatusId).Tag + ")", True)
        End If
    End Sub

    ''' <summary>
    ''' Change style and text and add message in LOGMSG window
    ''' </summary>
    ''' <param name="LogicalItem"></param>
    ''' <remarks></remarks>
    Public Sub Handler_CHANGESTYLEANDTEXT_AND_LOGMSG(ByVal LogicalItem As LogicalItem)
        For count As Integer = 0 To LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray.GetLength(0) - 1
            If LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).Style IsNot Nothing Then
                Kernel.ChangeStyle(LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).ControlName, LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).Style)
            End If
            If LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).Text IsNot Nothing Then
                Kernel.ChangeText(LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).ControlName, LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).Text)
            End If
        Next

        If LogicalItem.PreStatusId <> LogicalItem.CurrentStatusId And LogicalItem.PreStatusId <> -1 Then
            Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + "[Delegates.Handler_CHANGEANTYHING_AND_LOGMSG] " + LogicalItem.Name + LogicalItem.StateArray(LogicalItem.CurrentStatusId).Name + "(" + LogicalItem.StateArray(LogicalItem.CurrentStatusId).Tag + ")", True)
        End If
    End Sub

    ''' <summary>
    ''' Change style and text and visibility add message in LOGMSG window
    ''' </summary>
    ''' <param name="LogicalItem"></param>
    ''' <remarks></remarks>
    Public Sub Handler_CHANGEANYTHING_AND_LOGMSG(ByVal LogicalItem As LogicalItem)
        For count As Integer = 0 To LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray.GetLength(0) - 1
            If LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).Style IsNot Nothing Then
                Kernel.ChangeStyle(LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).ControlName, LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).Style)
            End If
            If LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).Text IsNot Nothing Then
                Kernel.ChangeText(LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).ControlName, LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).Text)
            End If
            If LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).Visibility IsNot Nothing Then
                Kernel.ChangeVisibility(LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).ControlName, LogicalItem.StateArray(LogicalItem.CurrentStatusId).LogicalDisplayItemArray(count).Visibility)
            End If
        Next

        If LogicalItem.PreStatusId <> LogicalItem.CurrentStatusId And LogicalItem.PreStatusId <> -1 Then
            Kernel.GetWindow(Of LOGMSG)("LOGMSG").AddMsg(System.DateTime.Now.ToString("yyyyMMdd HH:mm:ss ") + "[Delegates.Handler_CHANGEANTYHING_AND_LOGMSG] " + LogicalItem.Name + LogicalItem.StateArray(LogicalItem.CurrentStatusId).Name + "(" + LogicalItem.StateArray(LogicalItem.CurrentStatusId).Tag + ")", True)
        End If
    End Sub
End Class
