﻿Option Explicit On
Option Strict On
Option Infer Off

''' <summary>
'''  Delegates
''' </summary>
''' <remarks></remarks>
Public MustInherit Class CalcDelegatesBase
    Public Kernel As Kernel
    '' RealData calculation (User can define new function after examples below)

    ''' <summary>
    ''' Do nothing
    ''' </summary>
    ''' <param name="ValueArray"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function fncNoCalc(ByVal ValueArray() As Double) As Double
        Return ValueArray(0)
    End Function

    ''' <summary>
    ''' Input value times 10
    ''' </summary>
    ''' <param name="ValueArray"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function fncTimes10(ByVal ValueArray() As Double) As Double
        Return ValueArray(0) * 10
    End Function

    ''' <summary>
    ''' Input value times 100
    ''' </summary>
    ''' <param name="ValueArray"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function fncTimes100(ByVal ValueArray() As Double) As Double
        Return ValueArray(0) * 100
    End Function

    ''' <summary>
    ''' Input 2 words value, output double value
    ''' </summary>
    ''' <param name="ValueArray"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function fncWordsToSingle(ByVal ValueArray() As Double) As Double
        Dim UpperWord() As Byte = BitConverter.GetBytes(CShort(ValueArray(0)))
        Dim LowerWord() As Byte = BitConverter.GetBytes(CShort(ValueArray(1)))

        Return BitConverter.ToSingle(New Byte(3) {UpperWord(0), UpperWord(1), LowerWord(0), LowerWord(1)}, 0)
    End Function

    ''' <summary>
    ''' Input BCD value, output decimal value
    ''' </summary>
    ''' <param name="ValueArray"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function fncBCDToDouble(ByVal ValueArray() As Double) As Double
        Dim RetValue As UInt16

        If ValueArray(0) < 0 Then
            ValueArray(0) = ValueArray(0) + 65536
        End If

        Dim result As Integer = SharedFunctions.BCDToDec(CUShort(ValueArray(0)), RetValue)

        If result <> 0 Then
            MessageBox.Show("[fncBCDToDouble] DecToBCD failed.")
        End If
        Return CDbl(RetValue)
    End Function

    ''' <summary>
    ''' Input BCD value Output Decimal value
    ''' </summary>
    ''' <param name="ValueArray"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function fncBCDToDec(ByVal ValueArray() As Double) As Double
        If ValueArray(0) < 0 Then Return -9999
        Dim RetValue As UInt16
        SharedFunctions.BCDToDec(Convert.ToUInt16(ValueArray(0)), RetValue) ' 16進に戻す
        Return RetValue
    End Function

    ''' <summary>
    ''' Convert BCD to Decimal and times 10
    ''' </summary>
    ''' <param name="ValueArray"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function fncBCDToDecTimes10(ByVal ValueArray() As Double) As Double
        If ValueArray(0) < 0 Then Return -9999
        Dim RetValue As UInt16
        SharedFunctions.BCDToDec(Convert.ToUInt16(ValueArray(0)), RetValue) ' 16進に戻す
        Return RetValue * 10
    End Function

    ''' <summary>
    ''' Convert BCD to Decimal and times 100
    ''' </summary>
    ''' <param name="ValueArray"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function fncBCDToDecTimes100(ByVal ValueArray() As Double) As Double
        If ValueArray(0) < 0 Then Return -9999
        Dim RetValue As UInt16
        SharedFunctions.BCDToDec(Convert.ToUInt16(ValueArray(0)), RetValue) ' 16進に戻す
        Return RetValue * 100
    End Function
End Class
