(** some utility functions. These are not Scheme specified,
but missed OCaml standard library. *)

val id : 'a -> 'a
(** The identity function. *)

val create_hashtbl : ('a * 'b) list -> ('a, 'b) Hashtbl.t
(** Returns a fresh hashtable filled with the values of
the given list. *)

val gcd : int -> int -> int
(** [gcd a b] returns the greatest common divisor of [a] and [b]. *)

val lcm : int -> int -> int
(** [lcm a b] returns the least common multiple of [a] and [b]. *)

val find_rational : float -> int * int
(** [a, b = find_rational f] should resolve a/b = f. *)

val numerator : float -> int
(** Returns [a] of {!ScmUtil.find_rational} *)

val denominator : float -> int
(** Returns [b] of {!ScmUtil.find_rational} *)
