(**************************************************************************)
(*  Mana : A kana(romaji)-kanji conversion engine using ChaSen algorithm.    *)
(*  Copyright (C) 2003, 2004  Yamagata Yoriyuki                           *)
(*                                                                        *)
(*  This program is free software; you can redistribute it and/or modify  *)
(*  it under the terms of the GNU General Public License as published by  *)
(*  the Free Software Foundation; either version 2 of the License, or (at  *)
(*  your option) any later version.                                       *)
(*                                                                        *)
(*  This program is distributed in the hope that it will be useful, but   *)
(*  WITHOUT ANY WARRANTY; without even the implied warranty of            *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *)
(*  General Public License for more details.                              *)
(**************************************************************************)

(** [length string] ޤޤEUCʸο *)
val length: string -> int

(** [count string byte1 byte2] [byte1]ХȤ[byte2]ХȤޤǤEUC
   ʸο *)
val count: string -> byte1:int -> byte2:int -> int

(** [next string pos] ХȤǿƬ[byte]ΰ֤ȯ
˸ưưǽEUCʸƬʸκǽ
ХȿɽΡ*)
val next: string -> byte:int -> int

(** [nth string pos count] ХȤǿƬ[pos]ΰ֤
[count]EUCʸʬʸθ˰ưΰ֡[count+1]ܤEUCʸ
Ƭؤ*)
val nth: string -> byte:int -> count:int -> int

(** [nth string pos len] [pos](EUC)ʸܤΰ֤
[len]EUCʸʬʬʸڤФ*)
val sub: string -> pos:int -> len:int -> string
