/*
 *  gtk  libgauche Ȥäڲ S ǥ shiki
 *
 *  shiki.c author@WAKATSUKI toshihiro (alohakun@gmail.com)
 *  
 *  SourceForge.jp : S ǥ shiki Project
 *  https://sourceforge.jp/projects/shiki
 *  
 *  ȯ
 *  <30ǥǥ夬ΤƤߤBlog>
 *  http://alohakun.blog7.fc2.com/blog-category-29.html
 *
 *  饤 : Ʊ LICENSE 򸫤Ƥ (§ MIT/LGPL/GPL Υȥץ)
 *  󥹥ȡ : Ʊ README 򸫤Ƥ
 *  ǽ : Ʊ USAGE 򸫤Ƥ
 */

#include<gauche.h>
#include<gtk/gtk.h>
#include<gdk/gdkkeysyms.h>

#define INDENT_WIDTH 2

static GtkWidget *editor_window;

/* ƥȥХåեƤʸФ */
static gchar* get_all_buffer_contents(GtkTextBuffer *buffer) {
  GtkTextIter start, end;
  gtk_text_buffer_get_start_iter(buffer, &start);
  gtk_text_buffer_get_end_iter(buffer, &end);
  return gtk_text_buffer_get_text(buffer, &start, &end, FALSE);
}

/* buffer Ƥե filename ¸ */
static gboolean save_text_buffer(const gchar *filename, GtkTextBuffer *buffer) {
  gchar *contents, *text;
  gsize br, bw;
  GError *err = NULL;

  if(!filename) return FALSE;
  contents = get_all_buffer_contents(buffer);
  text = g_locale_from_utf8(contents, -1, &br, &bw, &err);
  /* ʸե¸ */
  g_file_set_contents(filename, text, -1, NULL);
  gtk_text_buffer_set_modified(buffer, FALSE);
  g_free(contents); g_free(text);
  return TRUE;
}

/* 򳫤ե̾msg ϥΥå */
static gchar *get_filename_from_dialog(const gchar *msg) {

  GtkWidget *dialog = gtk_file_selection_new(msg);
  int resp = gtk_dialog_run(GTK_DIALOG(dialog));
  gchar *filename = NULL;

  /* gtk_file_selection_get_filename ֤ʸŪ˳ݤ줿ХåեؤƤΤǡԡʤФʤʤ */
  if(resp == GTK_RESPONSE_OK)
    filename = g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(dialog)));

  gtk_widget_destroy(dialog);
  return filename;
}

/* ɽƤڡΥƥȥХåեФ */
static GtkTextBuffer* get_text_buffer_from_current_tabpage(GtkNotebook* notebook) {
  gint pagenum = gtk_notebook_get_current_page(notebook);
  GtkScrolledWindow *scrolledwindow = GTK_SCROLLED_WINDOW(gtk_notebook_get_nth_page(notebook, pagenum));
  /* GtkBin ϰĤҤʤݥƥʥ饹 */
  GtkTextView *view = GTK_TEXT_VIEW(gtk_bin_get_child(GTK_BIN(scrolledwindow)));
  return gtk_text_view_get_buffer(view);
}

/* ɽƤ륿֤Ƥե֤̾ */

/* ɽƤڡƤե¸ */
static void save_file_from_notebook(GtkNotebook *notebook) {
  GtkTextBuffer *buffer = get_text_buffer_from_current_tabpage(notebook);
  gchar *filename;
  gint current_page;

  /* ѹ̵в⤷ʤ */
  if(!gtk_text_buffer_get_modified(buffer)) return;

  /* ɽƤ륿֤Ƥե̾ */
  current_page = gtk_notebook_get_current_page(notebook);
  filename = g_strdup(gtk_notebook_get_tab_label_text(notebook, gtk_notebook_get_nth_page(notebook, current_page)));

  /* ޤե̾ꤵƤʤä顤򳫤Ϥ */
  if(!filename || g_ascii_strcasecmp("*scratch*", filename) == 0) {
    g_free(filename);
    if(!save_text_buffer(filename = get_filename_from_dialog("Save File As ..."), buffer))
      return;
  } else
    save_text_buffer(filename, buffer);

  gtk_notebook_set_tab_label_text(GTK_NOTEBOOK(notebook),
      gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), current_page),
      filename);
  gtk_window_set_title (GTK_WINDOW (editor_window), filename);
  g_free(filename);
}

/* ե¸륤٥ȥϥɥ */
static void save_file_handler(GtkWidget *widget, GtkWidget *notebook) {
  save_file_from_notebook(GTK_NOTEBOOK(notebook));
}

/* ɽƤڡƤե̾¸ */
static void save_file_as_from_notebook(GtkNotebook *notebook) {
  gint current_page;
  GtkTextBuffer *buffer = get_text_buffer_from_current_tabpage(notebook);
  gchar *filename = get_filename_from_dialog("Save File As ...");

  if(!save_text_buffer(filename, buffer)) return;

  current_page = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
  gtk_notebook_set_tab_label_text(GTK_NOTEBOOK(notebook),
      gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), current_page),
      filename);

  gtk_window_set_title (GTK_WINDOW (editor_window), filename);

  g_free(filename);
}

/* ե̾¸륤٥ȥϥɥ */
static void save_file_as_handler(GtkWidget *widget, GtkWidget *notebook) {
  save_file_as_from_notebook(GTK_NOTEBOOK(notebook));
}

/* YES ܥNO ܥ󤽤줾ǸƤФ callback */
void really_quit_dialog_yes(GtkWidget *widget, gboolean *flag){*flag = FALSE;}
void really_quit_dialog_no(GtkWidget *widget, gint *flag){*flag = TRUE;}

/* ˽λƤǤ ? */
gboolean not_yet_save_changes_really_quit(GtkTextBuffer *buffer) {
  GtkWidget *yes_button, *no_button;
  static GtkWidget *dialog_window = NULL;

  /* ѹ̵ФΤޤ޽λ */
  if(!gtk_text_buffer_get_modified(buffer)) return FALSE;

  if(dialog_window == NULL) {
    gboolean flag = TRUE;
    dialog_window = gtk_dialog_new ();

    /* ˽λƤǤ ? ν */
    g_signal_connect(G_OBJECT(dialog_window), "delete_event", G_CALLBACK(gtk_false), NULL);
    g_signal_connect(G_OBJECT(dialog_window), "destroy", G_CALLBACK(gtk_main_quit), NULL);

    gtk_window_set_title(GTK_WINDOW (dialog_window), "Really Quit ?");
    /* YES Υܥ */
    yes_button = gtk_button_new_with_label("YES");
    g_signal_connect(GTK_OBJECT(yes_button), "clicked", G_CALLBACK(really_quit_dialog_yes), &flag);
    g_signal_connect_swapped(GTK_OBJECT(yes_button), "clicked", G_CALLBACK(gtk_widget_destroy), G_OBJECT(dialog_window));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog_window)->action_area),  yes_button, TRUE, TRUE, 0);

    /* NO Υܥ */
    no_button = gtk_button_new_with_label("NO");
    g_signal_connect(GTK_OBJECT(no_button), "clicked", G_CALLBACK(really_quit_dialog_no), &flag);
    g_signal_connect_swapped(GTK_OBJECT(no_button), "clicked", G_CALLBACK(gtk_widget_destroy), G_OBJECT(dialog_window));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog_window)->action_area),  no_button, TRUE, TRUE, 0);

    gtk_window_set_modal(GTK_WINDOW(dialog_window), TRUE);
    gtk_window_set_transient_for(GTK_WINDOW(dialog_window), GTK_WINDOW (editor_window));

    gtk_widget_show_all(dialog_window);
    gtk_main ();
    dialog_window = NULL;

    /* "delete_event" ֤ͤ FALSE ʤ"destory" ȯԤ졤window ˲ */
    return flag;
  }
  return TRUE;
}

/* Хåեޤ¸ƤʤΤ˽λΤҤͤ */
gboolean delete_event_handler(GtkWidget *widget, GdkEvent *event, GtkWidget *buffer){
  return not_yet_save_changes_really_quit(GTK_TEXT_BUFFER(buffer));
}

/* Хåե */
static GtkWidget *new_scrolled_text_buffer() {

  GtkWidget *scrolledwindow, *view;
  GtkTextBuffer *buffer;

  /* 륦ɤ */
  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  /* ƥȥӥ塼ȥХåե */
  view = gtk_text_view_new();
  buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(view));
  gtk_container_add(GTK_CONTAINER(scrolledwindow), view);
  g_signal_connect(G_OBJECT(editor_window), "delete_event", G_CALLBACK(delete_event_handler), buffer);
  gtk_widget_set_size_request(GTK_WIDGET(view), 500, 500);

  /* ͡ʽ */
  
  /* ̤ζĴɽΤΥ */
  gtk_text_buffer_create_tag (buffer, "parent_emphasis_background", "background", "green", NULL);

  return scrolledwindow;
}

/* ե򳫤 */
static void open_file_from_notebook(GtkNotebook *notebook) {
  gchar *contents, *text;
  gsize br, bw, len;
  GError *err = NULL;

  gchar *filename = get_filename_from_dialog("File Selection");

  if(!filename) return;

  if(g_file_get_contents(filename, &contents, &len, NULL)) {
    GtkTextBuffer *buffer;
    GtkWidget *scrolledwindow;
    GtkTextIter p;
    
    /* Хåե򳫤 */
    gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
                             scrolledwindow = new_scrolled_text_buffer(),
                             gtk_label_new(filename));
    buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(gtk_bin_get_child(GTK_BIN(scrolledwindow))));

    if(!(text = g_locale_to_utf8(contents, -1, &br, &bw, &err)))
      gtk_text_buffer_set_text(buffer, contents, len);
    else
      gtk_text_buffer_set_text(buffer, text, len);

    /* Хåե̤ѹ */
    gtk_text_buffer_set_modified(buffer, FALSE);
    /* ֤Ƭ */
    gtk_text_buffer_get_start_iter(buffer, &p);
    gtk_text_buffer_place_cursor(buffer, &p);
    gtk_window_set_title (GTK_WINDOW (editor_window), filename);
    gtk_widget_show_all(GTK_WIDGET(notebook));
    g_free(contents); g_free(text); g_free(filename);
  } else
    g_printerr("Get file contents error !\n");
}

/* ե򳫤٥ȥϥɥ */
static void open_file_handler(GtkWidget *widget,  GtkWidget *notebook) {
  open_file_from_notebook(GTK_NOTEBOOK(notebook));
}

/* gauche ưʸɾ */
static gchar *eval_cstring_by_gauche(gchar *s) {
  gchar *msg;

  ScmObj result, error; 
  /* ʸݡȳ */
  ScmObj os = Scm_MakeOutputStringPort(TRUE);

  /* Scheme ٥ǥ顼ϥɥ */
  /* http://alohakun.blog7.fc2.com/blog-entry-517.html */
  Scm_Define(Scm_UserModule(), SCM_SYMBOL(SCM_INTERN("*input*")), SCM_MAKE_STR(s));
  Scm_Define(Scm_UserModule(), SCM_SYMBOL(SCM_INTERN("*error*")), SCM_FALSE);

  result = Scm_EvalCString("(guard (e (else (set! *error* e) #f)) (eval (read-from-string *input*) (current-module)))", SCM_OBJ(Scm_UserModule()));

  error = Scm_GlobalVariableRef(Scm_UserModule(), SCM_SYMBOL(SCM_INTERN("*error*")), 0);

  /* ʸɾ̤ݡȤ˽񤭹 */
  if (!SCM_FALSEP(error))
    Scm_Write(error, os, SCM_WRITE_DISPLAY);
  else
    Scm_Write(result, os, SCM_WRITE_DISPLAY);

  msg = Scm_GetString(SCM_STRING(Scm_GetOutputString(SCM_PORT(os))));
  /* ݡĤ */
  Scm_ClosePort(SCM_PORT(os));

  return msg;
}

/* ХܥΥϥɥ󥰡Хåե򤵤Ƥ S ɾ */
static void buffer_exec_handler(GtkWidget *widget,  GtkWidget *notebook) {
  GtkTextBuffer *buffer = get_text_buffer_from_current_tabpage(GTK_NOTEBOOK(notebook));

  GtkTextIter start, end, p;
  gchar *code;
  gtk_text_buffer_get_end_iter(buffer, &p);
  gtk_text_buffer_insert(buffer, &p, "\n\n", -1);

  /* ޥ򤵤ƤϰϤʸ */
  if(gtk_text_buffer_get_selection_bounds(buffer, &start, &end)) {
    code = gtk_text_buffer_get_text(buffer, &start, &end, FALSE);
    gtk_text_buffer_insert(buffer, &p, eval_cstring_by_gauche(code), -1);
    g_free(code);
  }

}

// GtkTextCharPredicate
static gboolean is_kakko_or_kokka(gunichar ch, gpointer p) {
  return ch == '(' || ch == ')';
}
static gboolean is_kokka(gunichar ch, gpointer p) {return ch == ')';}


/* ')' б '(' ޤǤʸ (S ) ڤФ */
static gboolean search_sexp_string(GtkTextIter *start) {
  gint nest_level = 0;
  /* ֤ˤ S ڤФ */
  while(1) {
    if(!gtk_text_iter_backward_find_char(start, is_kakko_or_kokka, NULL, NULL))
      return FALSE;

    if(gtk_text_iter_get_char(start) == ')')
      nest_level++;
    else {
      if(!nest_level)
        break;
      else
        nest_level--;
    }
  }
  return TRUE;
}

/* ֤Υͥȥ٥֤ */
static gint get_parent_nest_level_at_cursor(GtkTextBuffer *buffer) {
  gint nest_level = 0;
  GtkTextIter start, end;
  gtk_text_buffer_get_start_iter(buffer, &start);
  if(gtk_text_iter_get_char(&start) == '(') nest_level++;

  /* ΰ (= end)  */
  gtk_text_buffer_get_iter_at_mark(buffer,&end, gtk_text_buffer_get_insert(buffer));

  while(1) {
    /* end ޤ '('  ')' õƸĤʤä齪λ */
    if(!gtk_text_iter_forward_find_char(&start, is_kakko_or_kokka, NULL, &end))
      return nest_level;

    if(gtk_text_iter_get_char(&start) == '(')
      nest_level++;
    else 
      nest_level--;
  }
}

/* ֤ڤؤΥ٥ȥϥɥ */
static void switch_page(GtkNotebook *notebook, GtkNotebookPage *page, guint pagenum, gpointer p) {
  /* ֤Υ٥򥦥ɥΥȥ */
  gtk_window_set_title (GTK_WINDOW(editor_window), gtk_notebook_get_tab_label_text(notebook, GTK_WIDGET(gtk_notebook_get_nth_page(notebook, pagenum))));
}

/* ڡΥ֤ȶ on/off */
static void tabsborder_on_off(GtkButton *button, GtkNotebook *notebook) {
  gint tval = FALSE;
  gint bval = FALSE;
  if(notebook->show_tabs == FALSE)
    tval = TRUE; 
  if(notebook->show_border == FALSE)
    bval = TRUE;

  gtk_notebook_set_show_tabs(notebook, tval);
  gtk_notebook_set_show_border(notebook, bval);
}

/* Ρȥ֥åڡ */
static void remove_tabpage(GtkNotebook *notebook) {
  GtkTextBuffer *buffer = get_text_buffer_from_current_tabpage(notebook);
  if(!not_yet_save_changes_really_quit(buffer)) {
    gint page = gtk_notebook_get_current_page(notebook);
    gtk_notebook_remove_page(notebook, page);
    /* åȤŪ˺ */
    gtk_widget_queue_draw(GTK_WIDGET(notebook));
  }
}

static void remove_tabpage_handler(GtkButton *button, GtkWidget *notebook) {
  remove_tabpage(GTK_NOTEBOOK(notebook));
}

/* Ρȥ֥å˥ڡɲ */
static void append_tabpage(GtkButton *button, GtkNotebook *notebook) {
  gtk_notebook_append_page(notebook, new_scrolled_text_buffer(), gtk_label_new("*scratch*"));
  gtk_widget_show_all(GTK_WIDGET(notebook));
}

/* ֤ΰ֤Ĵ */
static void rotate_tab_position(GtkButton   *button, GtkNotebook *notebook ) {
  gtk_notebook_set_tab_pos(notebook, (notebook->tab_pos + 1) % 4);
}

/* ΥΥϥɥ */

/* 줿 */
static gboolean signal_key_press_handler (GtkWidget *notebook, GdkEventKey *event, gpointer p) {
  GtkTextBuffer *buffer = get_text_buffer_from_current_tabpage(GTK_NOTEBOOK(notebook));

  GtkTextIter start, end;

  /* ̤бζĴ̵ */
  gtk_text_buffer_get_start_iter(buffer, &start);
  gtk_text_buffer_get_end_iter(buffer, &end);
  gtk_text_buffer_remove_tag_by_name(buffer, "parent_emphasis_background", &start, &end);

  /* Ctrl + j :  S ɾ */
  if(event->keyval == GDK_j && event->state & GDK_CONTROL_MASK) {
    gchar *code;
    GtkTextIter start, end;

    /* ΰ֤ */
    gtk_text_buffer_get_iter_at_mark(buffer, &end, gtk_text_buffer_get_insert(buffer));

    gtk_text_iter_backward_find_char(&end, is_kokka, NULL, NULL);
    start = end;
    gtk_text_iter_forward_char(&end);

    /* ֤ˤ S ڤФ */
    if(!search_sexp_string(&start)) return FALSE;

    code = gtk_text_buffer_get_text(buffer, &start, &end, FALSE);
    gtk_text_buffer_insert(buffer, &end, "\n\n", -1);
    gtk_text_buffer_insert(buffer, &end, eval_cstring_by_gauche(code), -1);
    g_free(code);
  }

  /* Ctrl + O : ե볫 */
  if(event->keyval == GDK_O && event->state & GDK_CONTROL_MASK) {
    open_file_from_notebook(GTK_NOTEBOOK(notebook));    
  }

  /* Ctrl + s : ե¸ */
  if(event->keyval == GDK_s && event->state & GDK_CONTROL_MASK) {
    save_file_from_notebook(GTK_NOTEBOOK(notebook));    
  }

  /* Ctrl + w : ե̾¸ */
  if(event->keyval == GDK_w && event->state & GDK_CONTROL_MASK) {
    save_file_as_from_notebook(GTK_NOTEBOOK(notebook));    
  }
  
  /* Ctrl + t : ֤򳫤 */
  if(event->keyval == GDK_t && event->state & GDK_CONTROL_MASK) {
    gtk_notebook_append_page(GTK_NOTEBOOK(notebook), new_scrolled_text_buffer(), gtk_label_new("*scratch*"));
    gtk_widget_show_all(GTK_WIDGET(notebook));
  }

  /* Ctrl + c : ֤Ĥ */
  if(event->keyval == GDK_C && event->state & GDK_CONTROL_MASK) {
    remove_tabpage(GTK_NOTEBOOK(notebook));
  }

  /* Ctrl + q : λ */
  if(event->keyval == GDK_q && event->state & GDK_CONTROL_MASK) {
    /* "delete-event" ȯ롥ɥ  ܥ󤬲줿ΤƱ */
    GdkEvent ev;

    ev.any.type = GDK_DELETE;
    ev.any.window = editor_window->window;
    ev.any.send_event = FALSE;
    gdk_event_put (&ev);
  }

  return FALSE;
}

/* Υ줿 */
static gboolean signal_key_release_handler (GtkWidget *notebook, GdkEventKey *event, gpointer p) {

  GtkTextBuffer *buffer = get_text_buffer_from_current_tabpage(GTK_NOTEBOOK(notebook));

  if(event->keyval == GDK_parenright && event->state & GDK_SHIFT_MASK) {
    GtkTextIter start, end;

    /* ΰ֤ */
    gtk_text_buffer_get_iter_at_mark(buffer, &end, gtk_text_buffer_get_insert(buffer));

    start = end;
    gtk_text_iter_backward_char(&start);

    /* ֤ˤ S ڤФ */
    if(!search_sexp_string(&start)) return FALSE;

    gtk_text_buffer_apply_tag_by_name(buffer, "parent_emphasis_background", &start, &end);
  }

  /* Ԥ뤿ӤˡưŪ˳̤ΥͥȤο˱Υڡ (ǥ) Ƭ */
  if(event->keyval == GDK_Return) {
    gint indentWidth = get_parent_nest_level_at_cursor(buffer) * INDENT_WIDTH;
    gchar *indent = g_strnfill(indentWidth, ' ');
    gtk_text_buffer_insert_at_cursor(buffer, indent, -1);
    g_free(indent);
  }

  return FALSE;
}

/* ǥԽ̤ν */
static void editor_window_init() {
  GtkWidget *vbox, *toolbar, *notebook;
  GtkToolItem *icon;
  GtkIconSize iconsize;
  /* ֳס¸ס̾¸סΰ¹ԡץ */
  GtkToolItem *oicon, *sicon, *saicon, *eicon;

  /*  */
  editor_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  g_signal_connect(G_OBJECT(editor_window), "destroy", G_CALLBACK(gtk_main_quit), NULL);

  /* ѥå󥰥ܥå */
  vbox = gtk_vbox_new(FALSE, 0);
  /* ġС */
  toolbar = gtk_toolbar_new();
  gtk_box_pack_start(GTK_BOX(vbox), toolbar, FALSE, FALSE, 0);

  notebook = gtk_notebook_new();
  g_signal_connect(G_OBJECT(notebook), "switch-page", GTK_SIGNAL_FUNC(switch_page), NULL);

  /* ġСդ륢 */
  gtk_toolbar_set_style(GTK_TOOLBAR (toolbar), GTK_TOOLBAR_ICONS);
  iconsize = gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar));

  /*  */

  /* ե볫 */
  oicon = gtk_tool_button_new(gtk_image_new_from_stock ("gtk-open", iconsize), "");
  /* ֳץܥ˥եɤ߹ॢϢդ */
  g_signal_connect(G_OBJECT(oicon), "clicked", G_CALLBACK(open_file_handler), G_OBJECT(notebook));
  gtk_container_add(GTK_CONTAINER (toolbar), GTK_WIDGET(oicon));

  /* Хåե¸ */
  sicon = gtk_tool_button_new(gtk_image_new_from_stock ("gtk-save", iconsize), "");
  /* ¸ץܥ˥ե񤭽ФϢդ */
  g_signal_connect(G_OBJECT(sicon), "clicked", G_CALLBACK(save_file_handler), G_OBJECT(notebook));
  gtk_container_add (GTK_CONTAINER (toolbar), GTK_WIDGET(sicon));      

  /* Хåե̾¸ */
  saicon = gtk_tool_button_new(gtk_image_new_from_stock ("gtk-save-as", iconsize), "");
  /* ̾¸ץܥ̾Υե볫Ƥ񤭽ФϢդ */
  g_signal_connect(G_OBJECT(saicon), "clicked", G_CALLBACK(save_file_as_handler), G_OBJECT(notebook));

  gtk_container_add (GTK_CONTAINER (toolbar), GTK_WIDGET(saicon));

  /* Хåե¹ */
  eicon = gtk_tool_button_new(gtk_image_new_from_stock ("gtk-execute", iconsize), "");
  /* Хåե¹ԥܥ libgauche Ϣդ */
  g_signal_connect(G_OBJECT(eicon), "clicked", G_CALLBACK(buffer_exec_handler), G_OBJECT(notebook));
  gtk_container_add (GTK_CONTAINER (toolbar), GTK_WIDGET(eicon));

  /* ХɤΥϥɥ󥰤Ͽ */
  g_signal_connect(G_OBJECT(notebook), "key-press-event", G_CALLBACK (signal_key_press_handler), NULL);
  g_signal_connect(G_OBJECT(notebook), "key-release-event", G_CALLBACK (signal_key_release_handler), NULL);
  gtk_container_add(GTK_CONTAINER(editor_window), vbox);
  gtk_container_add(GTK_CONTAINER(vbox), notebook);

  /* ǥեȤΥڡɲ */
  gtk_notebook_prepend_page(GTK_NOTEBOOK(notebook),
      new_scrolled_text_buffer(),
      gtk_label_new("*scratch*"));

  /* ֤ on/off */
  icon = gtk_tool_button_new(gtk_image_new_from_stock ("gtk-apply", iconsize), "append");
  g_signal_connect(G_OBJECT(icon), "clicked", G_CALLBACK(tabsborder_on_off), G_OBJECT(notebook));
  gtk_container_add(GTK_CONTAINER (toolbar), GTK_WIDGET(icon));

  /* ֤ΰ */
  icon = gtk_tool_button_new(gtk_image_new_from_stock ("gtk-preferences", iconsize), "append");
  g_signal_connect(G_OBJECT(icon), "clicked", G_CALLBACK(rotate_tab_position), G_OBJECT( notebook));
  gtk_container_add(GTK_CONTAINER (toolbar), GTK_WIDGET(icon));

  /* ֤ɲ */
  icon = gtk_tool_button_new(gtk_image_new_from_stock ("gtk-add", iconsize), "append");
  g_signal_connect(G_OBJECT(icon), "clicked", G_CALLBACK(append_tabpage), G_OBJECT( notebook));
  gtk_container_add(GTK_CONTAINER (toolbar), GTK_WIDGET(icon));

  /* 򤵤Ƥڡ */
  icon = gtk_tool_button_new(gtk_image_new_from_stock ("gtk-close", iconsize), "remove");
  g_signal_connect(G_OBJECT(icon), "clicked", G_CALLBACK(remove_tabpage_handler), G_OBJECT( notebook));
  gtk_container_add(GTK_CONTAINER (toolbar), GTK_WIDGET(icon));

  gtk_widget_show_all(editor_window);
}

int main(int argc, char *argv[]) {
  /* ƥᥤ롼פ */
  gtk_set_locale(); 
  gtk_init(&argc, &argv);
  GC_INIT(); Scm_Init(GAUCHE_SIGNATURE);
  editor_window_init();
  gtk_main();
  Scm_Exit(0);
  return 0;
}
