/*
HMButtonCell.h

Author: Makoto Kinoshita & MIURA Kazki

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>

typedef enum _HMButtonType {
	HMNormalButtonType = 0,
	HMSeparatorButtonType = 1,
	HMButtonTypeCount = 2
} HMButtonType;

typedef enum _HMBezelStyle {
	HMNormalBezelStyle = 0,
	HMCustomImageBezelStyle = 1,
	HMSolidBezelStyle = 2,
	HMBezelStyleCount = 3
} HMBezelStyle;

@interface HMButtonCell : NSButtonCell
{
	int			_HMButtonType;
	int			_HMBezelStyle;
	NSImage*    _bezelImage;
	NSImage*    _alternateBezelImage;
    
    BOOL        _isSelected;
    NSImage*    _selectedImage;
}

// ButtonType
- (void)setHMButtonType:(HMButtonType)type;
- (BOOL)isSeparator;
- (void)setSeparator:(BOOL)isSeparator;

// BezelStyle
- (HMBezelStyle)HMBezelStyle;
- (void)setHMBezelStyle:(HMBezelStyle)style;
- (void)setBezelStyle:(NSBezelStyle)style;		// Bezel style setting methods nullify bezelImage & alternateBezelImage
- (NSImage*)bezelImage;
- (void)setBezelImage:(NSImage*)image;
- (NSImage*)alternateBezelImage;
- (void)setAlternateBezelImage:(NSImage*)image;

// Selection
- (BOOL)isSelected;
- (void)setSelected:(BOOL)isSelected;
- (NSImage*)selectedImage;
- (void)setSelectedImage:(NSImage*)image;

@end
