/*
SRFullScreenWindow.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRFullScreenWindow.h"

static NSImage* _fullScreenBackL = nil;
static NSImage* _fullScreenBackM = nil;
static NSImage* _fullScreenBackR = nil;
static NSSize   _fullScreenBackSizeL;
static NSSize   _fullScreenBackSizeM;
static NSSize   _fullScreenBackSizeR;

static NSImage* _fullScreenProgressBack = nil;
static NSSize   _fullScreenProgressBackSize;

@implementation SRFullScreenControlView

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (id)initWithFrame:(NSRect)frame
{
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    // Initialize images
    if (!_fullScreenBackL) {
        NSBundle*   bundle;
        bundle = [NSBundle bundleForClass:[self class]];
        
        _fullScreenBackL = [[NSImage alloc] initWithContentsOfFile:
                [bundle pathForImageResource:@"fullScreenBackL"]];
        _fullScreenBackM = [[NSImage alloc] initWithContentsOfFile:
                [bundle pathForImageResource:@"fullScreenBackM"]];
        _fullScreenBackR = [[NSImage alloc] initWithContentsOfFile:
                [bundle pathForImageResource:@"fullScreenBackR"]];
        _fullScreenBackSizeL = [_fullScreenBackL size];
        _fullScreenBackSizeM = [_fullScreenBackM size];
        _fullScreenBackSizeR = [_fullScreenBackR size];
    }
    
    return self;
}

//--------------------------------------------------------------//
#pragma mark -- Drawing --
//--------------------------------------------------------------//

- (void)drawRect:(NSRect)rect
{
    // Get frame
    NSRect  frame;
    frame = [self frame];
    
    // Clear rect
    [[NSColor clearColor] set];
    NSRectFill(rect);
    
    // Draw background image
    NSRect  srcRect, destRect;
    
    // Draw background left image
    srcRect.origin = NSZeroPoint;
    srcRect.size = _fullScreenBackSizeL;
    destRect.origin = NSZeroPoint;
    destRect.size   = _fullScreenBackSizeL;
    if (NSIntersectsRect(destRect, rect)) {
        [_fullScreenBackL drawInRect:destRect fromRect:srcRect 
                operation:NSCompositeSourceOver fraction:1.0f];
    }
    
    // Draw background middle image
    srcRect.origin = NSZeroPoint;
    srcRect.size = _fullScreenBackSizeM;
    destRect.origin.x = _fullScreenBackSizeL.width;
    destRect.origin.y = 0;
    destRect.size.width = frame.size.width - _fullScreenBackSizeL.width - _fullScreenBackSizeR.width;
    destRect.size.height = _fullScreenBackSizeM.height;
    if (NSIntersectsRect(destRect, rect)) {
        [_fullScreenBackM drawInRect:destRect fromRect:srcRect 
                operation:NSCompositeSourceOver fraction:1.0f];
    }
    
    // Draw background right image
    srcRect.origin = NSZeroPoint;
    srcRect.size = _fullScreenBackSizeR;
    destRect.origin.x = frame.size.width - _fullScreenBackSizeR.width;
    destRect.origin.y = 0;
    destRect.size   = _fullScreenBackSizeR;
    if (NSIntersectsRect(destRect, rect)) {
        [_fullScreenBackR drawInRect:destRect fromRect:srcRect 
                operation:NSCompositeSourceOver fraction:1.0f];
    }
}

@end

#pragma mark -

@implementation SRFullScreenControlWindow

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (id)initWithContentRect:(NSRect)contentRect 
        styleMask:(unsigned int)styleMask 
        backing:(NSBackingStoreType)bufferingType 
        defer:(BOOL)deferCreation
{
    self = [super initWithContentRect:contentRect 
            styleMask:NSBorderlessWindowMask backing:bufferingType defer:deferCreation];
    if (!self) {
        return nil;
    }
    
    return self;
}

//--------------------------------------------------------------//
#pragma mark -- NSResponder override --
//--------------------------------------------------------------//

- (void)mouseDown:(NSEvent*)event
{
    [super mouseDown:event];
    
    id  delegate;
    delegate = [self delegate];
    if ([delegate respondsToSelector:@selector(window:mouseDown:)]) {
        [delegate window:self mouseDown:event];
    }
}

- (void)mouseUp:(NSEvent*)event
{
    [super mouseUp:event];
    
    id  delegate;
    delegate = [self delegate];
    if ([delegate respondsToSelector:@selector(window:mouseUp:)]) {
        [delegate window:self mouseUp:event];
    }
}

- (void)mouseMoved:(NSEvent*)event
{
    [super mouseMoved:event];
    
    id  delegate;
    delegate = [self delegate];
    if ([delegate respondsToSelector:@selector(window:mouseMoved:)]) {
        [delegate window:self mouseMoved:event];
    }
}

//--------------------------------------------------------------//
#pragma mark -- NSWindow override --
//--------------------------------------------------------------//

- (BOOL)canBecomeKeyWindow
{
    return YES;
}

@end

#pragma mark -

@implementation SRFullScreenProgressView

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (id)initWithFrame:(NSRect)frame
{
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    // Initialize images
    if (!_fullScreenProgressBack) {
        NSBundle*   bundle;
        bundle = [NSBundle bundleForClass:[self class]];
        
        _fullScreenProgressBack = [[NSImage alloc] initWithContentsOfFile:
                [bundle pathForImageResource:@"fullScreenProgressBack"]];
        _fullScreenProgressBackSize = [_fullScreenProgressBack size];
    }
    
    return self;
}

//--------------------------------------------------------------//
#pragma mark -- Drawing --
//--------------------------------------------------------------//

- (void)drawRect:(NSRect)rect
{
    // Get frame
    NSRect  frame;
    frame = [self frame];
    
    // Clear rect
    [[NSColor clearColor] set];
    NSRectFill(rect);
    
    // Draw background image
    NSRect  srcRect, destRect;
    srcRect.origin = NSZeroPoint;
    srcRect.size = _fullScreenProgressBackSize;
    destRect = frame;
    [_fullScreenProgressBack drawInRect:destRect fromRect:srcRect 
            operation:NSCompositeSourceOver fraction:1.0f];
}

@end

#pragma mark -

@implementation SRFullScreenProgressWindow

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (id)initWithContentRect:(NSRect)contentRect 
        styleMask:(unsigned int)styleMask 
        backing:(NSBackingStoreType)bufferingType 
        defer:(BOOL)deferCreation
{
    self = [super initWithContentRect:contentRect 
            styleMask:NSBorderlessWindowMask backing:bufferingType defer:deferCreation];
    if (!self) {
        return nil;
    }
    
    return self;
}

@end
