/*
SRBookmark.h

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <HMDTFoundation/HMDTFoundation.h>
#import <HMDTWebKit/HMDTWebKit.h>

@interface SRBookmark :  NSManagedObject  
{
}

// Initialize
+ (SRBookmark*)bookmarkWithTitle:(NSString*)title 
        URLString:(NSString*)urlString 
        context:(NSManagedObjectContext*)context 
        persistentStore:(id)store;
+ (SRBookmark*)folderWithTitle:(NSString*)title 
        context:(NSManagedObjectContext*)context 
        persistentStore:(id)store;
+ (SRBookmark*)bookmarkForBookmarkBarWithContext:(NSManagedObjectContext*)context 
        persistentStore:(id)store;

// Accessors
- (NSString*)title;
- (void)setTitle:(NSString*)value;
- (NSString*)type;
- (void)setType:(NSString*)value;
- (NSString*)browser;
- (void)setBrowser:(NSString*)value;
- (NSNumber*)index;
- (void)setIndex:(NSNumber*)value;
- (NSNumber*)isMutable;
- (void)setIsMutable:(NSNumber*)value;
- (NSString*)urlString;
- (void)setUrlString:(NSString*)value;
- (NSNumber*)isAutoTab;
- (void)setIsAutoTab:(NSNumber*)value;
- (void)addChildrenObject:(SRBookmark*)value;
- (void)removeChildrenObject:(SRBookmark*)value;

// Bookmark attributes
- (NSImage*)icon;
- (NSNumber*)isFolder;
- (NSNumber*)isLeaf;

// Working with children
- (NSArray*)sortedChildren;
- (void)insertBookmarks:(NSArray*)bookmarks atIndex:(unsigned int)index;
- (void)addBookmarks:(NSArray*)bookmarks;
- (void)removeBookmarks:(NSArray*)bookmarks;
- (BOOL)isDescendantOf:(SRBookmark*)bookmark;

@end

@interface SRBookmarkFactory : NSObject
{
    NSManagedObjectContext* _context;
    id                      _store;
}

// Initialize
+ (id)sharedInstanceWithManagedObjectContext:(NSManagedObjectContext*)context 
        persistentStore:(id)store;
- (id)initWithManagedObjectContext:(NSManagedObjectContext*)context 
        persistentStore:(id)store;

// Bookmark creation
- (SRBookmark*)bookmarkWithTitle:(NSString*)title 
        URLString:(NSString*)urlString;
- (SRBookmark*)folderWithTitle:(NSString*)title;
- (SRBookmark*)bookmarkForBookmarkBar;

// Copying
- (SRBookmark*)copyBookmark:(SRBookmark*)bookmark;

@end
