/*
HMTableHeaderView.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "HMTableHeaderView.h"

@implementation HMTableHeaderView

//--------------------------------------------------------------//
#pragma mark -- Split view --
//--------------------------------------------------------------//

- (NSSplitView*)splitView
{
    return _splitView;
}

- (void)setSplitView:(NSSplitView*)splitView
{
    _splitView = splitView;
}

//--------------------------------------------------------------//
#pragma mark -- Dragging --
//--------------------------------------------------------------//

- (void)mouseDown:(NSEvent*)event
{
    if (!_splitView) {
        return;
    }
    
    // Get delegate
    id  delegate;
    delegate = [_splitView delegate];
    
    // Get frame
    NSRect  frame;
    frame = [self frame];
    
    // Get mouse location
    NSPoint mouseLoc;
    mouseLoc = [self convertPoint:[event locationInWindow] fromView:nil];
    
    // Get subview for dragging
    NSView* view = nil;
    NSRect  viewFrame;
    if ([[_splitView subviews] count] > 0) {
        view = [[_splitView subviews] objectAtIndex:0];
    }
    if (!view) {
        return;
    }
    viewFrame = [view frame];
    
    // Track mouse
    NSRect  trackingArea, rect;
    NSDivideRect(frame, &trackingArea, &rect, 16.0f, NSMaxXEdge);
    if ([self mouse:mouseLoc inRect:trackingArea]) {
        // Get min and max
        float   min = 0.0f, max = [_splitView frame].size.width;
        if ([delegate respondsToSelector:@selector(splitView:constrainMinCoordinate:ofSubviewAt:)]) {
            min = [delegate splitView:_splitView constrainMinCoordinate:min ofSubviewAt:0];
        }
        if ([delegate respondsToSelector:@selector(splitView:constrainMaxCoordinate:ofSubviewAt:)]) {
            max = [delegate splitView:_splitView constrainMaxCoordinate:max ofSubviewAt:0];
        }
        
        // Event loop
        while (YES) {
            // Wait next event
            NSEvent*    waitingEvent;
            waitingEvent = [NSApp nextEventMatchingMask:(NSLeftMouseDraggedMask | NSLeftMouseUpMask) 
                    untilDate:[NSDate distantFuture] 
                    inMode:NSEventTrackingRunLoopMode 
                    dequeue:YES];
            if (!waitingEvent) {
                break;
            }
            
            // For dragging
            if ([waitingEvent type] == NSLeftMouseDragged) {
                // Calc dragging distant
                NSPoint newMouseLoc;
                int     delta;
                newMouseLoc = [self convertPoint:[waitingEvent locationInWindow] fromView:nil];
                delta = [waitingEvent locationInWindow].x - [event locationInWindow].x;
                
                if (delta != 0) {
                    NSRect  newFrame;
                    newFrame = viewFrame;
                    newFrame.size.width += delta;
                    if (newFrame.size.width < min) {
                        newFrame.size.width = min;
                    }
                    else if (newFrame.size.width > max) {
                        newFrame.size.width = max;
                    }
                    [view setFrame:newFrame];
                    
                    [_splitView adjustSubviews];
                    
                    // Notify to split view
                    if ([delegate respondsToSelector:@selector(splitViewDidResizeSubviews:)]) {
                        [delegate splitViewDidResizeSubviews:nil];
                    }
                }
                
                continue;
            }
            
            // For mouse up
            if ([waitingEvent type] == NSLeftMouseUp) {
                break;
            }
        }
    }
}

@end
