//
//  HMInfoBarButton.m
//  HMInfoBar
//
//  Created by MIURA Kazki on 10.04.06.
//  Copyright 2006 MIURA Kazki. All rights reserved.
//

#import <HMDTFoundation/HMDTFoundation.h>

#import "HMInfoBarButtonCell.h"
#import "HMInfoBarButton.h"


@implementation HMInfoBarButton

+ (Class)cellClass
{
	return [HMInfoBarButtonCell class];
}

//--------------------------------------------------------------//
#pragma mark	Creating
//--------------------------------------------------------------//

+ (id)idealButtonForTitle:(NSString*)title
{
	// Make a cell
	id cell;
	cell = [[[[self cellClass] alloc] init] autorelease];
	if (!cell) {
		return nil;
	}
	
	// Set title
	NSString *string;
	if (title) {
		string = title;
	}
	else {
		string = @"Button";
	}
	[cell setTitle:string];
	
	// Get cell size
	NSSize cellSize;
	cellSize = [cell cellSize];
	
	// Make a button
	id button;
	button = [[self alloc] initWithFrame:HMMakeRect(NSZeroPoint, cellSize)];
	[button setCell:cell];
	
	return [button autorelease];
}

- (id)initWithFrame:(NSRect)frame
{
	if (self = [super initWithFrame:frame]) {
		// Initialize
		[self setPostsBoundsChangedNotifications:NO];
		[self setPostsFrameChangedNotifications:NO];
	}
	
	return self;
}

//--------------------------------------------------------------//
#pragma mark	Size
//--------------------------------------------------------------//

- (NSSize)maxSize
{
	// Invoke cell's method
	return [(HMInfoBarButtonCell*)[self cell] maxSize];
}

- (NSSize)minSize
{
	// Invoke cell's method
	return [(HMInfoBarButtonCell*)[self cell] minSize];
}

//--------------------------------------------------------------//
#pragma mark	Appearance
//--------------------------------------------------------------//

- (void)setBackgroundLeftImage:(NSImage*)leftImage
		middleImage:(NSImage*)middleImage
		rightImage:(NSImage*)rightImage
{
	// Invoke cell's method
	[(HMInfoBarButtonCell*)[self cell]
		setBackgroundLeftImage:leftImage
		middleImage:middleImage
		rightImage:rightImage];
}

//--------------------------------------------------------------//
#pragma mark	Util
//--------------------------------------------------------------//

- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent
{
	return YES;
}

- (BOOL)isFlipped
{
	return NO;
}

- (void)setFrame:(NSRect)frame
{
	// Set frame
	[super setFrame:frame];
	
	// Tooltip
	if ([self bounds].size.width < [[self cell] cellSize].width) {
		[self setToolTip:[[self cell] title]];
	}
	else {
		[self setToolTip:@""];
	}
}

- (void)setAlternateTitle:(NSString*)altTitle
{
	// Deny
	[self doesNotRecognizeSelector:_cmd];
}

- (void)setAttributedAlternateTitle:(NSAttributedString*)attrStr
{
	// Deny
	[self doesNotRecognizeSelector:_cmd];
}

- (void)setCell:(NSCell*)cell
{
	[super setCell:cell];
	[[self cell] setShowsBorderOnlyWhileMouseInside:YES];
}

- (void)viewDidMoveToSuperview
{
	[[self cell] setShowsBorderOnlyWhileMouseInside:YES];
}

@end
