/*
SRPrefBackForwardToolbaarItem.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRPrefController.h"
#import "SRPrefBackForwardToolbarItem.h"

@implementation SRPrefBackForwardToolbaarItem

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (id)initWithItemIdentifier:(NSString*)itemIdentifier
{
    self = [super initWithItemIdentifier:itemIdentifier];
    if (!self) {
        return nil;
    }
    
    // Create buttons
    NSImage*    image;
    NSImage*    altImage;
    NSRect      rect;
    image = [NSImage imageNamed:@"PrefBack"];
    altImage = [NSImage imageNamed:@"PrefBackSelected"];
    
    rect.origin = NSZeroPoint;
    rect.size = [image size];
    _backButton = [[NSButton alloc] initWithFrame:rect];
    [_backButton setBordered:NO];
    [_backButton setBezelStyle:NSRegularSquareBezelStyle];
    [_backButton setButtonType:NSMomentaryChangeButton];
    [_backButton setImage:image];
    [_backButton setAlternateImage:altImage];
    
    image = [NSImage imageNamed:@"PrefForward"];
    altImage = [NSImage imageNamed:@"PrefForwardSelected"];
    
    rect.origin.x += rect.size.width;
    rect.size = [image size];
    _forwardButton = [[NSButton alloc] initWithFrame:rect];
    [_forwardButton setBordered:NO];
    [_forwardButton setBezelStyle:NSRegularSquareBezelStyle];
    [_forwardButton setButtonType:NSMomentaryChangeButton];
    [_forwardButton setImage:image];
    [_forwardButton setAlternateImage:altImage];
    
    NSView* view;
    rect.size.width *= 2;
    view = [[NSView alloc] initWithFrame:rect];
    [view addSubview:_backButton];
    [view addSubview:_forwardButton];
    [self setView:view];
    
    return self;
}

- (void)dealloc
{
    [_backButton release];
    [_forwardButton release];
    
    [super dealloc];
}

//--------------------------------------------------------------//
#pragma mark -- Toolbar item attributes --
//--------------------------------------------------------------//

- (NSSize)minSize
{
    NSSize  size;
    size = [_backButton frame].size;
    size.width += [_forwardButton frame].size.width;
    return size;
}

- (NSSize)maxSize
{
    return [self minSize];
}

//--------------------------------------------------------------//
#pragma mark -- Toolbar item validation --
//--------------------------------------------------------------//

- (void)validate
{
    // Get pref controller
    SRPrefController*   prefController;
    prefController = [[self toolbar] delegate];
    if (!prefController) {
        return;
    }
    
    // Get back forward list
    NSArray*    list;
    int         index;
    list = [prefController backForwardList];
    index = [prefController currentBackForwardIndex];
    
    // When there is 0 or 1 item
    if ([list count] < 2) {
        [_backButton setEnabled:NO];
        [_forwardButton setEnabled:NO];
        return;
    }
    
    // update button availability
    [_backButton setEnabled:index > 0];
    [_forwardButton setEnabled:index < [list count] - 1];
    
    // Update button target and action
    if (![_backButton target]) {
        [_backButton setTarget:prefController];
        [_backButton setAction:@selector(goBackAction:)];
    }
    if (![_forwardButton target]) {
        [_forwardButton setTarget:prefController];
        [_forwardButton setAction:@selector(goForwardAction:)];
    }
}

@end
