/*
HMBrowser.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "HMBrowser.h"
#import "HMBrowserCell.h"

@implementation HMBrowser

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

+ (Class)cellClass
{
    return [HMBrowserCell class];
}

- (void)_init
{
    // Get old prototype
    id  oldPrototype;
    oldPrototype = [self cellPrototype];
    
    // Set cell class
    [self setCellClass:[[self class] cellClass]];
    
    // Update prototype
    id  prototype;
    prototype = [self cellPrototype];
    [prototype setFont:[oldPrototype font]];
    [self setCellPrototype:prototype];
}

- (id)initWithCoder:(NSCoder*)coder
{
    self = [super initWithCoder:coder];
    if (!self) {
        return nil;
    }
    
    // Common init
    [self _init];
    
    return self;
}

//--------------------------------------------------------------//
#pragma mark -- Event handling --
//--------------------------------------------------------------//

- (void)_makeSelectedMatrixFirstResponder
{
    // Get matrix in selected column
    NSMatrix*   matrix;
    matrix = [self matrixInColumn:[self selectedColumn]];
    if (matrix) {
        // Check first responder
        NSWindow*   window;
        window = [self window];
        if ([window firstResponder] != matrix) {
            // Make it first responder
            [window makeFirstResponder:matrix];
        }
    }
}

- (void)mouseDown:(NSEvent*)event
{
    // Get mouse location
    NSPoint mouseLocation;
    mouseLocation = [self convertPoint:[event locationInWindow] fromView:nil];
    
    // Get matrix under mouse
    NSMatrix*   matrix = nil;
    int         columnOfMatrix;
    for (columnOfMatrix = [self firstVisibleColumn]; 
         columnOfMatrix <= [self lastVisibleColumn]; 
         columnOfMatrix++)
    {
        // Get matrix
        matrix = [self matrixInColumn:columnOfMatrix];
        if (!matrix) {
            continue;
        }
        
        // Convert mouse location
        NSPoint point;
        point = [matrix convertPoint:[event locationInWindow] fromView:nil];
        
        // Chexk x-axis of mouse location
        NSRect  frame;
        frame = [matrix frame];
        if (point.x > frame.origin.x && point.x < frame.origin.x + frame.size.width) {
            break;
        }
        
        matrix = nil;
    }
    if (!matrix) {
        [super mouseDown:event];
        return;
    }
    
    // When mouse point is not in matrix frame, user selects empty region
    int row, col;
    if (![matrix getRow:&row column:&col forPoint:
            [matrix convertPoint:[event locationInWindow] fromView:nil]])
    {
        // Get path to previous column
        NSString*   path;

        if (columnOfMatrix == 0) {
            path = [self pathSeparator];
        }
        else {
            path = [self pathToColumn:columnOfMatrix];
        }
        
        // Set path to previous column
        if (path) {
            [self setPath:path];
            [self _makeSelectedMatrixFirstResponder];
            
            // Send action
            SEL action;
            action = [self action];
            if (action) {
                [[self target] performSelector:action withObject:self];
            }
        }
        
        return;
    }
    
    [super mouseDown:event];
}

- (void)doClick:(id)sender
{
    // Notify to delegate
    id  delegate;
    delegate = [self delegate];
    if (delegate && [delegate respondsToSelector:@selector(browserWillSelect:)]) {
        [delegate browserWillSelect:self];
    }
    
    [self _makeSelectedMatrixFirstResponder];
    
    [super doClick:sender];
}

@end
