/*
SRPersonInfo.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRPersonInfo.h"

@implementation SRPersonInfo

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (id)initWithPerson:(ABPerson*)person
{
    self = [super init];
    if (!self) {
        return nil;
    }
    
    // Initialize instance variables
    _person = [person retain];
    
    return self;
}

- (void)dealloc
{
    [_person release];
    
    [super dealloc];
}

//--------------------------------------------------------------//
#pragma mark -- Accessors --
//--------------------------------------------------------------//

- (NSString*)name
{
    if (!_person) {
        return nil;
    }
    
    // Get person name
    NSString*   firstName;
    NSString*   middleName;
    NSString*   lastName;
    firstName = [_person valueForProperty:kABFirstNameProperty];
    middleName = [_person valueForProperty:kABMiddleNameProperty];
    lastName = [_person valueForProperty:kABLastNameProperty];
    
    // Get company name
    NSString*   companyName;
    companyName = [_person valueForProperty:kABOrganizationProperty];
    
    // Get person flags
    unsigned int    flags;
    flags = [[_person valueForProperty:kABPersonFlags] unsignedIntValue];
    
    // For person
    if ((flags & kABShowAsMask) == kABShowAsPerson) {
        int nameOrdering;
        if ((flags & kABNameOrderingMask) == kABDefaultNameOrdering) {
            nameOrdering = [[ABAddressBook sharedAddressBook] defaultNameOrdering];
        }
        else {
            nameOrdering = flags & kABNameOrderingMask;
        }
        
        // Create name
        NSMutableString*    name;
        name = [NSMutableString string];
        if (nameOrdering == kABFirstNameFirst) {
            if (firstName) [name appendFormat:@"%@ ", firstName];
            if (middleName) [name appendFormat:@"%@ ", middleName];
            if (lastName) [name appendFormat:@"%@ ", lastName];
        }
        else {
            if (lastName) [name appendFormat:@"%@ ", lastName];
            if (middleName) [name appendFormat:@"%@ ", middleName];
            if (firstName) [name appendFormat:@"%@ ", firstName];
        }
        
        // Use company name
        if ([name length] == 0) {
            if (companyName) {
                [name appendString:companyName];
            }
        }
        
        if ([name length] > 0) {
            return [name stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
        }
    }
    // For company
    else if ((flags & kABShowAsMask) == kABShowAsCompany) {
        if (companyName) {
            return companyName;
        }
    }
    
    return nil;
}

- (NSString*)phonetic
{
    return @"";
}

- (NSString*)organization
{
    return @"";
}

- (NSString*)urlString
{
    // Get URL
    ABMultiValue*   URLs;
    URLs = [_person valueForProperty:kABURLsProperty];
    if (!URLs) {
        return nil;
    }
    
    return [URLs valueAtIndex:[URLs indexForIdentifier:[URLs primaryIdentifier]]];
}

- (NSImage*)image
{
    return nil;
}

@end
