/*
SRPreference.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRPreference.h"

// Default web preferences identifier
NSString*   SRWebPreferencesIdentifier = @"ShiiraPreferences";

@implementation SRPreference

//--------------------------------------------------------------//
#pragma mark -- Web preferences --
//--------------------------------------------------------------//

+ (WebPreferences*)webPreferences;
{
    // Default web preferences
    static WebPreferences*  _webPreferences = nil;
    
    if (!_webPreferences) {
        // Create default web preferences
        _webPreferences = [[WebPreferences alloc] 
                initWithIdentifier:SRWebPreferencesIdentifier];
        [_webPreferences setAutosaves:YES];
    }
    
    return _webPreferences;
}

- (WebPreferences*)webPreferences
{
    return [[self class] webPreferences];
}

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (id)initWithBundle:(NSBundle*)bundle
{
    self = [super init];
    if (!self) {
        return nil;
    }
    
    // Load main nib
    NSString*   nibFile;
    nibFile = [[bundle infoDictionary] objectForKey:@"SRPrefPanelNibFile"];
    if (nibFile) {
        if (![NSBundle loadNibNamed:nibFile owner:self]) {
            // Error
            NSLog(@"Failed to load nib file, %@", nibFile);
        }
    }
    
    // Initialize instance variables
    _bundle = [bundle retain];
    
    return self;
}

- (void)didLoad
{
    // Subclass overrides
}

- (void)dealloc
{
    [_bundle release];
    
    [super dealloc];
}

//--------------------------------------------------------------//
#pragma mark -- Controller --
//--------------------------------------------------------------//

- (id<SRAppController>)appController
{
    return _appController;
}

- (void)setAppController:(id<SRAppController>)appController
{
    _appController = appController;
}

- (id<SRBookmarkFactory>)bookmarkFactory
{
    return _bookmarkFactory;
}

- (void)setBookmarkFactory:(id<SRBookmarkFactory>)bookmarkFactory
{
    _bookmarkFactory = bookmarkFactory;
}

- (id<SRWebHistory>)webHistory
{
    return _webHistory;
}

- (void)setWebHistory:(id<SRWebHistory>)webHistory
{
    _webHistory = webHistory;
}

//--------------------------------------------------------------//
#pragma mark -- Accessing to view --
//--------------------------------------------------------------//

- (NSView*)mainView
{
    return _mainView;
}

//--------------------------------------------------------------//
#pragma mark -- Accessors --
//--------------------------------------------------------------//

- (NSString*)title
{
    NSString*   label;
    label = [_bundle localizedStringForKey:@"SRPrefPanelIconLabel" value:nil table:@"InfoPlist"];
    if (!label || [label isEqualToString:@"SRPrefPanelIconLabel"]) {
        label = [[_bundle infoDictionary] objectForKey:@"SRPrefPanelIconLabel"];
    }
    
    return label;
}

@end
