/*
SRPlugInController.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRAppController.h"
#import "SRPlugInController.h"

// Support file name
NSString*   SRPlugInsDirectoryName = @"Shiira Plug-Ins";

@implementation SRPlugInController

//--------------------------------------------------------------//
#pragma -- Plug-in path --
//--------------------------------------------------------------//

+ (NSString*)buildInPlugInPath
{
    NSString*   dirPath;
    dirPath = [[NSBundle mainBundle] builtInPlugInsPath];
    dirPath = [dirPath stringByAppendingPathComponent:SRPlugInsDirectoryName];
    
    return dirPath;
}

+ (NSString*)userPlugInPath
{
    NSString*   dirPath;
    dirPath = HMApplicationSupportFolder(@"Shiira");
    dirPath = [dirPath stringByAppendingPathComponent:SRPlugInsDirectoryName];
    
    return dirPath;
}

//--------------------------------------------------------------//
#pragma -- Initialize --
//--------------------------------------------------------------//

+ (SRPlugInController*)sharedInstance
{
    static SRPlugInController*  _sharedInstance = nil;
    if (!_sharedInstance) {
        _sharedInstance = [[SRPlugInController alloc] init];
    }
    
    return _sharedInstance;
}

//--------------------------------------------------------------//
#pragma -- Shiira plug in --
//--------------------------------------------------------------//

- (void)_loadShiiraPlugInsAtDirectory:(NSString*)dirPath
{
    // Check existense
    NSFileManager*	fileMgr;
    BOOL            isDir;
    fileMgr = [NSFileManager defaultManager];
    if (![fileMgr fileExistsAtPath:dirPath isDirectory:&isDir] || !isDir) {
        return;
    }
    
    // Load plug-ins
    NSEnumerator*   enumerator;
    NSString*       dirContent;
    enumerator = [[fileMgr directoryContentsAtPath:dirPath] objectEnumerator];
    while (dirContent = [enumerator nextObject]) {
        // Check extension
        NSString*   path;
        path = [dirPath stringByAppendingPathComponent:dirContent];
        if (![[path pathExtension] isEqualToString:@"plugin"]) {
            continue;
        }
        
        // Load bundle
        NSBundle*   bundle;
        bundle = [[NSBundle alloc] initWithPath:path];
        if (![bundle load]) {
            // Error
            NSLog(@"Faield to load bundle, %@", path);
        }
        [bundle release];
    }
}

- (void)loadShiiraPlugIns
{
    // Find in main bundle
    NSString*   dirPath;
    dirPath = [[self class] buildInPlugInPath];
    [self _loadShiiraPlugInsAtDirectory:dirPath];
    
    // Create path ~/Library/Application Support/Shiira/Shiira Plug-Ins
    dirPath = [[self class] userPlugInPath];
    [self _loadShiiraPlugInsAtDirectory:dirPath];
}

@end
