/*
SRRSSRepresentation.m

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRRSSView.h"
#import "SRRSSRepresentation.h"

#import "AppKitEx.h"

@implementation SRRSSRepresentation

#ifdef SR_SUPPORT_RSS
+ (void)load
{
    NSAutoreleasePool*  pool;
    pool = [[NSAutoreleasePool alloc] init];
    
    // Register itself
    NSArray*        RSSMimes;
    NSEnumerator*   enumerator;
    NSString*       MIMEType;
    RSSMimes = [self RSSMimes];
    enumerator = [RSSMimes objectEnumerator];
    while (MIMEType = [enumerator nextObject]) {
        [WebView registerViewClass:NSClassFromString(@"SRRSSView") 
                representationClass:NSClassFromString(@"SRRSSRepresentation") 
                forMIMEType:MIMEType];
    }
    
    [pool release];
}
#endif // SR_SUPPORT_RSS

+ (NSArray*)RSSMimes
{
    static NSArray* _RSSMimes = nil;
    if (!_RSSMimes) {
        _RSSMimes = [[NSArray arrayWithObjects:
                @"text/xml", 
                @"application/xml", 
                @"application/xhtml+xml", 
                @"application/rss+xml", 
                @"application/rdf+xml", 
                @"application/atom+xml", 
                nil] retain];
    }
    
    return _RSSMimes;
}

//--------------------------------------------------------------//
#pragma mark -- RSS view --
//--------------------------------------------------------------//

- (SRRSSView*)RSSView
{
    return (SRRSSView*)[[[_dataSource webFrame] frameView] documentView];
}

//--------------------------------------------------------------//
#pragma mark -- WebDocumentRepresentation protocol --
//--------------------------------------------------------------//

- (void)setDataSource:(WebDataSource*)dataSource
{
    _dataSource = dataSource;
}

- (void)receivedData:(NSData*)data withDataSource:(WebDataSource*)dataSource
{
    _dataSource = dataSource;
}

- (void)receivedError:(NSError*)error withDataSource:(WebDataSource*)dataSource
{
    _dataSource = dataSource;
}

- (void)finishedLoadingWithDataSource:(WebDataSource*)dataSource
{
    _dataSource = dataSource;
    
    // Update RSS view
    [[self RSSView] updateRSS];
}

- (BOOL)canProvideDocumentSource
{
    return NO;
}

- (NSString*)documentSource
{
    return nil;
}

- (NSString*)title
{
    if (_dataSource && ![_dataSource isLoading]) {
        // Get RSS data
        NSData* data;
        data = [_dataSource data];
        
        // Create XML document
        SRXMLDocument*  document;
        NSError*        error;
        document = [[NSClassFromString(@"SRXMLDocument") alloc] initWithData:data options:0 error:&error];
        if (!document) {
            // Error
            NSLog([error localizedDescription]);
        }
        else {
            // Get title by XPath
            NSArray*    array;
            array = [document nodesForXPath:@"/rss/channel/title" error:NULL];
            if (!array || [array count] == 0) {
                // Check prefix of root element
                SRXMLElement*   rootElement;
                NSString*       prefix;
                rootElement = (SRXMLElement*)[document rootElement];
                prefix = [rootElement prefix];
                if (prefix && [prefix isEqualToString:@"rdf"]) {
                    array = [document nodesForXPath:@"/rdf:RDF/channel/title" error:NULL];
                }
            }
            if (!array || [array count] == 0) {
                array = [document nodesForXPath:@"/feed/title" error:NULL];
            }
            if (array && [array count] > 0) {
                NSString*   title;
                title = [[array objectAtIndex:0] stringValue];
                if (title && [title length] > 0) {
                    return title;
                }
            }
        }
    }
    
    return @"RSS";
}

@end
