/*
SRSBSRRController.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "SRError.h"

typedef enum _SRRSSDetail {
    SRRSSChannelDetail = 0, 
} SRRSSDetail;

typedef enum _SRRSSStyle {
    SRRSSFlatStyle = 0, 
    SRRSSWebSiteStyle, 
    SRRSSCategoryStyle, 
} SRRSSStyle;

@class SRMainWindowController;
@class SRSideBarController;
@class SRSDRSSDocument;

@interface SRSBRSSController : NSResponder
{
    SRMainWindowController* _mainWindowController;
    SRSideBarController*    _sideBarController;
    
    NSArray*                _findResults;
    
    NSMutableArray*         _channels;
    NSMutableArray*         _items;
    
    NSMutableArray*         _history;
    NSString*               _currentURLString;
    
    SRRSSStyle              _style;
    
    IBOutlet id _RSSView;
    IBOutlet id _searchField;
    IBOutlet id _RSSTab;
    IBOutlet id _RSSOutline;
    IBOutlet id _findTable;
    IBOutlet id _detailView;
    
    IBOutlet id _controller;
    IBOutlet id _content;
    
    IBOutlet id _channelView;
    IBOutlet id _channelWebView;
}

// Initialize
- (id)initWithMainWindowController:(SRMainWindowController*)mainWindowController 
        sideBarController:(SRSideBarController*)sideBarController;

// Controller
- (SRMainWindowController*)mainWindowController;
- (void)setMainWindowController:(SRMainWindowController*)mainWindowController;
- (SRSideBarController*)sideBarController;
- (void)setSidebarController:(SRSideBarController*)sideBarController;

// View
- (NSView*)view;

// Detail view
- (void)setDetailView:(SRRSSDetail)type;

// RSS
- (NSArray*)selectedItems;

@end
