/*
SRTabExpose.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "SRError.h"

@class SRTabExposeController;

@interface SRTabExposeCoverView : NSView
{
    SRTabExposeController*  _tabExposeController;
    WebView*                _webView;
}

// Controller
- (SRTabExposeController*)tabExposeController;
- (void)setTabExposeController:(SRTabExposeController*)tabExposeController;

// Web view
- (WebView*)webView;
- (void)setWebView:(WebView*)webView;

@end

enum {
    SRTabExposeViewAbove = 0, 
    SRTabExposeViewBelow, 
};

@interface SRTabExposeView : NSView
{
    SRTabExposeController*  _tabExposeController;
    
    int                     _type;
    float                   _opacity;
}

// Initialize
- (id)initWithFrame:(NSRect)frame type:(int)type;

// Controller
- (SRTabExposeController*)tabExposeController;
- (void)setTabExposeController:(SRTabExposeController*)tabExposeController;

// Opacity
- (float)opacity;
- (void)setOpacity:(float)opacity;

@end

@interface SRTabExposeWindow : NSWindow
{
}
@end

@class SRTabView;

enum {
    SRTabExposeExposingIn = 0, 
    SRTabExposeExposing, 
    SRTabExposeExposingOut, 
    SRTabExposeDeexpose, 
};

@interface SRTabExposeController : NSObject
{
    SRTabExposeWindow*  _windowAbove;
    SRTabExposeWindow*  _windowBelow;
    SRTabExposeView*    _viewAbove;
    SRTabExposeView*    _viewBelow;
    
    SRTabView*          _tabView;
    NSMutableArray*     _windows;
    NSMutableArray*     _currentFrames;
    NSMutableArray*     _finalFrames;
    
    NSTimer*            _timer;
    NSRect              _origFrame;
    int                 _exposeState;
    NSTimeInterval      _duration;
    float               _value;
    float               _rate;
    WebView*            _selectedWebView;
}

// Expose
+ (BOOL)isExposing;
- (void)startExposingIn;
- (void)startExposingOut;
- (float)value;
- (NSArray*)currentFrames;

- (void)exposeWithTabView:(SRTabView*)tabView;
- (void)deexpose;
- (void)deexposeAndSelectWebViewAtIndex:(int)index;
- (void)deexposeAndSelectWebView:(WebView*)selectedWebView;

@end
