/*
SRSearchFieldController.h

Author: Hiroyuki Yamashita, Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "SRError.h"

extern NSString*    SRSearchEngineChanged;

// Search field menu tags
enum {
    SRSearchMenuTag = 8000, 
    SRSearchEngineTag = 8001, 
    SRRecentSerachItemTag = 8002, 
};

@class SRMainWindowController;
@class SRSearchField;

@interface SRSearchFieldController : NSObject
{
    SRMainWindowController* _mainWindowController;
    
    SRSearchField*          _searchField;
    NSDictionary*           _currentEngine;
}

// Initialize
- (id)initWithMainWindowController:(SRMainWindowController*)mainWindowController;

// Main window controller
- (SRMainWindowController*)mainWindowController;
- (void)setMainWindowController:(SRMainWindowController*)mainWindowController;

// Accessors
- (SRSearchField*)searchField;
- (void)setSearchField:(SRSearchField*)searchField;
- (NSDictionary*)currentEngine;
- (NSString*)currentEngineName;
- (void)updateCurrentEngine:(NSDictionary*)candidateEngine;

// Actions
- (void)searchAction:(id)sender;
- (void)directSearchAction:(id)sender;
- (void)searchRecentItemAction:(id)sender;
- (void)selectEngineAction:(id)sender;

@end

// Utility
NSString* SRCreateSearchURLStringFromSearchEngine(
        NSString* searchString, 
        NSDictionary* engine);
