/*
SRDownloadInfoItem.m

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRDownloadInfoItem.h"

static NSString*    _SRDownloadRequest = @"SRDownloadRequest";
static NSString*    _SRDownloadResponse = @"SRDownloadResponse";
static NSString*    _SRDownloadedFilePath = @"SRDownloadedFilePath";
static NSString*    _SRFilePathForResume = @"SRFilePathForResume";
static NSString*    _SRDownloadExpectedLength = @"SRDownloadExpectedLength";
static NSString*    _SRDownloadedLength = @"SRDownloadedLength";
static NSString*    _SRDownlaodStartTime = @"SRDownlaodStartTime";
static NSString*    _SRDownlaodProgress = @"SRDownlaodProgress";
static NSString*    _SRDownlaodIcon = @"SRDownlaodIcon";
static NSString*    _SRResumeInfo = @"SRResumeInfo";
static NSString*    _SRStatus = @"SRStatus";

@implementation SRDownloadInfoItem

#pragma mark -
//--------------------------------------------------------------//
// Initialize
//--------------------------------------------------------------//

- (id)init
{
    self = [super init];
    if (self) {
        // Initialize instance variables
        _infoDict = [[NSMutableDictionary dictionary] retain];
        
        [self setExpectedLength:-1];
        [self setDownloadedLength:0];
        [self setStatus:SRDownloadStatusUnknown];
    }
    
    return self;
}

- (id)copyWithZone:(NSZone*)zone
{
    SRDownloadInfoItem* item;
    item = [[SRDownloadInfoItem alloc] init];
    [item->_infoDict release];
    item->_infoDict = [_infoDict retain];
    
    return item;
}

- (void)dealloc
{
    [_infoDict release];
    [super dealloc];
}

#pragma mark -
//--------------------------------------------------------------//
// Attributes
//--------------------------------------------------------------//

- (NSURLRequest*)request
{
    return [_infoDict objectForKey:_SRDownloadRequest];
}

- (void)setRequest:(NSURLRequest*)request
{
    if (!request) {
        return;
    }
    
    [_infoDict setObject:request forKey:_SRDownloadRequest];
}

- (NSURLResponse*)response
{
    return [_infoDict objectForKey:_SRDownloadResponse];
}

- (void)setResponse:(NSURLResponse*)response
{
    if (!response) {
        return;
    }
    
    [_infoDict setObject:response forKey:_SRDownloadResponse];
}

- (NSString*)downloadedFilePath
{
    return [_infoDict objectForKey:_SRDownloadedFilePath];
}

- (void)setDownloadedFilePath:(NSString*)filePath
{
    if (!filePath) {
        return;
    }
    
    [_infoDict setObject:filePath forKey:_SRDownloadedFilePath];
}

- (NSString*)filePathForResume
{
    return [_infoDict objectForKey:_SRFilePathForResume];
}

- (void)setFilePathForResume:(NSString*)filePath
{
    if (!filePath) {
        return;
    }
    
    [_infoDict setObject:filePath forKey:_SRFilePathForResume];
}

- (long long)expectedLength
{
    return [[_infoDict objectForKey:_SRDownloadExpectedLength] longLongValue];
}

- (void)setExpectedLength:(long long)length
{
    [_infoDict setObject:[NSNumber numberWithLongLong:length] 
            forKey:_SRDownloadExpectedLength];
}

- (long long)downloadedLength
{
    return [[_infoDict objectForKey:_SRDownloadedLength] longLongValue];
}

- (void)setDownloadedLength:(long long)length
{
    [_infoDict setObject:[NSNumber numberWithLongLong:length] 
            forKey:_SRDownloadedLength];
}

- (void)increaseDownloadedLength:(long long)length
{
    // Get downloaded length
    long long   downloadedLength;
    downloadedLength = [self downloadedLength];
    
    // Increase length
    [self setDownloadedLength:downloadedLength + length];
}

- (NSDate*)startTime
{
    return [_infoDict objectForKey:_SRDownlaodStartTime];
}

- (void)setStartTime:(NSDate*)date
{
    if (!date) {
        return;
    }
    
    [_infoDict setObject:date forKey:_SRDownlaodStartTime];
}

- (NSProgressIndicator*)progressIndicator
{
    return [_infoDict objectForKey:_SRDownlaodProgress];
}

- (void)setProgressIndicator:(NSProgressIndicator*)progressIndicator
{
    if (!progressIndicator) {
        return;
    }
    
    [_infoDict setObject:progressIndicator forKey:_SRDownlaodProgress];
}

- (NSImage*)icon
{
    return [_infoDict objectForKey:_SRDownlaodIcon];
}

- (void)setIcon:(NSImage*)icon
{
    if (!icon) {
        return;
    }
    
    [_infoDict setObject:icon forKey:_SRDownlaodIcon];
}

- (NSDictionary*)resumeInfo
{
    return [_infoDict objectForKey:_SRResumeInfo];
}

- (void)setResumeInfo:(NSDictionary*)resumeInfo
{
    if (!resumeInfo) {
        return;
    }
    
    [_infoDict setObject:resumeInfo forKey:_SRResumeInfo];
}

#pragma mark -
//--------------------------------------------------------------//
// Status
//--------------------------------------------------------------//

- (SRDownloadItemStatus)status
{
    NSNumber*   number;
    number = [_infoDict objectForKey:_SRStatus];
    if (!number) {
        return SRDownloadStatusUnknown;
    }
    
    return [number intValue];
}

- (void)setStatus:(SRDownloadItemStatus)status
{
    [_infoDict setObject:[NSNumber numberWithInt:status] forKey:_SRStatus];
}

- (void)resetLength
{
    [self setExpectedLength:-1];
    [self setDownloadedLength:0];
    [[self progressIndicator] setDoubleValue:0.0];
}

@end
