﻿// <file>
//     <copyright see="prj:///doc/copyright.txt"/>
//     <license see="prj:///doc/license.txt"/>
//     <owner name="Matthew Ward" email="mrward@users.sourceforge.net"/>
//     <version>$Revision: 1698 $</version>
// </file>

using System;
using System.IO;
using System.Xml;

namespace ICSharpCode.WixBinding
{
	public class WixBinaryElement : XmlElement
	{
		public const string BinaryElementName = "Binary";
		
		public WixBinaryElement(WixDocument document) 
			: base(document.WixNamespacePrefix, BinaryElementName, WixNamespaceManager.Namespace, document)
		{
		}
		
		public string Id {
			get {
				return GetAttribute("Id");
			}
			set {
				SetAttribute("Id", value);
			}
		}
		
		public string Source {
			get {
				if (HasAttribute("SourceFile")) {
					return GetAttribute("SourceFile");
				} 
				return GetAttribute("src");
			}
		}
		
		/// <summary>
		/// Gets the full filename including the root directory path to this binary.
		/// </summary>
		/// <remarks>
		/// The full path is generated by using the WixDocument's filename.
		/// </remarks>
		public string FileName {
			get {
				WixDocument document = (WixDocument)OwnerDocument;
				string binaryFileName = WixPropertyParser.Parse(Source, document);
				
				// If we have the Wix document filename return the full filename.
				string documentFileName = document.FileName;
				if (documentFileName.Length > 0) {
					return Path.Combine(Path.GetDirectoryName(documentFileName), binaryFileName);
				}
				return binaryFileName;
			}
		}
	}
}
