package sharin.csv.parser;

import java.io.Reader;

import sharin.util.IoUtils;

public class BasicCsvPushParser implements CsvPushParser {

    private final char separator;

    public BasicCsvPushParser() {
        this(',');
    }

    public BasicCsvPushParser(char separator) {
        this.separator = separator;
    }

    public String[][] parseAll(Reader reader) {
        BasicCsvHandler handler = new BasicCsvHandler();
        parse(reader, handler);
        return handler.getRecords();
    }

    public void parse(Reader reader, CsvHandler handler) {
        BasicCsvAutomaton automaton = new BasicCsvAutomaton(handler, separator);
        int ch = 0;

        while (ch != -1) {
            ch = IoUtils.read(reader);
            automaton.put(ch);
        }
    }
}
