/*
 *  linux/drivers/video/sh7785fb.h SH7785/SH7786 Display Unit frame buffer driver
 *
 *     Copyright (C) 2010 ALPHAPROJECT Co.,Ltd. 
 *     Copyright (C) 2002 Lineo Solutions, Inc.
 *
 *  This file is subject to the terms and conditions of the GNU General Public
 *  License. See the file COPYING in the main directory of this archive for
 *  more details.
 *
 * 0.01
 *  - initial beta version (ks)
 */


#if defined(CONFIG_SH_APSH4A3A)

/* ɽץ졼 */
#define SH7785FB_BASE_PLANE	0

/*  */
#define SH7785FB_VRAM_TOP	0xAF000000		/* VRAMƬɥ쥹 */


/*  */
#define V_XRES			800
#define V_YRES			600
#define XRES			800
#define YRES			600
#define BPP			16
#define BPP_BYTE		(BPP/8)

/* ɽߥ */
#define FREQ_SELECT		0x00100003
#define DOT_CLOCK		25000
#define H_SYNC_W		69
#define H_BPORCH		60
#define H_FPORCH		60
#define V_SYNC_W		6
#define V_BPORCH		20
#define V_FPORCH		6

#define HDS(hsw,xs)		(hsw + xs - 19)
#define HDE(hsw,xs,xres)	(hsw + xs - 19 + xres)
#define VDS(ys)			(ys - 2)
#define VDE(ys,yres)		(ys - 2 + yres)
#define HSW(hsw)		(hsw - 1)
#define HC(hsw,xs,xres,hf)	(hsw + xs + xres + hf - 1)
#define VC(vsw,ys,yres,vf)	(vsw + ys + yres + vf - 1)
#define VSP(ys,yres,vf)		(ys + yres + vf- 1)		/* vc - vsw -1 */
#define DES(hsw,xs)		(hsw + xs - 1)
#define DEW(xres)		(xres)


#elif defined(CONFIG_SH_APSH4AD0A)

/* ɽץ졼 */
#define SH7785FB_BASE_PLANE	0

/*  */
#define SH7785FB_VRAM_TOP	0xB4000000		/* VRAMƬɥ쥹 */

/*  */
#define V_XRES			1024
#define V_YRES			768
#define XRES			1024
#define YRES			768
#define BPP			16
#define BPP_BYTE		(BPP/8)

/* ɽߥ */
#define FREQ_SELECT		0x00100003
#define DOT_CLOCK		66666
#define H_SYNC_W		140
#define H_BPORCH		160
#define H_FPORCH		64
#define V_SYNC_W		6
#define V_BPORCH		20
#define V_FPORCH		6

#define HDS(hsw,xs)		(hsw + xs - 19)
#define HDE(hsw,xs,xres)	(hsw + xs - 19 + xres)
#define VDS(ys)			(ys - 2)
#define VDE(ys,yres)		(ys - 2 + yres)
#define HSW(hsw)		(hsw - 1)
#define HC(hsw,xs,xres,hf)	(hsw + xs + xres + hf - 1)
#define VC(vsw,ys,yres,vf)	(vsw + ys + yres + vf - 1)
#define VSP(ys,yres,vf)		(ys + yres + vf- 1)		/* vc - vsw -1 */
#define DES(hsw,xs)		(hsw + xs - 1)
#define DEW(xres)		(xres)

#else	/* ǥե */

/* ɽץ졼 */
#define SH7785FB_BASE_PLANE	0

/*  */
#define SH7785FB_VRAM_TOP	0xAF900000		/* VRAMƬɥ쥹 */

/*  */
#define V_XRES			800
#define V_YRES			600
#define XRES			800
#define YRES			600
#define BPP			16
#define BPP_BYTE		(BPP/8)

/* ɽߥ */
#define FREQ_SELECT		0x00100003
#define DOT_CLOCK		25000
#define H_SYNC_W		69
#define H_BPORCH		60
#define H_FPORCH		60
#define V_SYNC_W		6
#define V_BPORCH		20
#define V_FPORCH		6

#define HDS(hsw,xs)		(hsw + xs - 19)
#define HDE(hsw,xs,xres)	(hsw + xs - 19 + xres)
#define VDS(ys)			(ys - 2)
#define VDE(ys,yres)		(ys - 2 + yres)
#define HSW(hsw)		(hsw - 1)
#define HC(hsw,xs,xres,hf)	(hsw + xs + xres + hf - 1)
#define VC(vsw,ys,yres,vf)	(vsw + ys + yres + vf - 1)
#define VSP(ys,yres,vf)		(ys + yres + vf- 1)		/* vc - vsw -1 */
#define DES(hsw,xs)		(hsw + xs - 1)
#define DEW(xres)		(xres)

#endif	/* ܡɰ¸ */

/* ץ졼 */
#define MWX			V_XRES
#define DSA			SH7785FB_VRAM_TOP
#define WASPY			0
#define WAMWY			V_YRES
#define SPX			0
#define SPY			0
#define DSX			XRES
#define DSY			YRES
#define DPX			0
#define DPY			0
#define ALPH			255		/* ե֥ */
#define DOO			0x000000FC	/* ֥롼꡼ */
#define BPO			0x00000000	/* طʿ */

#define MAX_PLANE_NUM		3
#define MAX_BLINK_NUM		2
#define CMAP_LEN		16

#define MAX_PIXEL_MEM_SIZE		(((V_XRES * V_YRES * BPP) / 8))
#define LINE_LENGTH			((XRES * BPP) / 8)
#define MAX_FRAMEBUFFER_MEM_SIZE	(MAX_PIXEL_MEM_SIZE)
#define ALLOCATED_FB_MEM_SIZE		(PAGE_ALIGN(MAX_FRAMEBUFFER_MEM_SIZE * MAX_BLINK_NUM + PAGE_SIZE))

/*
 * IOȥ
 */
#define SH7785FB_IOCTL_DEBUG_ADD	0x00
#define SH7785FB_IOCTL_DEBUG_GET	0x01
#define SH7785FB_IOCTL_DEBUG_PUT	0x02
#define SH7785FB_IOCTL_ENABLE		0x10
#define SH7785FB_IOCTL_OVERLAY		0x30
#define SH7785FB_IOCTL_PRIORITY		0x31
#define SH7785FB_IOCTL_TRANS_COLOR	0x32

#define SH7785FB_OVERLAY_YUYV		0x00100000
#define SH7785FB_OVERLAY_UYVY		0x00000000
#define SH7785FB_OVERLAY_YUV		0x00000003
#define SH7785FB_OVERLAY_RGB		0x00000001

/* 
 * Display Unit 쥸
 */
#if defined(CONFIG_CPU_SUBTYPE_SH7785) ||	\
    defined(CONFIG_CPU_SUBTYPE_SH7786)
# define SH7785FB_REG_TOP	0xFFF80000
#else
#error "Illegal CPU"
#endif

#define SH7785FB_DSYSR		(SH7785FB_REG_TOP + 0x0)
#define SH7785FB_DSMR		(SH7785FB_REG_TOP + 0x4)
#define SH7785FB_DSSR		(SH7785FB_REG_TOP + 0x8)
#define SH7785FB_DSRCR		(SH7785FB_REG_TOP + 0xc)
#define SH7785FB_DIER		(SH7785FB_REG_TOP + 0x10)
#define SH7785FB_CPCR		(SH7785FB_REG_TOP + 0x14)
#define SH7785FB_DPPR		(SH7785FB_REG_TOP + 0x18)
#define SH7785FB_DEFR		(SH7785FB_REG_TOP + 0x20)

#define SH7785FB_HDSR		(SH7785FB_REG_TOP + 0x40)
#define SH7785FB_HDER		(SH7785FB_REG_TOP + 0x44)
#define SH7785FB_VDSR		(SH7785FB_REG_TOP + 0x48)
#define SH7785FB_VDER		(SH7785FB_REG_TOP + 0x4c)
#define SH7785FB_HCR		(SH7785FB_REG_TOP + 0x50)
#define SH7785FB_HSWR		(SH7785FB_REG_TOP + 0x54)
#define SH7785FB_VCR		(SH7785FB_REG_TOP + 0x58)
#define SH7785FB_VSPR		(SH7785FB_REG_TOP + 0x5c)
#define SH7785FB_EQWR		(SH7785FB_REG_TOP + 0x60)
#define SH7785FB_SPWR		(SH7785FB_REG_TOP + 0x64)
#define SH7785FB_CLAMPSR	(SH7785FB_REG_TOP + 0x70)
#define SH7785FB_CLAMPWR	(SH7785FB_REG_TOP + 0x74)
#define SH7785FB_DESR		(SH7785FB_REG_TOP + 0x78)
#define SH7785FB_DEWR		(SH7785FB_REG_TOP + 0x7c)

#define SH7785FB_CP1TR		(SH7785FB_REG_TOP + 0x80)
#define SH7785FB_CP2TR		(SH7785FB_REG_TOP + 0x84)
#define SH7785FB_CP3TR		(SH7785FB_REG_TOP + 0x88)
#define SH7785FB_CP4TR		(SH7785FB_REG_TOP + 0x8c)

#define SH7785FB_DOOR		(SH7785FB_REG_TOP + 0x90)
#define SH7785FB_CDER		(SH7785FB_REG_TOP + 0x94)
#define SH7785FB_BPOR		(SH7785FB_REG_TOP + 0x98)
#define SH7785FB_RINTOFSR	(SH7785FB_REG_TOP + 0x9c)

/* PXZZZ = PXXX + (SH7785FB_PX_OFFSET * plane) ... plane = 0-5 */
#define SH7785FB_PX_OFFSET	0x100
#define SH7785FB_PXMR		(SH7785FB_REG_TOP + 0x100)
#define SH7785FB_PXMWR		(SH7785FB_REG_TOP + 0x104)
#define SH7785FB_PXALPHAR	(SH7785FB_REG_TOP + 0x108)
#define SH7785FB_PXDSXR		(SH7785FB_REG_TOP + 0x110)
#define SH7785FB_PXDSYR		(SH7785FB_REG_TOP + 0x114)
#define SH7785FB_PXDPXR		(SH7785FB_REG_TOP + 0x118)
#define SH7785FB_PXDPYR		(SH7785FB_REG_TOP + 0x11c)
#define SH7785FB_PXDSA0R	(SH7785FB_REG_TOP + 0x120)
#define SH7785FB_PXDSA1R	(SH7785FB_REG_TOP + 0x124)
#define SH7785FB_PXDSA2R	(SH7785FB_REG_TOP + 0x128)
#define SH7785FB_PXSPXR		(SH7785FB_REG_TOP + 0x130)
#define SH7785FB_PXSPYR		(SH7785FB_REG_TOP + 0x134)

#define SH7785FB_PXWASPR	(SH7785FB_REG_TOP + 0x138)
#define SH7785FB_PXWAMWR	(SH7785FB_REG_TOP + 0x13c)
#define SH7785FB_PXBTR		(SH7785FB_REG_TOP + 0x140)
#define SH7785FB_PXTC1R		(SH7785FB_REG_TOP + 0x144)
#define SH7785FB_PXTC2R		(SH7785FB_REG_TOP + 0x148)
#define SH7785FB_PXMLR		(SH7785FB_REG_TOP + 0x150)

#define SH7785FB_CPX_OFFSET	0x1000
#define SH7785FB_CPX_00R	(SH7785FB_REG_TOP + 0x1000)


#define SH7785FB_ESCR		(SH7785FB_REG_TOP + 0x10000)
#define SH7785FB_OTAR		(SH7785FB_REG_TOP + 0x10004)

#define SH7785FB_OUTL(v,p,o,reg)	(*(unsigned long *)(reg+(o*p)) = v)
#define SH7785FB_INL(p,o,reg)		(*(unsigned long *)(reg+(o*p)))

#define INFO_PAR(info,mem)	(((struct sh7785fb_par *)info.par)->mem)
#define INFO_HWPAR(info,mem)	(((struct sh7785fb_hw_par *)INFO_PAR(info,hw_par))->mem)

#define PRI_FB0		1
#define PRI_FB1		2
#define PRI_FB2		3

/*
 * ե졼Хåեѥ᡼
 */
struct sh7785fb_par {
	__u32 plane_number;
	__u32 enable;

	__u32 pxmr;
	__u32 pxmwr;
	__u32 pxalphar;

	__u32 pxdsxr;
	__u32 pxdsyr;
	__u32 pxdpxr;
	__u32 pxdpyr;
	__u32 pxdsa0r;
	__u32 pxdsa1r;
	__u32 pxdsa2r;

	__u32 pxspxr;
	__u32 pxspyr;
	__u32 pxwaspr;
	__u32 pxwamwr;
	__u32 pxbtr;
	__u32 pxtc1r;
	__u32 pxtc2r;

	__u32 pxmlr;

	struct sh7785fb_hw_par *hw_par;
};

/*
 * ȥѥ᡼
 */
struct sh7785fb_hw_par {

	__u32 dsysr_enable;
	__u32 dsysr_disable;
	__u32 dsmr;
	__u32 dssr;
	__u32 dsrcr;
	__u32 dier;
	__u32 cpcr;
	__u32 dppr;
	__u32 defr;

	__u32 hdsr;
	__u32 hder;
	__u32 vdsr;
	__u32 vder;
	__u32 hcr;
	__u32 hswr;
	__u32 vcr;
	__u32 vspr;
	__u32 eqwr;
	__u32 spwr;
	__u32 clampsr;
	__u32 clampwr;
	__u32 desr;
	__u32 dewr;
	__u32 cp1tr;
	__u32 cp2tr;
	__u32 cp3tr;
	__u32 cp4tr;
	__u32 door;
	__u32 cder;
	__u32 bpor;
	__u32 rintofsr;

	__u32 escr;
	__u32 otar;
};


struct sh7785fb_overlay {
	int yuv_type;
	int pxmwr;		/* ץ졼X */
	int pxmlr;		/* ץ졼Y */
	int pxdsxr;		/* ץ졼ɽX */
	int pxdsyr;		/* ץ졼ɽY */
	int pxdpxr;		/* ץ졼ɽX */
	int pxdpyr;		/* ץ졼ɽY */
	int pxspxr;		/* ץ졼ŽճX */
	int pxspyr;		/* ץ졼ŽճY */
	unsigned long pxdsa0r;
};

struct sh7785fb_priority {
	int pri_1st;
	int pri_2nd;
	int pri_3rd;
};

struct sh7785fb_trans_color {
	int fb_no;
	unsigned long trans_color;
};
